/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.jaxrs;

import com.fasterxml.jackson.core.JsonProcessingException;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ErrorResponse;
import de.virtimo.bpc.api.JsonPayloadSerializationException;
import de.virtimo.bpc.api.service.ErrorResponseService;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.BundleContext;

@Provider
public class JsonMappingExceptionMapper
implements ExceptionMapper<JsonProcessingException> {
    private static final Logger LOGGER = LogManager.getLogger(JsonMappingExceptionMapper.class);
    private final BundleContext bundleContext;
    private BpcServicesTracker<ErrorResponseService> errorResponseServiceTracker;
    @Context
    private ResourceInfo resourceInfo;

    public JsonMappingExceptionMapper(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void onStartup() {
        LOGGER.info("onStartup");
        this.errorResponseServiceTracker = new BpcServicesTracker<ErrorResponseService>(this.bundleContext, ErrorResponseService.class);
    }

    public void onShutdown() {
        LOGGER.info("onShutdown");
        BpcServicesTracker.stopAll(this);
    }

    public Response toResponse(JsonProcessingException exception) {
        LOGGER.debug("Called toResponse() due to a JsonProcessingException: {}", (Object)exception.getMessage());
        return ErrorResponse.forException(new JsonPayloadSerializationException(exception.getMessage())).usingTracker(this.errorResponseServiceTracker).build();
    }
}

