/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.logservice;

import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.JsonSchemaSettingValidator;
import de.virtimo.bpc.api.ModuleConfiguration;
import de.virtimo.bpc.api.Setting;
import de.virtimo.bpc.api.ValidationException;
import de.virtimo.bpc.api.db.DatabaseManager;
import de.virtimo.bpc.api.exception.BpcErrorCode;
import de.virtimo.bpc.api.exception.FrontendWarningException;
import de.virtimo.bpc.api.exception.LogServiceException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import de.virtimo.bpc.util.MapUtil;
import de.virtimo.bpc.util.StringUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.Configuration;

public class LogServiceModuleInstanceSettingsValidator
extends JsonSchemaSettingValidator {
    private static final Logger LOGGER = LogManager.getLogger(LogServiceModuleInstanceSettingsValidator.class);
    private final BpcServicesTracker<DatabaseManager> databaseManagerTracker;

    public LogServiceModuleInstanceSettingsValidator(BundleContext bundleContext) {
        super(bundleContext);
        this.databaseManagerTracker = new BpcServicesTracker<DatabaseManager>(bundleContext, DatabaseManager.class);
    }

    @Override
    public void destroy() {
        LOGGER.info("destroy");
        BpcServicesTracker.stopAll(this);
    }

    @Override
    public boolean canValidate(String moduleId, String moduleInstanceId, String instanceType) {
        return "logservice".equalsIgnoreCase(moduleId) && !ModuleConfiguration.isNoModuleInstanceId(moduleInstanceId);
    }

    @Override
    public boolean canValidate(Setting setting) {
        List<String> settingsToValidate = Arrays.asList("parentKeyFields", "childKeyFields", "parentFields", "childFields", "filestorageReadRestriction", "filestorageWriteRestriction");
        return settingsToValidate.contains(setting.getName());
    }

    @Override
    public List<FrontendWarningException> validate(Setting setting) throws ValidationException {
        Map settingMap;
        String parentKeyFieldsValue;
        Object object;
        LOGGER.info("validate setting:{}", (Object)setting);
        if ("parentKeyFields".equalsIgnoreCase(setting.getName()) && (!((object = setting.getValue()) instanceof String) || StringUtil.isNullOrEmpty(parentKeyFieldsValue = (String)object))) {
            throw new ValidationException((ErrorCode)BpcErrorCode.VALIDATION_MISSING_INPUT, "${field}: The parent key fields are missing.", MapUtil.mapOf("field", "parentKeyFields"));
        }
        if ("childKeyFields".equalsIgnoreCase(setting.getName())) {
            // empty if block
        }
        if ("parentFields".equalsIgnoreCase(setting.getName()) || "childFields".equalsIgnoreCase(setting.getName())) {
            this.validateJsonSchemaOfSetting(setting);
        }
        if (("filestorageReadRestriction".equalsIgnoreCase(setting.getName()) || "filestorageWriteRestriction".equalsIgnoreCase(setting.getName())) && (object = setting.getValue()) instanceof Map && !(settingMap = (Map)object).isEmpty()) {
            this.validateJsonSchemaOfSetting(setting);
        }
        return null;
    }

    @Override
    public List<FrontendWarningException> validate(String moduleId, String moduleInstanceId, String instanceType, Map<String, Setting> settings) throws ValidationException {
        Setting openSearchParentIndexSetting;
        LOGGER.info("validate moduleId={}, moduleInstanceId={}, instanceType={}, settings:...", (Object)moduleId, (Object)moduleInstanceId, (Object)instanceType);
        Setting openSearchLoggingEnabledSetting = settings.get("openSearchLoggingEnabled");
        if (openSearchLoggingEnabledSetting != null && ((Boolean)openSearchLoggingEnabledSetting.getValue()).booleanValue() && ((openSearchParentIndexSetting = settings.get("openSearchParentIndex")) == null || StringUtil.isNullOrEmpty((String)openSearchParentIndexSetting.getValue()))) {
            throw new ValidationException((ErrorCode)BpcErrorCode.VALIDATION_MISSING_INPUT, "${field}: The name of the parent index is missing.", MapUtil.mapOf("field", "openSearchParentIndex"));
        }
        Setting rdmsLogginEnabledSetting = settings.get("rdmsLoggingEnabled");
        if (rdmsLogginEnabledSetting != null && ((Boolean)rdmsLogginEnabledSetting.getValue()).booleanValue()) {
            String rdmsParentTable;
            Object object;
            String rdmsDataSourceName;
            Object object2;
            Setting rdmsDataSourceNameSetting = settings.get("rdmsDataSourceName");
            if (rdmsDataSourceNameSetting == null || !((object2 = rdmsDataSourceNameSetting.getValue()) instanceof String) || StringUtil.isNullOrEmpty(rdmsDataSourceName = (String)object2)) {
                throw new ValidationException((ErrorCode)BpcErrorCode.VALIDATION_MISSING_INPUT, "${field}: The data source name is missing.", MapUtil.mapOf("field", "rdmsDataSourceName"));
            }
            Setting rdmsParentTableSetting = settings.get("rdmsParentTable");
            if (rdmsParentTableSetting == null || !((object = rdmsParentTableSetting.getValue()) instanceof String) || StringUtil.isNullOrEmpty(rdmsParentTable = (String)object)) {
                throw new ValidationException((ErrorCode)BpcErrorCode.VALIDATION_MISSING_INPUT, "${field}: The parent table is missing.", MapUtil.mapOf("field", "rdmsParentTable"));
            }
            try {
                DatabaseManager databaseManager = this.databaseManagerTracker.getService();
                Configuration dataSourceConfiguration = databaseManager.getDataSourceConfiguration(rdmsDataSourceName);
                if (dataSourceConfiguration == null) {
                    throw new LogServiceException((ErrorCode)BpcErrorCode.VALIDATION_INVALID_INPUT, "${field}: The data source '${fieldValue}' does not exist", MapUtil.mapOf("field", "rdmsDataSourceName", "fieldValue", rdmsDataSourceName));
                }
            }
            catch (ServiceNotFoundException ex) {
                throw new ValidationException(ex.getErrorCode(), ex.getMessage(), ex);
            }
            catch (Exception ex) {
                throw new ValidationException((ErrorCode)CoreErrorCode.UNEXPECTED, "${field}: Could not get the data source configuration of '${fieldValue}'", MapUtil.mapOf("field", "rdmsDataSourceName", "fieldValue", rdmsDataSourceName), (Throwable)ex);
            }
        }
        return null;
    }
}

