/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.logservice.jsonschema;

import de.virtimo.bpc.logservice.LogServiceFieldTypeMappings;
import de.virtimo.bpc.logservice.LogServiceModuleInstance;
import de.virtimo.bpc.logservice.jsonschema.LogDataJsonSchema;
import de.virtimo.bpc.opensearch.plugin.utils.JsonUtil;
import de.virtimo.bpc.util.ListUtil;
import de.virtimo.bpc.util.MapUtil;
import de.virtimo.bpc.util.StringUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LogDataJsonSchemaBuilder {
    private static final Logger LOGGER = LogManager.getLogger(LogDataJsonSchemaBuilder.class);
    public static final String JSON_SCHEMA_SPECIFICATION_VERSION = "https://json-schema.org/draft/2020-12/schema";
    private String id = null;
    private final LogServiceFieldTypeMappings logServiceFieldTypeMappings = new LogServiceFieldTypeMappings();
    private LogServiceModuleInstance.KeysConfig keysConfig = null;
    private LogServiceModuleInstance.FieldsConfig fieldsConfig = null;
    private boolean createStrictJsonSchema = false;

    private LogDataJsonSchemaBuilder() {
    }

    public static LogDataJsonSchemaBuilder newInstance() {
        return new LogDataJsonSchemaBuilder();
    }

    public LogDataJsonSchemaBuilder withId(String id) {
        this.id = id;
        return this;
    }

    public LogDataJsonSchemaBuilder withKeysConfig(LogServiceModuleInstance.KeysConfig keysConfig) {
        this.keysConfig = keysConfig;
        return this;
    }

    public LogDataJsonSchemaBuilder withFieldsConfig(LogServiceModuleInstance.FieldsConfig fieldsConfig) {
        this.fieldsConfig = fieldsConfig;
        return this;
    }

    public LogDataJsonSchemaBuilder forStrictJsonSchema(boolean createStrictJsonSchema) {
        this.createStrictJsonSchema = createStrictJsonSchema;
        return this;
    }

    public LogDataJsonSchema build() {
        try {
            Map<String, Object> jsonSchemaAsMap = this.createJsonSchemaAsMap();
            String jsonSchemaAsString = JsonUtil.asJsonString(jsonSchemaAsMap);
            return new LogDataJsonSchema(jsonSchemaAsString);
        }
        catch (IOException ex) {
            LOGGER.error("Somehow failed to create the JSON schema for a log service instance.", (Throwable)ex);
            return null;
        }
    }

    private Map<String, Object> createJsonSchemaAsMap() {
        LinkedHashMap<String, Object> jsonSchemaMap = new LinkedHashMap<String, Object>();
        this.addMetadata(jsonSchemaMap);
        this.addRootFields(jsonSchemaMap);
        return jsonSchemaMap;
    }

    private void addMetadata(Map<String, Object> jsonSchemaMap) {
        jsonSchemaMap.put("$schema", JSON_SCHEMA_SPECIFICATION_VERSION);
        if (!StringUtil.isNullOrEmpty(this.id)) {
            jsonSchemaMap.put("$id", this.id);
        }
    }

    private void addRootFields(Map<String, Object> jsonSchemaMap) {
        jsonSchemaMap.putAll(MapUtil.mapOf("type", "object", "required", ListUtil.listOf("entries"), "additionalProperties", false, "properties", MapUtil.mapOf("entries", MapUtil.mapOf("type", "array", "items", this.createItemSchema()))));
    }

    private boolean areAdditionalPropertiesAllowed() {
        return !this.createStrictJsonSchema;
    }

    private Map<String, Object> createItemSchema() {
        LinkedHashMap<String, Object> entry = new LinkedHashMap<String, Object>();
        entry.put("type", "object");
        entry.put("additionalProperties", false);
        this.addRequiredFieldsIfNeeded(entry);
        this.addPropertiesIfConfigured(entry);
        return entry;
    }

    private void addRequiredFieldsIfNeeded(Map<String, Object> elseCondition) {
        ArrayList<String> required = new ArrayList<String>();
        if (this.hasConfiguredParentKeys() || this.hasConfiguredParentFields()) {
            required.add("parent");
        }
        if (this.hasConfiguredChildKeys() || this.hasConfiguredChildFields()) {
            required.add("children");
        }
        if (!required.isEmpty()) {
            if (required.size() == 2) {
                elseCondition.put("anyOf", ListUtil.listOf(MapUtil.mapOf("required", ListUtil.listOf("parent")), MapUtil.mapOf("required", ListUtil.listOf("children"), "properties", MapUtil.mapOf("children", MapUtil.mapOf("minItems", 1)))));
            } else {
                elseCondition.put("required", required);
            }
        }
    }

    private void addPropertiesIfConfigured(Map<String, Object> entry) {
        LinkedHashMap<String, Map<String, Object>> properties = new LinkedHashMap<String, Map<String, Object>>();
        if (this.hasConfiguredParentKeys() || this.hasConfiguredParentFields()) {
            properties.put("parent", this.createParentSchema());
        }
        if (this.hasConfiguredChildKeys() || this.hasConfiguredChildFields()) {
            properties.put("children", this.createChildrenSchema());
        }
        if (!properties.isEmpty()) {
            properties.put("partialUpdate", this.createPartialUpdateSchema());
        }
        if (!properties.isEmpty()) {
            entry.put("properties", properties);
        }
    }

    private Map<String, Object> createPartialUpdateSchema() {
        LinkedHashMap<String, Object> partialUpdate = new LinkedHashMap<String, Object>();
        partialUpdate.put("type", "boolean");
        return partialUpdate;
    }

    private Map<String, Object> createParentSchema() {
        LinkedHashMap<String, Object> parent = new LinkedHashMap<String, Object>();
        parent.put("type", "object");
        parent.put("additionalProperties", this.areAdditionalPropertiesAllowed());
        this.addRequiredOfParentSchemaIfNeeded(parent);
        this.addPropertiesOfParentSchemaIfConfigured(parent);
        return parent;
    }

    private void addRequiredOfParentSchemaIfNeeded(Map<String, Object> parent) {
        ArrayList<String> requiredFieldsOfParent = new ArrayList<String>();
        if (this.hasConfiguredParentKeys()) {
            requiredFieldsOfParent.addAll(this.keysConfig.parent.getIdColumnsAsList());
        }
        if (!requiredFieldsOfParent.isEmpty()) {
            parent.put("required", requiredFieldsOfParent);
        }
    }

    private void addPropertiesOfParentSchemaIfConfigured(Map<String, Object> parent) {
        LinkedHashMap<String, Object> propertiesOfParent = new LinkedHashMap<String, Object>();
        if (this.hasConfiguredParentFields()) {
            propertiesOfParent.putAll(this.createProperties(this.fieldsConfig.parent));
        }
        if (!propertiesOfParent.isEmpty()) {
            parent.put("properties", propertiesOfParent);
        }
    }

    private boolean hasConfiguredParentKeys() {
        return this.keysConfig != null && this.keysConfig.parent != null;
    }

    private boolean hasConfiguredParentFields() {
        return this.fieldsConfig != null && this.fieldsConfig.parent != null && !this.fieldsConfig.parent.isEmpty();
    }

    private Map<String, Object> createChildrenSchema() {
        LinkedHashMap<String, Object> children = new LinkedHashMap<String, Object>();
        children.put("type", "array");
        children.put("items", this.createChildItemSchema());
        return children;
    }

    private Map<String, Object> createChildItemSchema() {
        LinkedHashMap<String, Object> childItem = new LinkedHashMap<String, Object>();
        childItem.put("type", "object");
        childItem.put("additionalProperties", this.areAdditionalPropertiesAllowed());
        this.addRequiredOfChildItemSchemaIfNeeded(childItem);
        this.addPropertiesOfChildItemSchemaIfConfigured(childItem);
        return childItem;
    }

    private void addRequiredOfChildItemSchemaIfNeeded(Map<String, Object> items) {
        ArrayList<String> requiredFieldsOfChild = new ArrayList<String>();
        if (this.hasConfiguredChildKeys()) {
            requiredFieldsOfChild.addAll(this.keysConfig.child.getIdColumnsAsList());
        }
        if (!requiredFieldsOfChild.isEmpty()) {
            items.put("required", requiredFieldsOfChild);
        }
    }

    private void addPropertiesOfChildItemSchemaIfConfigured(Map<String, Object> childItem) {
        LinkedHashMap<String, Object> propertiesOfChild = new LinkedHashMap<String, Object>();
        if (this.hasConfiguredChildFields()) {
            propertiesOfChild.putAll(this.createProperties(this.fieldsConfig.child));
        }
        if (!propertiesOfChild.isEmpty()) {
            childItem.put("properties", propertiesOfChild);
        }
    }

    private boolean hasConfiguredChildKeys() {
        return this.keysConfig != null && this.keysConfig.child != null;
    }

    private boolean hasConfiguredChildFields() {
        return this.fieldsConfig != null && this.fieldsConfig.child != null && !this.fieldsConfig.child.isEmpty();
    }

    private Map<String, Object> createProperties(Map<String, LogServiceModuleInstance.FieldsConfig.Field> fields) {
        LOGGER.debug("createProperties fields={}", fields);
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        for (String fieldName : fields.keySet()) {
            LogServiceModuleInstance.FieldsConfig.Field field = fields.get(fieldName);
            if (field.skipOS && field.skipDB || !this.logServiceFieldTypeMappings.isKnownFieldType(field.type)) continue;
            Map<String, Object> jsonSchema = this.logServiceFieldTypeMappings.getJsonSchemaMapping(field.type);
            properties.put(fieldName, jsonSchema);
        }
        return properties;
    }
}

