/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.logservice.resource;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

@JsonIgnoreProperties(ignoreUnknown=false)
public class LogDataEntries
implements Iterable<Entry> {
    private final Map<String, Entry> orderedEntries = new LinkedHashMap<String, Entry>();

    @JsonIgnore
    public boolean isEmpty() {
        return this.orderedEntries.isEmpty();
    }

    @JsonProperty(value="entries")
    public List<Entry> getEntries() {
        ArrayList<Entry> result = new ArrayList<Entry>();
        this.orderedEntries.forEach((? super K logDataId, ? super V logDataEntry) -> result.add((Entry)logDataEntry));
        return result;
    }

    @JsonIgnore
    public List<String> getParentIDs() {
        ArrayList<String> result = new ArrayList<String>();
        this.orderedEntries.forEach((? super K logDataId, ? super V logDataEntry) -> result.add((String)logDataId));
        return result;
    }

    @JsonIgnore
    public void addEntry(String parentId, Map<String, Object> parentDocument) {
        this.addEntry(parentId, parentDocument, null);
    }

    @JsonIgnore
    public void addEntry(String parentId, Map<String, Object> parentDocument, List<Map<String, Object>> childDocuments) {
        this.orderedEntries.put(parentId, new Entry(parentDocument, childDocuments == null ? new ArrayList() : childDocuments));
    }

    @JsonIgnore
    public void addChildDocument(String parentId, Map<String, Object> childDocument) {
        Entry entry = this.orderedEntries.get(parentId);
        if (entry != null) {
            entry.childDocuments.add(childDocument);
        }
    }

    @Override
    @NotNull
    public Iterator<Entry> iterator() {
        return this.orderedEntries.values().iterator();
    }

    public String toString() {
        return "LogDataEntries{entries=" + String.valueOf(this.orderedEntries) + "}";
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public record Entry(@JsonProperty(value="parent") Map<String, Object> parentDocument, @JsonProperty(value="children") List<Map<String, Object>> childDocuments) {
        @JsonIgnore
        public boolean hasParentDocument() {
            return this.parentDocument != null;
        }

        @JsonIgnore
        public boolean hasChildDocuments() {
            return this.childDocuments != null;
        }
    }
}

