/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.logservice.resource;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.jaxrs.annotation.JacksonFeatures;
import com.networknt.schema.ValidationMessage;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.CoreBundleConfiguration;
import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.ErrorResponse;
import de.virtimo.bpc.api.ModuleInstance;
import de.virtimo.bpc.api.ModuleManager;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.api.exception.BpcErrorCode;
import de.virtimo.bpc.api.exception.LogServiceException;
import de.virtimo.bpc.api.exception.ModuleInstanceNotFoundException;
import de.virtimo.bpc.api.exception.ModuleNotFoundException;
import de.virtimo.bpc.api.exception.OpenSearchRelatedException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.service.ErrorResponseService;
import de.virtimo.bpc.core.CoreModule;
import de.virtimo.bpc.core.deeplink.Deeplink;
import de.virtimo.bpc.core.deeplink.DeeplinkException;
import de.virtimo.bpc.core.deeplink.monitor.MonitorInstanceInvestigator;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import de.virtimo.bpc.core.resource.response.SimpleModuleConfigImpl;
import de.virtimo.bpc.flow.IguasuHelper;
import de.virtimo.bpc.jaxrs.BpcEndpoint;
import de.virtimo.bpc.jaxrs.BpcRoleOrRightRequired;
import de.virtimo.bpc.jaxrs.OperationDescription;
import de.virtimo.bpc.jaxrs.ReturnDescription;
import de.virtimo.bpc.logservice.ExternalReferenceData;
import de.virtimo.bpc.logservice.LogServiceModule;
import de.virtimo.bpc.logservice.LogServiceModuleInstance;
import de.virtimo.bpc.logservice.jsonschema.LogDataJsonSchema;
import de.virtimo.bpc.logservice.resource.LogData;
import de.virtimo.bpc.logservice.resource.LogDataEntries;
import de.virtimo.bpc.util.EnumUtil;
import de.virtimo.bpc.util.JsonUtil;
import de.virtimo.bpc.util.MapUtil;
import de.virtimo.bpc.util.StringUtil;
import de.virtimo.bpc.util.TimeZoneUtil;
import de.virtimo.bpc.util.UriQueryUtil;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.BundleContext;

@Path(value="")
@Tag(name="Log Service API", description="These are the endpoints of the log service.")
public class LogServiceEndpoint {
    private static final Logger LOGGER = LogManager.getLogger(LogServiceEndpoint.class);
    private final BundleContext bundleContext;
    private BpcServicesTracker<ModuleManager> moduleManagerTracker;
    private BpcServicesTracker<ErrorResponseService> errorResponseServiceTracker;
    private BpcServicesTracker<CoreBundleConfiguration> coreBundleConfigurationTracker;

    public LogServiceEndpoint(BundleContext bundleContext) {
        LOGGER.info("LogServiceEndpoint bundleContext={}", (Object)bundleContext);
        this.bundleContext = bundleContext;
    }

    public void onStartup() {
        LOGGER.info("onStartup");
        this.moduleManagerTracker = new BpcServicesTracker<ModuleManager>(this.bundleContext, ModuleManager.class);
        this.errorResponseServiceTracker = new BpcServicesTracker<ErrorResponseService>(this.bundleContext, ErrorResponseService.class);
        this.coreBundleConfigurationTracker = new BpcServicesTracker<CoreBundleConfiguration>(this.bundleContext, CoreBundleConfiguration.class);
    }

    public void onShutdown() {
        LOGGER.info("onShutdown");
        BpcServicesTracker.stopAll(this);
    }

    private LogServiceModule getLogServiceModule() throws ServiceNotFoundException, ModuleNotFoundException {
        return (LogServiceModule)this.moduleManagerTracker.getService().getModuleById("logservice");
    }

    private CoreModule getCoreModule() throws ServiceNotFoundException, ModuleNotFoundException {
        return (CoreModule)this.moduleManagerTracker.getService().getModuleById("_core");
    }

    @GET
    @Path(value="/log/instances")
    @Produces(value={"application/json"})
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcRoleOrRightRequired(role="LOG_SERVICE_USER", right="LOG_SERVICE_CONFIG_GET_INSTANCES")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="401", description="Authentication could not be performed"), @ApiResponse(responseCode="503", description="BPC is currently in maintenance mode")})
    @OperationDescription(summary="Get a compact overview of the available log service instances.", description="Get a compact overview of the available log service instances.\n\nOnly the following data is returned for each instance:\n\n- module instance ID\n- name\n- description\n- flag whether the instance is enabled\n")
    @ReturnDescription(value="The log service instances as JSON.")
    public Response getInstances(@Context HttpServletRequest req) {
        LOGGER.info("getInstances");
        try {
            return this.process(req, logServiceModule -> {
                ArrayList<Map<String, Boolean>> instances = new ArrayList<Map<String, Boolean>>();
                for (ModuleInstance moduleInstance : logServiceModule.getModuleInstances().values()) {
                    LogServiceModuleInstance logServiceModuleInstance = (LogServiceModuleInstance)moduleInstance;
                    instances.add(Map.of("id", logServiceModuleInstance.getModuleId(), "name", logServiceModuleInstance.getConfiguration().getSettingValue("module_name").asString(""), "description", logServiceModuleInstance.getConfiguration().getSettingValue("moduleHeader_description").asString(""), "enabled", logServiceModuleInstance.isEnabled()));
                }
                return Response.ok(Map.of("instances", instances)).build();
            });
        }
        catch (Exception ex) {
            LOGGER.error("Get list of log service instances failed.", (Throwable)ex);
            return ErrorResponse.forException(ex).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @GET
    @Path(value="/log/instances/{instanceIdOrName}")
    @Produces(value={"application/json"})
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcRoleOrRightRequired(role="LOG_SERVICE_USER", right="LOG_SERVICE_CONFIG_GET_INSTANCE")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=SimpleModuleConfigImpl.class))}), @ApiResponse(responseCode="401", description="Authentication could not be performed"), @ApiResponse(responseCode="404", description="Module instance was not found"), @ApiResponse(responseCode="503", description="BPC is currently in maintenance mode")})
    @OperationDescription(summary="Get the current configuration of the log service instance.", description="Get the current configuration of the log service instance.")
    @ReturnDescription(value="The requested config as JSON.")
    public Response getInstanceConfig(@Parameter(description="this can be either the ID or a unique name of the module instance") @PathParam(value="instanceIdOrName") String instanceIdOrName, @Context HttpServletRequest req) {
        LOGGER.info("getInstanceConfig instanceIdOrName={}", (Object)instanceIdOrName);
        try {
            EnumSet<Check> checks = EnumSet.noneOf(Check.class);
            return this.process(req, instanceIdOrName, checks, (logServiceModule, logServiceModuleInstance) -> Response.ok((Object)new SimpleModuleConfigImpl(logServiceModuleInstance)).build());
        }
        catch (Exception ex) {
            LOGGER.error("Get log service instance config failed.", (Throwable)ex);
            return ErrorResponse.forException(ex).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @GET
    @Path(value="/log/{instanceIdOrName}")
    @Produces(value={"application/json"})
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcRoleOrRightRequired(role="LOG_SERVICE_USER", right="LOG_SERVICE_READ_DATA")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=LogDataEntries.class))}), @ApiResponse(responseCode="401", description="Authentication could not be performed"), @ApiResponse(responseCode="404", description="Module instance was not found"), @ApiResponse(responseCode="503", description="BPC or instance are currently in maintenance mode")})
    @OperationDescription(summary="Gets the data of a log service instance.", description="Gets the data of a log service instance.")
    @ReturnDescription(value="The requested data as JSON.")
    public Response getData(@Parameter(description="this can be either the ID or a unique name of the module instance") @PathParam(value="instanceIdOrName") String instanceIdOrName, @Parameter(description="timezone offset like `GMT+2` (optional). Is used if a date field is accessed in the `parentFilter` with a range operator like \"gt\", \"gte\", \"lt\", \"lte\", \">\", \">=\", \"<\", \"\\<=\". UTC is the default. `timezoneName` is used before `timezoneOffset` if both are set.") @QueryParam(value="timezoneOffset") String timezoneOffset, @Parameter(description="timezone name like `Europe/Berlin` (optional). Is used if a date field is accessed in the `parentFilter` with a range operator like \"gt\", \"gte\", \"lt\", \"lte\", \">\", \">=\", \"<\", \"\\<=\". UTC is the default. `timezoneName` is used before `timezoneOffset` if both are set.") @QueryParam(value="timezoneName") String timezoneName, @Parameter(description="first record to be read (optional, default = 0)") @QueryParam(value="start") Integer start, @Parameter(description="number of records to read (optional, default = 100, max. 10.000)") @QueryParam(value="limit") Integer limit, @Parameter(description="simple search (optional). Example `city:berlin`. Additional information of the https://opensearch.org/docs/latest/query-dsl/full-text/query-string/[Lucene Query String Syntax].") @QueryParam(value="parentQuery") String parentQuery, @Parameter(description="complex filter format like done from the monitor endpoint (optional). Example: `[{\"property\":\"processid\",\"operator\":\"gte\",\"value\":1000,\"source\":\"raw\",\"invert\":false}]`") @QueryParam(value="parentFilter") String parentFilter, @Parameter(description="determination by which field the parent entries should be sorted (optional, default = parent key descending). Format: fieldname\\|[ASC\\|DESC]. Example: `processid\\|DESC`. Multiple sorting instructions can be specified comma separated.") @QueryParam(value="parentSort") String parentSort, @Parameter(description="should the response contain the log service child entries?") @QueryParam(value="addChildren") @DefaultValue(value="true") boolean addChildren, @Parameter(description="should the response contain the log service child entries? Deprecated, please use 'addChildren' instead.") @QueryParam(value="addChilds") Boolean addChilds, @Parameter(description="determination by which field the child entries should be sorted (optional, default = child key ascending). Format: fieldname\\|[ASC\\|DESC]. Example: `childid\\|ASC`. Multiple sorting instructions can be specified comma separated.") @QueryParam(value="childSort") String childSort, @Context HttpServletRequest req) {
        LOGGER.info("getData instanceIdOrName={}", (Object)instanceIdOrName);
        try {
            boolean finalAddChildren = addChilds != null ? addChilds : addChildren;
            EnumSet<Check> checks = EnumSet.of(Check.IF_MODULE_INSTANCE_MAINTENANCE_MODE_ENABLED);
            return this.process(req, instanceIdOrName, checks, (logServiceModule, logServiceModuleInstance) -> {
                String timeZoneId = TimeZoneUtil.evalTimeZoneId(timezoneOffset, timezoneName);
                LogDataEntries logDataEntries = logServiceModule.getLogDataEntries(logServiceModuleInstance, timeZoneId, start, limit, parentQuery, parentFilter, parentSort, finalAddChildren, childSort);
                return Response.ok((Object)logDataEntries).build();
            });
        }
        catch (Exception ex) {
            LOGGER.error("Get config or data failed.", (Throwable)ex);
            return ErrorResponse.forException(ex).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @GET
    @Path(value="/log/{instanceIdOrName}/{parentId}")
    @Produces(value={"application/json"})
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcRoleOrRightRequired(role="LOG_SERVICE_USER", right="LOG_SERVICE_READ_DATA")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=LogDataEntries.class))}), @ApiResponse(responseCode="401", description="Authentication could not be performed"), @ApiResponse(responseCode="404", description="Module instance was not found"), @ApiResponse(responseCode="503", description="BPC or instance are currently in maintenance mode")})
    @OperationDescription(summary="Get the data of a log service entry with its child entries.", description="Get the data of a log service entry with its child entries.")
    @ReturnDescription(value="The requested data as JSON.")
    public Response getData(@Parameter(description="this can be either the ID or a unique name of the module instance") @PathParam(value="instanceIdOrName") String instanceIdOrName, @Parameter(description="the ID of the requested log service entry") @PathParam(value="parentId") String parentId, @Parameter(description="timezone offset like `GMT+2` (optional). Is used if a date field is accessed in the `childFilter` with a range operator like \"gt\", \"gte\", \"lt\", \"lte\", \">\", \">=\", \"<\", \"\\<=\". UTC is the default. `timezoneName` is used before `timezoneOffset` if both are set.") @QueryParam(value="timezoneOffset") String timezoneOffset, @Parameter(description="timezone name like `Europe/Berlin` (optional). Is used if a date field is accessed in the `childFilter` with a range operator like \"gt\", \"gte\", \"lt\", \"lte\", \">\", \">=\", \"<\", \"\\<=\". UTC is the default. `timezoneName` is used before `timezoneOffset` if both are set.") @QueryParam(value="timezoneName") String timezoneName, @Parameter(description="simple search (optional). Example `city:berlin`. Additional information of the https://opensearch.org/docs/latest/query-dsl/full-text/query-string/[Lucene Query String Syntax].") @QueryParam(value="childQuery") String childQuery, @Parameter(description="complex filter format like done from the monitor endpoint (optional). Example: `[{\"property\":\"processid\",\"operator\":\"gte\",\"value\":1000,\"source\":\"raw\",\"invert\":false}]`") @QueryParam(value="childFilter") String childFilter, @Context HttpServletRequest req) {
        LOGGER.info("getData instanceIdOrName={}, parentId={}", (Object)instanceIdOrName, (Object)parentId);
        try {
            EnumSet<Check> checks = EnumSet.of(Check.IF_MODULE_INSTANCE_MAINTENANCE_MODE_ENABLED);
            return this.process(req, instanceIdOrName, checks, (logServiceModule, logServiceModuleInstance) -> {
                LogDataEntries logDataEntries;
                if (childQuery == null && childFilter == null) {
                    logDataEntries = logServiceModule.getLogDataEntries(logServiceModuleInstance, parentId);
                } else {
                    String timeZoneId = TimeZoneUtil.evalTimeZoneId(timezoneOffset, timezoneName);
                    logDataEntries = logServiceModule.getLogDataEntries(logServiceModuleInstance, parentId, timeZoneId, childQuery, childFilter);
                }
                return Response.ok((Object)logDataEntries).build();
            });
        }
        catch (Exception ex) {
            LOGGER.error("Getting the requested log data by parentId failed.", (Throwable)ex);
            return ErrorResponse.forException(ex).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @GET
    @Path(value="/log/{instanceIdOrName}/{parentId}/{childId}")
    @Produces(value={"application/json"})
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcRoleOrRightRequired(role="LOG_SERVICE_USER", right="LOG_SERVICE_READ_DATA")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=LogDataEntries.class))}), @ApiResponse(responseCode="401", description="Authentication could not be performed"), @ApiResponse(responseCode="404", description="Module instance was not found"), @ApiResponse(responseCode="503", description="BPC or instance are currently in maintenance mode")})
    @OperationDescription(summary="Get the data of a log service child entry.", description="Get the data of a log service child entry.")
    @ReturnDescription(value="The requested data as JSON.")
    public Response getData(@Parameter(description="this can be either the ID or a unique name of the module instance") @PathParam(value="instanceIdOrName") String instanceIdOrName, @Parameter(description="the ID of the requested log service entry") @PathParam(value="parentId") String parentId, @Parameter(description="the ID of the requested child entry") @PathParam(value="childId") String childId, @Context HttpServletRequest req) {
        LOGGER.info("getData instanceIdOrName={}, parentId={}, childId={}", (Object)instanceIdOrName, (Object)parentId, (Object)childId);
        try {
            EnumSet<Check> checks = EnumSet.of(Check.IF_MODULE_INSTANCE_MAINTENANCE_MODE_ENABLED);
            return this.process(req, instanceIdOrName, checks, (logServiceModule, logServiceModuleInstance) -> {
                LogDataEntries logDataEntries = logServiceModule.getLogDataEntries(logServiceModuleInstance, parentId, childId);
                return Response.ok((Object)logDataEntries).build();
            });
        }
        catch (Exception ex) {
            LOGGER.error("Getting the requested log data by parentId and childId failed.", (Throwable)ex);
            return ErrorResponse.forException(ex).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @POST
    @Path(value="/log/{instanceIdOrName}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @BpcRoleOrRightRequired(role="LOG_SERVICE_USER", right="LOG_SERVICE_WRITE_DATA")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Data has been written"), @ApiResponse(responseCode="400", description="None or invalid data to log given"), @ApiResponse(responseCode="401", description="Authentication could not be performed"), @ApiResponse(responseCode="404", description="Module instance was not found"), @ApiResponse(responseCode="500", description="Failed to write the data"), @ApiResponse(responseCode="503", description="Maintenance mode is active or OpenSearch and database are not activated")})
    @OperationDescription(summary="Writes provided data to OpenSearch and/or the database.", description="Writes the data provided in the body to OpenSearch and/or the database.\n\nFor calls from Iguasu the following HTTP headers are used and their values written to the following 'externalReference' object fields of all 'parent' related documents:\n\n!===\n!HTTP Header         !'externalReference' field\n\n!IGUASU-System-ID    !externalReference.system\n!IGUASU-Instance-ID  !externalReference.instance\n!IGUASU-Processor-ID !externalReference.processor\n!IGUASU-Service-ID   !externalReference.service\n!===\n")
    public Response log(@Parameter(description="this can be either the ID or a unique name of the module instance") @PathParam(value="instanceIdOrName") String instanceIdOrName, @Parameter(description="'true' to perform the log asynchronously. 'false' to perform synchronously.") @QueryParam(value="async") @DefaultValue(value="false") boolean async, @Parameter(description="the optional JSON schema validation mode to be used. If not set the related Log Service instance setting gets used. Valid values are 'Off', 'Regular' and 'Strict'.") @QueryParam(value="validation") String jsonSchemaValidationModeQueryParam, @Context UserSession userSession, @Context HttpServletRequest req, @Context HttpHeaders hh, String json) {
        LOGGER.info("log ({})", (Object)(async ? "asynchron" : "synchron"));
        try {
            EnumSet<Check> checks = EnumSet.of(Check.IF_MODULE_INSTANCE_MAINTENANCE_MODE_ENABLED, Check.IF_USED_OPENSEARCH_INDICES_AVAILABLE);
            return this.process(req, instanceIdOrName, checks, (logServiceModule, logServiceModuleInstance) -> {
                LogData logData;
                if (StringUtil.isNullOrEmpty(json)) {
                    throw new LogServiceException((ErrorCode)BpcErrorCode.VALIDATION_MISSING_INPUT, "No data to log given");
                }
                JsonNode jsonNode = JsonUtil.getInstance().convertJsonStringToJsonNode(json);
                LogServiceModuleInstance.JsonSchemaValidationMode jsonSchemaValidationMode = this.getJsonSchemaValidationMode(jsonSchemaValidationModeQueryParam, logServiceModuleInstance);
                if (jsonSchemaValidationMode != LogServiceModuleInstance.JsonSchemaValidationMode.Off) {
                    boolean strictJsonSchemaValidation = jsonSchemaValidationMode == LogServiceModuleInstance.JsonSchemaValidationMode.Strict;
                    this.validateJsonByJsonSchema(jsonNode, logServiceModuleInstance, strictJsonSchemaValidation);
                }
                try {
                    logData = JsonUtil.getInstance().convertJsonNodeToPojo(jsonNode, LogData.class);
                }
                catch (IOException ex) {
                    throw new LogServiceException((ErrorCode)BpcErrorCode.VALIDATION_INVALID_INPUT, "Could not convert the given data to a LogData object. Invalid JSON structure?", ex);
                }
                if (logData == null || logData.isEmpty()) {
                    throw new LogServiceException((ErrorCode)BpcErrorCode.VALIDATION_MISSING_INPUT, "No JSON data to log given");
                }
                ExternalReferenceData externalReferenceData = IguasuHelper.extractIguasuSpecificHeaderValues(hh);
                logServiceModule.log(async, logServiceModuleInstance, logData, externalReferenceData, userSession);
                return Response.ok().build();
            });
        }
        catch (Exception ex) {
            LOGGER.error("Logging failed", (Throwable)ex);
            return ErrorResponse.forException(ex).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    private LogServiceModuleInstance.JsonSchemaValidationMode getJsonSchemaValidationMode(String jsonSchemaValidationModeQueryParam, LogServiceModuleInstance logServiceModuleInstance) {
        LogServiceModuleInstance.JsonSchemaValidationMode jsonSchemaValidationMode = null;
        if (jsonSchemaValidationModeQueryParam != null) {
            jsonSchemaValidationMode = EnumUtil.getValueAsEnum(jsonSchemaValidationModeQueryParam, LogServiceModuleInstance.JsonSchemaValidationMode.class, null);
        }
        if (jsonSchemaValidationMode == null) {
            jsonSchemaValidationMode = logServiceModuleInstance.getJsonSchemaValidationMode();
        }
        return jsonSchemaValidationMode;
    }

    private void validateJsonByJsonSchema(JsonNode jsonNode, LogServiceModuleInstance logServiceModuleInstance, boolean strict) throws LogServiceException {
        LogDataJsonSchema logDataJsonSchema = logServiceModuleInstance.getLogDataJsonSchema(strict);
        Set validationMessages = logDataJsonSchema.asJsonSchema().validate(jsonNode);
        if (validationMessages != null && !validationMessages.isEmpty()) {
            ValidationMessage firstValidationMessage = (ValidationMessage)validationMessages.stream().findFirst().get();
            throw new LogServiceException((ErrorCode)BpcErrorCode.VALIDATION_INVALID_INPUT, firstValidationMessage.getMessage());
        }
    }

    @DELETE
    @Path(value="/log/{instanceIdOrName}/{parentId}")
    @Produces(value={"application/json"})
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcRoleOrRightRequired(role="LOG_SERVICE_USER", right="LOG_SERVICE_DELETE_DATA")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Data has been deleted"), @ApiResponse(responseCode="401", description="Authentication could not be performed"), @ApiResponse(responseCode="404", description="Module instance was not found"), @ApiResponse(responseCode="500", description="Delete failed"), @ApiResponse(responseCode="503", description="Maintenance mode is active or OpenSearch and database are not activated")})
    @OperationDescription(summary="Deletes log service entries and their child entries from OpenSearch and the database.", description="Deletes log service entries and their child entries from OpenSearch and the database.\nAttention: When you use 'childQuery' and/or 'childFilter' only those children get deleted, not the parent itself.\n")
    public Response deleteEntry(@Parameter(description="this can be either the ID or a unique name of the module instance") @PathParam(value="instanceIdOrName") String instanceIdOrName, @Parameter(description="the ID of the log service entry to delete, multiple entries can be provided and must be separated by comma") @PathParam(value="parentId") String parentId, @Parameter(description="timezone offset like `GMT+2` (optional). Is used if a date field is accessed in the `childFilter` with a range operator like \"gt\", \"gte\", \"lt\", \"lte\", \">\", \">=\", \"<\", \"\\<=\". UTC is the default. `timezoneName` is used before `timezoneOffset` if both are set.") @QueryParam(value="timezoneOffset") String timezoneOffset, @Parameter(description="timezone name like `Europe/Berlin` (optional). Is used if a date field is accessed in the `childFilter` with a range operator like \"gt\", \"gte\", \"lt\", \"lte\", \">\", \">=\", \"<\", \"\\<=\". UTC is the default. `timezoneName` is used before `timezoneOffset` if both are set.") @QueryParam(value="timezoneName") String timezoneName, @Parameter(description="simple search (optional). Example `city:berlin`. Additional information of the https://opensearch.org/docs/latest/query-dsl/full-text/query-string/[Lucene Query String Syntax].") @QueryParam(value="childQuery") String childQuery, @Parameter(description="complex filter format like done from the monitor endpoint (optional). Example: `[{\"property\":\"processid\",\"operator\":\"gte\",\"value\":1000,\"source\":\"raw\",\"invert\":false}]`") @QueryParam(value="childFilter") String childFilter, @Context HttpServletRequest req) {
        LOGGER.info("deleteEntry instanceIdOrName={}, parentId={}", (Object)instanceIdOrName, (Object)parentId);
        try {
            EnumSet<Check> checks = EnumSet.of(Check.IF_MODULE_INSTANCE_MAINTENANCE_MODE_ENABLED, Check.IF_USED_OPENSEARCH_INDICES_AVAILABLE);
            return this.process(req, instanceIdOrName, checks, (logServiceModule, logServiceModuleInstance) -> {
                if (childQuery == null && childFilter == null) {
                    List<String> parentIDs = StringUtil.explode(parentId, ",");
                    logServiceModule.deleteEntries(logServiceModuleInstance, parentIDs);
                } else {
                    String timeZoneId = TimeZoneUtil.evalTimeZoneId(timezoneOffset, timezoneName);
                    logServiceModule.deleteChildEntries(logServiceModuleInstance, parentId, timeZoneId, childQuery, childFilter);
                }
                return Response.ok().build();
            });
        }
        catch (Exception ex) {
            LOGGER.error("Delete failed.", (Throwable)ex);
            return ErrorResponse.forException(ex).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @DELETE
    @Path(value="/log/{instanceIdOrName}/{parentId}/{childId}")
    @Produces(value={"application/json"})
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcRoleOrRightRequired(role="LOG_SERVICE_USER", right="LOG_SERVICE_DELETE_DATA")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Data has been deleted"), @ApiResponse(responseCode="401", description="Authentication could not be performed"), @ApiResponse(responseCode="404", description="Module instance was not found"), @ApiResponse(responseCode="500", description="Delete failed"), @ApiResponse(responseCode="503", description="Maintenance mode is active or OpenSearch and database are not activated")})
    @OperationDescription(summary="Deletes log service child entries from OpenSearch and the database.", description="Deletes log service child entries from OpenSearch and the database.")
    public Response deleteChildEntries(@Parameter(description="this can be either the ID or a unique name of the module instance") @PathParam(value="instanceIdOrName") String instanceIdOrName, @Parameter(description="the ID of the log service entry to delete the child entries from") @PathParam(value="parentId") String parentId, @Parameter(description="the ID of the child entry to delete, multiple entries can be provided and must be separated by comma") @PathParam(value="childId") String childId, @Context HttpServletRequest req) {
        LOGGER.info("deleteChildEntries instanceIdOrName={}, parentId={}, childId={}", (Object)instanceIdOrName, (Object)parentId, (Object)childId);
        try {
            EnumSet<Check> checks = EnumSet.of(Check.IF_MODULE_INSTANCE_MAINTENANCE_MODE_ENABLED, Check.IF_USED_OPENSEARCH_INDICES_AVAILABLE);
            return this.process(req, instanceIdOrName, checks, (logServiceModule, logServiceModuleInstance) -> {
                List<String> childIDs = StringUtil.explode(childId, ",");
                logServiceModule.deleteChildEntries(logServiceModuleInstance, parentId, childIDs);
                return Response.ok().build();
            });
        }
        catch (Exception ex) {
            LOGGER.error("Delete child entries failed.", (Throwable)ex);
            return ErrorResponse.forException(ex).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @DELETE
    @Path(value="/log/{instanceIdOrName}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @BpcRoleOrRightRequired(role="LOG_SERVICE_USER", right="LOG_SERVICE_DELETE_DATA")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Data has been deleted"), @ApiResponse(responseCode="401", description="Authentication could not be performed"), @ApiResponse(responseCode="404", description="Module instance was not found"), @ApiResponse(responseCode="500", description="Delete failed"), @ApiResponse(responseCode="503", description="Maintenance mode is active or OpenSearch and database are not activated")})
    @OperationDescription(summary="Deletes log service entries and their child entries from OpenSearch by query. Deletion from database is not supported.", description="Deletes log service entries and their child entries from OpenSearch by query. Deletion from database is not supported.")
    public Response deleteEntries(@Parameter(description="this can be either the ID or a unique name of the module instance") @PathParam(value="instanceIdOrName") String instanceIdOrName, @Parameter(description="timezone offset like `GMT+2` (optional). Is used if a date field is accessed in the `parentFilter` with a range operator like \"gt\", \"gte\", \"lt\", \"lte\", \">\", \">=\", \"<\", \"\\<=\". UTC is the default. `timezoneName` is used before `timezoneOffset` if both are set.") @QueryParam(value="timezoneOffset") String timezoneOffset, @Parameter(description="timezone name like `Europe/Berlin` (optional). Is used if a date field is accessed in the `parentFilter` with a range operator like \"gt\", \"gte\", \"lt\", \"lte\", \">\", \">=\", \"<\", \"\\<=\". UTC is the default. `timezoneName` is used before `timezoneOffset` if both are set.") @QueryParam(value="timezoneName") String timezoneName, @Parameter(description="simple search (optional). Example `city:berlin`. Additional information of the https://opensearch.org/docs/latest/query-dsl/full-text/query-string/[Lucene Query String Syntax].") @QueryParam(value="parentQuery") String parentQuery, @Parameter(description="complex filter format like done from the monitor endpoint (optional). Example: `[{\"property\":\"processid\",\"operator\":\"gte\",\"value\":1000,\"source\":\"raw\",\"invert\":false}]`") @QueryParam(value="parentFilter") String parentFilter, @Context HttpServletRequest req) {
        LOGGER.info("deleteEntries instanceIdOrName={}", (Object)instanceIdOrName);
        try {
            if (StringUtil.isNullOrEmpty(parentQuery) && StringUtil.isNullOrEmpty(parentFilter)) {
                throw new LogServiceException((ErrorCode)BpcErrorCode.VALIDATION_MISSING_INPUT, "No query and no filter given.");
            }
            EnumSet<Check> checks = EnumSet.of(Check.IF_MODULE_INSTANCE_MAINTENANCE_MODE_ENABLED, Check.IF_USED_OPENSEARCH_INDICES_AVAILABLE);
            return this.process(req, instanceIdOrName, checks, (logServiceModule, logServiceModuleInstance) -> {
                String timeZoneId = TimeZoneUtil.evalTimeZoneId(timezoneOffset, timezoneName);
                logServiceModule.deleteEntries(logServiceModuleInstance, timeZoneId, parentQuery, parentFilter);
                return Response.ok().build();
            });
        }
        catch (Exception ex) {
            LOGGER.error("Delete failed.", (Throwable)ex);
            return ErrorResponse.forException(ex).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @DELETE
    @Path(value="/log/{instanceIdOrName}/children")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @BpcRoleOrRightRequired(role="LOG_SERVICE_USER", right="LOG_SERVICE_DELETE_DATA")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Data has been deleted"), @ApiResponse(responseCode="401", description="Authentication could not be performed"), @ApiResponse(responseCode="404", description="Module instance was not found"), @ApiResponse(responseCode="500", description="Delete failed"), @ApiResponse(responseCode="503", description="Maintenance mode is active or OpenSearch and database are not activated")})
    @OperationDescription(summary="Deletes only log service child entries from OpenSearch by query. Deletion from database is not supported.", description="Deletes only log service child entries from OpenSearch by query. Deletion from database is not supported.")
    public Response deleteChildEntries(@Parameter(description="this can be either the ID or a unique name of the module instance") @PathParam(value="instanceIdOrName") String instanceIdOrName, @Parameter(description="timezone offset like `GMT+2` (optional). Is used if a date field is accessed in the `childFilter` with a range operator like \"gt\", \"gte\", \"lt\", \"lte\", \">\", \">=\", \"<\", \"\\<=\". UTC is the default. `timezoneName` is used before `timezoneOffset` if both are set.") @QueryParam(value="timezoneOffset") String timezoneOffset, @Parameter(description="timezone name like `Europe/Berlin` (optional). Is used if a date field is accessed in the `childFilter` with a range operator like \"gt\", \"gte\", \"lt\", \"lte\", \">\", \">=\", \"<\", \"\\<=\". UTC is the default. `timezoneName` is used before `timezoneOffset` if both are set.") @QueryParam(value="timezoneName") String timezoneName, @Parameter(description="simple search (optional). Example `city:berlin`. Additional information of the https://opensearch.org/docs/latest/query-dsl/full-text/query-string/[Lucene Query String Syntax].") @QueryParam(value="childQuery") String childQuery, @Parameter(description="complex filter format like done from the monitor endpoint (optional). Example: `[{\"property\":\"processid\",\"operator\":\"gte\",\"value\":1000,\"source\":\"raw\",\"invert\":false}]`") @QueryParam(value="childFilter") String childFilter, @Context HttpServletRequest req) {
        LOGGER.info("deleteChildEntries instanceIdOrName={}", (Object)instanceIdOrName);
        try {
            if (StringUtil.isNullOrEmpty(childQuery) && StringUtil.isNullOrEmpty(childFilter)) {
                throw new LogServiceException((ErrorCode)BpcErrorCode.VALIDATION_MISSING_INPUT, "No query and no filter given.");
            }
            EnumSet<Check> checks = EnumSet.of(Check.IF_MODULE_INSTANCE_MAINTENANCE_MODE_ENABLED, Check.IF_USED_OPENSEARCH_INDICES_AVAILABLE);
            return this.process(req, instanceIdOrName, checks, (logServiceModule, logServiceModuleInstance) -> {
                String timeZoneId = TimeZoneUtil.evalTimeZoneId(timezoneOffset, timezoneName);
                logServiceModule.deleteChildEntries(logServiceModuleInstance, timeZoneId, childQuery, childFilter);
                return Response.ok().build();
            });
        }
        catch (Exception ex) {
            LOGGER.error("Delete child entries failed.", (Throwable)ex);
            return ErrorResponse.forException(ex).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @DELETE
    @Path(value="/log/drop/indices/{instanceIdOrName}")
    @Produces(value={"application/json"})
    @BpcRoleOrRightRequired(role="LOG_SERVICE_USER", right="LOG_SERVICE_DROP_INDICES")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Indices deleted"), @ApiResponse(responseCode="401", description="Authentication could not be performed"), @ApiResponse(responseCode="404", description="Module instance was not found"), @ApiResponse(responseCode="500", description="Delete failed"), @ApiResponse(responseCode="503", description="Maintenance mode is active or OpenSearch and database are not activated")})
    @OperationDescription(summary="Deletes/drops the parent and child indices of a log service instance.", description="Deletes/drops the parent and child indices of a log service instance.")
    public Response dropIndices(@Parameter(description="this can be either the ID or a unique name of the module instance") @PathParam(value="instanceIdOrName") String instanceIdOrName, @Context HttpServletRequest req) {
        LOGGER.info("dropIndices instanceIdOrName={}", (Object)instanceIdOrName);
        try {
            EnumSet<Check> checks = EnumSet.of(Check.IF_MODULE_INSTANCE_MAINTENANCE_MODE_ENABLED);
            return this.process(req, instanceIdOrName, checks, (logServiceModule, logServiceModuleInstance) -> {
                logServiceModule.dropIndices(logServiceModuleInstance);
                return Response.ok().build();
            });
        }
        catch (Exception ex) {
            LOGGER.error("Drop of parent and child indices failed.", (Throwable)ex);
            return ErrorResponse.forException(ex).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @GET
    @Path(value="/{instanceIdOrName}/open/logservice")
    @Produces(value={"application/json"})
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcEndpoint
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="401", description="Authentication could not be performed"), @ApiResponse(responseCode="404", description="Module instance was not found"), @ApiResponse(responseCode="503", description="BPC or instance are currently in maintenance mode")})
    @OperationDescription(summary="Creates a BPC deeplink to redirect the caller to the admin page of a log service instance.", description="Creates a BPC deeplink to redirect the caller to the admin page of a log service instance.")
    @ReturnDescription(value="The requested data as JSON.")
    public Response openLogServiceAdminPage(@Parameter(description="this can be either the ID or a unique name of the log service module instance") @PathParam(value="instanceIdOrName") String instanceIdOrName, @Context HttpServletRequest req) {
        LOGGER.info("openLogServiceAdminPage instanceIdOrName={}", (Object)instanceIdOrName);
        try {
            EnumSet<Check> checks = EnumSet.noneOf(Check.class);
            return this.process(req, instanceIdOrName, checks, (logServiceModule, logServiceModuleInstance) -> {
                String redirectUrl = this.createLogServiceAdminDeeplinkUrl(logServiceModuleInstance.getModuleId());
                return Response.ok().status(Response.Status.FOUND).location(new URI(redirectUrl)).build();
            });
        }
        catch (Exception ex) {
            LOGGER.error("Creating the BPC deeplink and redirecting the user failed.", (Throwable)ex);
            return ErrorResponse.forException(ex).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    private String createLogServiceAdminDeeplinkUrl(String logServiceInstanceId) throws ModuleNotFoundException, ServiceNotFoundException {
        LOGGER.debug("createLogServiceAdminDeeplinkUrl logServiceInstanceId={}", (Object)logServiceInstanceId);
        return this.getCoreModule().getBpcFrontendUrl() + "?#/module/_core/_core///logservice/instanceManager/[/instance/[%22" + logServiceInstanceId + "%22]]";
    }

    @GET
    @Path(value="/{instanceIdOrName}/open/monitor")
    @Produces(value={"application/json"})
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcEndpoint
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="401", description="Authentication could not be performed"), @ApiResponse(responseCode="404", description="Module instance was not found"), @ApiResponse(responseCode="500", description="BPC deeplink could not be created"), @ApiResponse(responseCode="503", description="BPC or instance are currently in maintenance mode")})
    @OperationDescription(summary="Redirects the user to the monitor using the OpenSearch indices of the log service instance.", description="Redirects the user to the monitor using the OpenSearch indices of the log service instance.\n\nAll provided query params are used to build a monitor filter on fields of the 'externalReference' object.\n\nFor Iguasu the following query parameters can be used to access the HTTP header values when the entry has been created.\n\n!===\n!Query parameter !HTTP header\n\n!system    !IGUASU-System-ID\n!instance  !IGUASU-Instance-ID\n!processor !IGUASU-Processor-ID\n!service   !IGUASU-Service-ID\n!===\n")
    @ReturnDescription(value="The requested data as JSON.")
    public Response openMonitorPage(@Parameter(description="this can be either the ID or a unique name of the log service module instance") @PathParam(value="instanceIdOrName") String instanceIdOrName, @Parameter(description="optional URL parameter. Text or language key for window title") @QueryParam(value="title") String title, @Parameter(description="optional URL parameter. Text or language key for prompt text") @QueryParam(value="promptText") String promptText, @Context HttpServletRequest req) {
        LOGGER.info("openMonitorPage instanceIdOrName={}", (Object)instanceIdOrName);
        try {
            EnumSet<Check> checks = EnumSet.of(Check.IF_MODULE_INSTANCE_MAINTENANCE_MODE_ENABLED, Check.IF_OPENSEARCH_LOGGING_ENABLED);
            return this.process(req, instanceIdOrName, checks, (logServiceModule, logServiceModuleInstance) -> {
                ModuleManager moduleManager = this.moduleManagerTracker.getService();
                CoreModule coreModule = this.getCoreModule();
                Set<String> indicesUsedByLogServiceInstance = this.getIndicesUsedByLogServiceInstance(logServiceModuleInstance);
                Set<String> monitorInstanceIDs = new MonitorInstanceInvestigator(moduleManager).getIDsOfMonitorInstancesUsingThisOpenSearchIndices(indicesUsedByLogServiceInstance);
                Map<String, String> queryParams = UriQueryUtil.getQueryParams(req.getQueryString());
                String redirectUrl = new Deeplink(coreModule.getBpcFrontendUrl()).createMonitorRedirectUrl(monitorInstanceIDs, queryParams);
                return Response.ok().status(Response.Status.FOUND).header("Location", (Object)redirectUrl).build();
            });
        }
        catch (Exception ex) {
            LOGGER.error("Creating the BPC deeplink and redirecting the user failed.", (Throwable)ex);
            return ErrorResponse.forException(ex).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    private Set<String> getIndicesUsedByLogServiceInstance(LogServiceModuleInstance logServiceModuleInstance) {
        LOGGER.debug("getIndicesUsedByLogServiceInstance logServiceModuleInstance=...");
        HashSet<String> indicesUsedByLogServiceInstance = new HashSet<String>();
        if (logServiceModuleInstance != null && logServiceModuleInstance.isOpenSearchLoggingEnabled()) {
            String parentIndex = logServiceModuleInstance.getOpenSearchParentIndex();
            String childIndex = logServiceModuleInstance.getOpenSearchChildIndex();
            if (!StringUtil.isNullOrEmpty(parentIndex)) {
                indicesUsedByLogServiceInstance.add(parentIndex);
            }
            if (!StringUtil.isNullOrEmpty(childIndex)) {
                indicesUsedByLogServiceInstance.add(childIndex);
            }
        }
        return indicesUsedByLogServiceInstance;
    }

    @GET
    @Path(value="/jsonschema/{instanceIdOrName}")
    @Produces(value={"application/json"})
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcRoleOrRightRequired(role="LOG_SERVICE_USER", right="LOG_SERVICE_WRITE_DATA")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="401", description="Authentication could not be performed"), @ApiResponse(responseCode="404", description="Module instance was not found"), @ApiResponse(responseCode="503", description="BPC or instance are currently in maintenance mode")})
    @OperationDescription(summary="Get a JSON schema for the defined 'keys' and 'fields' of a log service instance.", description="Get a JSON schema for the defined 'keys' and 'fields' of a log service instance.\nSuch a JSON schema can be used to validate the JSON data POSTed to the create log service entries endpoint.\n")
    @ReturnDescription(value="The requested JSON schema.")
    public Response createJsonSchema(@Parameter(description="this can be either the ID or a unique name of the log service module instance") @PathParam(value="instanceIdOrName") String instanceIdOrName, @Parameter(description="in case a strict JSON schema must be created, that allows only known fields") @QueryParam(value="strict") @DefaultValue(value="false") boolean createStrictJsonSchema, @Context HttpServletRequest req) {
        LOGGER.info("createJsonSchema instanceIdOrName={}", (Object)instanceIdOrName);
        try {
            EnumSet<Check> checks = EnumSet.of(Check.IF_MODULE_INSTANCE_MAINTENANCE_MODE_ENABLED);
            return this.process(req, instanceIdOrName, checks, (logServiceModule, logServiceModuleInstance) -> {
                String jsonSchema = logServiceModuleInstance.getLogDataJsonSchema(createStrictJsonSchema).asString();
                return Response.ok((Object)jsonSchema).build();
            });
        }
        catch (Exception ex) {
            LOGGER.error("Failed creating the JSON shema for the fields of the log service instance: {}", (Object)instanceIdOrName, (Object)ex);
            return ErrorResponse.forException(ex).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    private Response process(HttpServletRequest req, LogServiceAction logServiceAction) throws ServiceNotFoundException, ModuleNotFoundException, LogServiceException {
        this.doGlobalMaintenanceModeEnabledCheck();
        LogServiceModule logServiceModule = this.getLogServiceModule();
        this.doClientCertificateAuthCheck(logServiceModule, req);
        return logServiceAction.execute(logServiceModule);
    }

    private Response process(HttpServletRequest req, String instanceIdOrName, EnumSet<Check> checks, LogServiceInstanceAction logServiceInstanceAction) throws ServiceNotFoundException, ModuleNotFoundException, ModuleInstanceNotFoundException, LogServiceException, OpenSearchRelatedException, DeeplinkException, URISyntaxException, JsonProcessingException {
        this.doGlobalMaintenanceModeEnabledCheck();
        LogServiceModule logServiceModule = this.getLogServiceModule();
        this.doClientCertificateAuthCheck(logServiceModule, req);
        LogServiceModuleInstance logServiceModuleInstance = (LogServiceModuleInstance)logServiceModule.getModuleInstanceByIdOrName(instanceIdOrName);
        if (checks != null && checks.contains((Object)Check.IF_MODULE_INSTANCE_MAINTENANCE_MODE_ENABLED)) {
            this.doModuleInstanceMaintenanceModeEnabledCheck(logServiceModuleInstance);
        }
        if (checks != null && checks.contains((Object)Check.IF_USED_OPENSEARCH_INDICES_AVAILABLE)) {
            this.doUsedOpenSearchIndicesAvailableCheck(logServiceModule, logServiceModuleInstance);
        }
        if (checks != null && checks.contains((Object)Check.IF_OPENSEARCH_LOGGING_ENABLED)) {
            this.doOpenSearchLoggingEnabledCheck(logServiceModuleInstance);
        }
        return logServiceInstanceAction.execute(logServiceModule, logServiceModuleInstance);
    }

    private void doGlobalMaintenanceModeEnabledCheck() throws ServiceNotFoundException, LogServiceException {
        if (this.coreBundleConfigurationTracker.getService().isMaintenanceModeEnabled()) {
            throw new LogServiceException((ErrorCode)CoreErrorCode.LOG_SERVICE_MAINTENANCE, "The core is currently in maintenance.");
        }
    }

    private void doClientCertificateAuthCheck(LogServiceModule logServiceModule, HttpServletRequest req) throws LogServiceException {
        boolean isClientCertificateAuthMandatory = logServiceModule.getConfiguration().getSettingValue("clientCertificateAuthMandatory").asBoolean(false);
        if (isClientCertificateAuthMandatory) {
            if (req == null) {
                throw new LogServiceException((ErrorCode)CoreErrorCode.LOG_SERVICE_UNAUTHORIZED, "Not authorized");
            }
            X509Certificate[] certs = (X509Certificate[])req.getAttribute("javax.servlet.request.X509Certificate");
            if (certs == null || certs.length == 0) {
                LOGGER.info("No mutual client certificate given");
                throw new LogServiceException((ErrorCode)CoreErrorCode.LOG_SERVICE_UNAUTHORIZED, "Not authorized (cca)");
            }
            for (X509Certificate cert : certs) {
                LOGGER.info("Mutual client certificate given: {}", (Object)cert.getSubjectX500Principal().getName());
            }
        }
    }

    private void doModuleInstanceMaintenanceModeEnabledCheck(LogServiceModuleInstance logServiceModuleInstance) throws LogServiceException {
        if (!logServiceModuleInstance.isEnabled()) {
            throw new LogServiceException((ErrorCode)CoreErrorCode.LOG_SERVICE_MAINTENANCE, "The instance '${instanceId}' of the module '${moduleId}' is currently disabled.", MapUtil.mapOf("moduleId", "logservice", "instanceId", logServiceModuleInstance.getModuleId()));
        }
        if (!logServiceModuleInstance.isOpenSearchLoggingEnabled() && !logServiceModuleInstance.isDatabaseLoggingEnabled()) {
            throw new LogServiceException((ErrorCode)CoreErrorCode.LOG_SERVICE_MAINTENANCE, "The instance '${instanceId}' of the module '${moduleId}' is currently in maintenance (OpenSearch and RDMS logging disabled).", MapUtil.mapOf("moduleId", "logservice", "instanceId", logServiceModuleInstance.getModuleId()));
        }
    }

    private void doOpenSearchLoggingEnabledCheck(LogServiceModuleInstance logServiceModuleInstance) throws LogServiceException {
        if (!logServiceModuleInstance.isOpenSearchLoggingEnabled()) {
            throw new LogServiceException((ErrorCode)CoreErrorCode.LOG_SERVICE_MAINTENANCE, "The instance '${instanceId}' of the module '${moduleId}' is currently in maintenance (OpenSearch logging disabled).", MapUtil.mapOf("moduleId", "logservice", "instanceId", logServiceModuleInstance.getModuleId()));
        }
    }

    private void doUsedOpenSearchIndicesAvailableCheck(LogServiceModule logServiceModule, LogServiceModuleInstance logServiceModuleInstance) throws LogServiceException {
        if (logServiceModuleInstance.isOpenSearchLoggingEnabled() && logServiceModule.areUsedIndicesTemporaryUnavailable(logServiceModuleInstance)) {
            throw new LogServiceException((ErrorCode)CoreErrorCode.LOG_SERVICE_MAINTENANCE, "The instance '${instanceId}' of the module '${moduleId}' uses an index that is temporary unavailable.", MapUtil.mapOf("moduleId", "logservice", "instanceId", logServiceModuleInstance.getModuleId()));
        }
    }

    @FunctionalInterface
    private static interface LogServiceAction {
        public Response execute(LogServiceModule var1);
    }

    private static enum Check {
        IF_MODULE_INSTANCE_MAINTENANCE_MODE_ENABLED,
        IF_USED_OPENSEARCH_INDICES_AVAILABLE,
        IF_OPENSEARCH_LOGGING_ENABLED;

    }

    @FunctionalInterface
    private static interface LogServiceInstanceAction {
        public Response execute(LogServiceModule var1, LogServiceModuleInstance var2) throws LogServiceException, OpenSearchRelatedException, ModuleNotFoundException, ServiceNotFoundException, DeeplinkException, JsonProcessingException, URISyntaxException;
    }
}

