/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.backward_codecs.lucene50.compressing;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Objects;
import org.apache.lucene.backward_codecs.lucene50.compressing.FieldsIndex;
import org.apache.lucene.backward_codecs.packed.LegacyDirectMonotonicReader;
import org.apache.lucene.backward_codecs.store.EndiannessReverserUtil;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.RandomAccessInput;

final class FieldsIndexReader
extends FieldsIndex {
    static final int VERSION_START = 0;
    static final int VERSION_CURRENT = 0;
    private final int maxDoc;
    private final int blockShift;
    private final int numChunks;
    private final LegacyDirectMonotonicReader.Meta docsMeta;
    private final LegacyDirectMonotonicReader.Meta startPointersMeta;
    private final IndexInput indexInput;
    private final long docsStartPointer;
    private final long docsEndPointer;
    private final long startPointersStartPointer;
    private final long startPointersEndPointer;
    private final LegacyDirectMonotonicReader docs;
    private final LegacyDirectMonotonicReader startPointers;
    private final long maxPointer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FieldsIndexReader(Directory dir, String name, String suffix, String extension, String codecName, byte[] id, IndexInput metaIn) throws IOException {
        this.maxDoc = metaIn.readInt();
        this.blockShift = metaIn.readInt();
        this.numChunks = metaIn.readInt();
        this.docsStartPointer = metaIn.readLong();
        this.docsMeta = LegacyDirectMonotonicReader.loadMeta(metaIn, this.numChunks, this.blockShift);
        this.docsEndPointer = this.startPointersStartPointer = metaIn.readLong();
        this.startPointersMeta = LegacyDirectMonotonicReader.loadMeta(metaIn, this.numChunks, this.blockShift);
        this.startPointersEndPointer = metaIn.readLong();
        this.maxPointer = metaIn.readLong();
        this.indexInput = EndiannessReverserUtil.openInput(dir, IndexFileNames.segmentFileName(name, suffix, extension), IOContext.DEFAULT);
        boolean success = false;
        try {
            CodecUtil.checkIndexHeader(this.indexInput, codecName + "Idx", 0, 0, id, suffix);
            CodecUtil.retrieveChecksum(this.indexInput);
            success = true;
        }
        finally {
            if (!success) {
                this.indexInput.close();
            }
        }
        RandomAccessInput docsSlice = this.indexInput.randomAccessSlice(this.docsStartPointer, this.docsEndPointer - this.docsStartPointer);
        RandomAccessInput startPointersSlice = this.indexInput.randomAccessSlice(this.startPointersStartPointer, this.startPointersEndPointer - this.startPointersStartPointer);
        this.docs = LegacyDirectMonotonicReader.getInstance(this.docsMeta, docsSlice);
        this.startPointers = LegacyDirectMonotonicReader.getInstance(this.startPointersMeta, startPointersSlice);
    }

    private FieldsIndexReader(FieldsIndexReader other) throws IOException {
        this.maxDoc = other.maxDoc;
        this.numChunks = other.numChunks;
        this.blockShift = other.blockShift;
        this.docsMeta = other.docsMeta;
        this.startPointersMeta = other.startPointersMeta;
        this.indexInput = other.indexInput.clone();
        this.docsStartPointer = other.docsStartPointer;
        this.docsEndPointer = other.docsEndPointer;
        this.startPointersStartPointer = other.startPointersStartPointer;
        this.startPointersEndPointer = other.startPointersEndPointer;
        this.maxPointer = other.maxPointer;
        RandomAccessInput docsSlice = this.indexInput.randomAccessSlice(this.docsStartPointer, this.docsEndPointer - this.docsStartPointer);
        RandomAccessInput startPointersSlice = this.indexInput.randomAccessSlice(this.startPointersStartPointer, this.startPointersEndPointer - this.startPointersStartPointer);
        this.docs = LegacyDirectMonotonicReader.getInstance(this.docsMeta, docsSlice);
        this.startPointers = LegacyDirectMonotonicReader.getInstance(this.startPointersMeta, startPointersSlice);
    }

    @Override
    public void close() throws IOException {
        this.indexInput.close();
    }

    @Override
    long getStartPointer(int docID) {
        Objects.checkIndex(docID, this.maxDoc);
        long blockIndex = this.docs.binarySearch(0L, this.numChunks, docID);
        if (blockIndex < 0L) {
            blockIndex = -2L - blockIndex;
        }
        return this.startPointers.get(blockIndex);
    }

    @Override
    public FieldsIndex clone() {
        try {
            return new FieldsIndexReader(this);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public long getMaxPointer() {
        return this.maxPointer;
    }

    @Override
    void checkIntegrity() throws IOException {
        CodecUtil.checksumEntireFile(this.indexInput);
    }
}

