/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.backward_codecs.lucene92;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.backward_codecs.lucene92.OffHeapFloatVectorValues;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.KnnVectorsReader;
import org.apache.lucene.codecs.hnsw.DefaultFlatVectorScorer;
import org.apache.lucene.index.ByteVectorValues;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.KnnVectorValues;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.internal.hppc.IntObjectHashMap;
import org.apache.lucene.search.KnnCollector;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.hnsw.HnswGraph;
import org.apache.lucene.util.hnsw.HnswGraphSearcher;
import org.apache.lucene.util.hnsw.OrdinalTranslatedKnnCollector;
import org.apache.lucene.util.hnsw.RandomVectorScorer;
import org.apache.lucene.util.packed.DirectMonotonicReader;

public final class Lucene92HnswVectorsReader
extends KnnVectorsReader {
    private final IntObjectHashMap<FieldEntry> fields = new IntObjectHashMap();
    private final IndexInput vectorData;
    private final IndexInput vectorIndex;
    private final DefaultFlatVectorScorer defaultFlatVectorScorer = new DefaultFlatVectorScorer();
    private final FieldInfos fieldInfos;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Lucene92HnswVectorsReader(SegmentReadState state) throws IOException {
        int versionMeta = this.readMetadata(state);
        this.fieldInfos = state.fieldInfos;
        boolean success = false;
        try {
            this.vectorData = Lucene92HnswVectorsReader.openDataInput(state, versionMeta, "vec", "lucene92HnswVectorsFormatData");
            this.vectorIndex = Lucene92HnswVectorsReader.openDataInput(state, versionMeta, "vex", "lucene92HnswVectorsFormatIndex");
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException(this);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readMetadata(SegmentReadState state) throws IOException {
        int versionMeta;
        block11: {
            String metaFileName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, "vem");
            versionMeta = -1;
            try (ChecksumIndexInput meta = state.directory.openChecksumInput(metaFileName);){
                Throwable priorE = null;
                try {
                    versionMeta = CodecUtil.checkIndexHeader(meta, "lucene92HnswVectorsFormatMeta", 0, 0, state.segmentInfo.getId(), state.segmentSuffix);
                    this.readFields(meta, state.fieldInfos);
                }
                catch (Throwable exception) {
                    try {
                        priorE = exception;
                        break block11;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        CodecUtil.checkFooter(meta, priorE);
                    }
                }
                CodecUtil.checkFooter(meta, priorE);
            }
        }
        return versionMeta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IndexInput openDataInput(SegmentReadState state, int versionMeta, String fileExtension, String codecName) throws IOException {
        IndexInput indexInput;
        block4: {
            String fileName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, fileExtension);
            IndexInput in = state.directory.openInput(fileName, state.context);
            boolean success = false;
            try {
                int versionVectorData = CodecUtil.checkIndexHeader(in, codecName, 0, 0, state.segmentInfo.getId(), state.segmentSuffix);
                if (versionMeta != versionVectorData) {
                    throw new CorruptIndexException("Format versions mismatch: meta=" + versionMeta + ", " + codecName + "=" + versionVectorData, in);
                }
                CodecUtil.retrieveChecksum(in);
                success = true;
                indexInput = in;
                if (success) break block4;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.closeWhileHandlingException(in);
                }
                throw throwable;
            }
            IOUtils.closeWhileHandlingException(in);
        }
        return indexInput;
    }

    private void readFields(ChecksumIndexInput meta, FieldInfos infos) throws IOException {
        int fieldNumber = meta.readInt();
        while (fieldNumber != -1) {
            FieldInfo info = infos.fieldInfo(fieldNumber);
            if (info == null) {
                throw new CorruptIndexException("Invalid field number: " + fieldNumber, meta);
            }
            FieldEntry fieldEntry = this.readField(meta, info);
            this.validateFieldEntry(info, fieldEntry);
            this.fields.put(info.number, fieldEntry);
            fieldNumber = meta.readInt();
        }
    }

    private void validateFieldEntry(FieldInfo info, FieldEntry fieldEntry) {
        int dimension = info.getVectorDimension();
        if (dimension != fieldEntry.dimension) {
            throw new IllegalStateException("Inconsistent vector dimension for field=\"" + info.name + "\"; " + dimension + " != " + fieldEntry.dimension);
        }
        long numBytes = (long)fieldEntry.size() * (long)dimension * 4L;
        if (numBytes != fieldEntry.vectorDataLength) {
            throw new IllegalStateException("Vector data length " + fieldEntry.vectorDataLength + " not matching size=" + fieldEntry.size() + " * dim=" + dimension + " * 4 = " + numBytes);
        }
    }

    private VectorSimilarityFunction readSimilarityFunction(DataInput input) throws IOException {
        int similarityFunctionId = input.readInt();
        if (similarityFunctionId < 0 || similarityFunctionId >= VectorSimilarityFunction.values().length) {
            throw new CorruptIndexException("Invalid similarity function id: " + similarityFunctionId, input);
        }
        return VectorSimilarityFunction.values()[similarityFunctionId];
    }

    private FieldEntry readField(IndexInput input, FieldInfo info) throws IOException {
        VectorSimilarityFunction similarityFunction = this.readSimilarityFunction(input);
        if (similarityFunction != info.getVectorSimilarityFunction()) {
            throw new IllegalStateException("Inconsistent vector similarity function for field=\"" + info.name + "\"; " + String.valueOf((Object)similarityFunction) + " != " + String.valueOf((Object)info.getVectorSimilarityFunction()));
        }
        return FieldEntry.create(input, info.getVectorSimilarityFunction());
    }

    @Override
    public void checkIntegrity() throws IOException {
        CodecUtil.checksumEntireFile(this.vectorData);
        CodecUtil.checksumEntireFile(this.vectorIndex);
    }

    private FieldEntry getFieldEntry(String field) {
        FieldEntry fieldEntry;
        FieldInfo info = this.fieldInfos.fieldInfo(field);
        if (info == null || (fieldEntry = this.fields.get(info.number)) == null) {
            throw new IllegalArgumentException("field=\"" + field + "\" not found");
        }
        return fieldEntry;
    }

    @Override
    public FloatVectorValues getFloatVectorValues(String field) throws IOException {
        return OffHeapFloatVectorValues.load(this.getFieldEntry(field), this.vectorData);
    }

    @Override
    public ByteVectorValues getByteVectorValues(String field) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void search(String field, float[] target, KnnCollector knnCollector, Bits acceptDocs) throws IOException {
        FieldEntry fieldEntry = this.getFieldEntry(field);
        if (fieldEntry.size() == 0) {
            return;
        }
        OffHeapFloatVectorValues vectorValues = OffHeapFloatVectorValues.load(fieldEntry, this.vectorData);
        RandomVectorScorer scorer = this.defaultFlatVectorScorer.getRandomVectorScorer(fieldEntry.similarityFunction, (KnnVectorValues)vectorValues, target);
        HnswGraphSearcher.search(scorer, new OrdinalTranslatedKnnCollector(knnCollector, vectorValues::ordToDoc), this.getGraph(fieldEntry), vectorValues.getAcceptOrds(acceptDocs));
    }

    @Override
    public void search(String field, byte[] target, KnnCollector knnCollector, Bits acceptDocs) throws IOException {
        throw new UnsupportedOperationException();
    }

    private HnswGraph getGraph(FieldEntry entry) throws IOException {
        IndexInput bytesSlice = this.vectorIndex.slice("graph-data", entry.vectorIndexOffset, entry.vectorIndexLength);
        return new OffHeapHnswGraph(entry, bytesSlice);
    }

    @Override
    public void close() throws IOException {
        IOUtils.close(this.vectorData, this.vectorIndex);
    }

    record FieldEntry(VectorSimilarityFunction similarityFunction, long vectorDataOffset, long vectorDataLength, long vectorIndexOffset, long vectorIndexLength, int M, int numLevels, int dimension, int size, int[][] nodesByLevel, long[] graphOffsetsByLevel, long docsWithFieldOffset, long docsWithFieldLength, short jumpTableEntryCount, byte denseRankPower, long addressesOffset, int blockShift, DirectMonotonicReader.Meta meta, long addressesLength) {
        static FieldEntry create(IndexInput input, VectorSimilarityFunction similarityFunction) throws IOException {
            long addressesLength;
            DirectMonotonicReader.Meta meta;
            int blockShift;
            long addressesOffset;
            long vectorDataOffset = input.readVLong();
            long vectorDataLength = input.readVLong();
            long vectorIndexOffset = input.readVLong();
            long vectorIndexLength = input.readVLong();
            int dimension = input.readInt();
            int size = input.readInt();
            long docsWithFieldOffset = input.readLong();
            long docsWithFieldLength = input.readLong();
            short jumpTableEntryCount = input.readShort();
            byte denseRankPower = input.readByte();
            if (docsWithFieldOffset == -1L || docsWithFieldOffset == -2L) {
                addressesOffset = 0L;
                blockShift = 0;
                meta = null;
                addressesLength = 0L;
            } else {
                addressesOffset = input.readLong();
                blockShift = input.readVInt();
                meta = DirectMonotonicReader.loadMeta(input, size, blockShift);
                addressesLength = input.readLong();
            }
            int M = input.readInt();
            int numLevels = input.readInt();
            int[][] nodesByLevel = new int[numLevels][];
            for (int level = 0; level < numLevels; ++level) {
                int numNodesOnLevel = input.readInt();
                if (level == 0) {
                    assert (numNodesOnLevel == size);
                    nodesByLevel[0] = null;
                    continue;
                }
                nodesByLevel[level] = new int[numNodesOnLevel];
                for (int i = 0; i < numNodesOnLevel; ++i) {
                    nodesByLevel[level][i] = input.readInt();
                }
            }
            long[] graphOffsetsByLevel = new long[numLevels];
            long connectionsAndSizeLevel0Bytes = Math.multiplyExact(Math.addExact(1L, Math.multiplyExact((long)M, 2L)), 4);
            long connectionsAndSizeBytes = Math.multiplyExact(Math.addExact(1L, (long)M), 4);
            for (int level = 0; level < numLevels; ++level) {
                if (level == 0) {
                    graphOffsetsByLevel[level] = 0L;
                    continue;
                }
                if (level == 1) {
                    graphOffsetsByLevel[level] = Math.multiplyExact(connectionsAndSizeLevel0Bytes, size);
                    continue;
                }
                int numNodesOnPrevLevel = nodesByLevel[level - 1].length;
                graphOffsetsByLevel[level] = Math.addExact(graphOffsetsByLevel[level - 1], Math.multiplyExact(connectionsAndSizeBytes, numNodesOnPrevLevel));
            }
            return new FieldEntry(similarityFunction, vectorDataOffset, vectorDataLength, vectorIndexOffset, vectorIndexLength, M, numLevels, dimension, size, nodesByLevel, graphOffsetsByLevel, docsWithFieldOffset, docsWithFieldLength, jumpTableEntryCount, denseRankPower, addressesOffset, blockShift, meta, addressesLength);
        }
    }

    private static final class OffHeapHnswGraph
    extends HnswGraph {
        final IndexInput dataIn;
        final int[][] nodesByLevel;
        final long[] graphOffsetsByLevel;
        final int numLevels;
        final int entryNode;
        final int size;
        final long bytesForConns;
        final long bytesForConns0;
        private final int maxConn;
        int arcCount;
        int arcUpTo;
        int arc;

        OffHeapHnswGraph(FieldEntry entry, IndexInput dataIn) {
            this.dataIn = dataIn;
            this.nodesByLevel = entry.nodesByLevel;
            this.numLevels = entry.numLevels;
            this.entryNode = this.numLevels > 1 ? this.nodesByLevel[this.numLevels - 1][0] : 0;
            this.size = entry.size();
            this.graphOffsetsByLevel = entry.graphOffsetsByLevel;
            this.bytesForConns = Math.multiplyExact(Math.addExact((long)entry.M, 1L), 4);
            this.bytesForConns0 = Math.multiplyExact(Math.addExact(Math.multiplyExact((long)entry.M, 2L), 1L), 4);
            this.maxConn = entry.M;
        }

        @Override
        public void seek(int level, int targetOrd) throws IOException {
            int targetIndex;
            int n = targetIndex = level == 0 ? targetOrd : Arrays.binarySearch(this.nodesByLevel[level], 0, this.nodesByLevel[level].length, targetOrd);
            assert (targetIndex >= 0);
            long graphDataOffset = this.graphOffsetsByLevel[level] + (long)targetIndex * (level == 0 ? this.bytesForConns0 : this.bytesForConns);
            this.dataIn.seek(graphDataOffset);
            this.arcCount = this.dataIn.readInt();
            this.arc = -1;
            this.arcUpTo = 0;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public int nextNeighbor() throws IOException {
            if (this.arcUpTo >= this.arcCount) {
                return Integer.MAX_VALUE;
            }
            ++this.arcUpTo;
            this.arc = this.dataIn.readInt();
            return this.arc;
        }

        @Override
        public int neighborCount() {
            return this.arcCount;
        }

        @Override
        public int maxConn() {
            return this.maxConn;
        }

        @Override
        public int numLevels() {
            return this.numLevels;
        }

        @Override
        public int entryNode() {
            return this.entryNode;
        }

        @Override
        public HnswGraph.NodesIterator getNodesOnLevel(int level) {
            if (level == 0) {
                return new HnswGraph.ArrayNodesIterator(this.size());
            }
            return new HnswGraph.ArrayNodesIterator(this.nodesByLevel[level], this.nodesByLevel[level].length);
        }
    }
}

