/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.sandbox.facet;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.sandbox.facet.cutters.FacetCutter;
import org.apache.lucene.sandbox.facet.cutters.LeafFacetCutter;
import org.apache.lucene.sandbox.facet.recorders.FacetRecorder;
import org.apache.lucene.sandbox.facet.recorders.LeafFacetRecorder;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Scorable;

final class FacetFieldLeafCollector
implements LeafCollector {
    private final LeafReaderContext context;
    private final FacetCutter cutter;
    private final FacetRecorder recorder;
    private LeafFacetCutter leafCutter;
    private LeafFacetRecorder leafRecorder;

    FacetFieldLeafCollector(LeafReaderContext context, FacetCutter cutter, FacetRecorder recorder) {
        this.context = context;
        this.cutter = cutter;
        this.recorder = recorder;
    }

    @Override
    public void setScorer(Scorable scorer) throws IOException {
    }

    @Override
    public void collect(int doc) throws IOException {
        if (this.leafCutter == null) {
            this.leafCutter = this.cutter.createLeafCutter(this.context);
            assert (this.leafRecorder == null);
            this.leafRecorder = this.recorder.getLeafRecorder(this.context);
        }
        if (this.leafCutter.advanceExact(doc)) {
            int curOrd = this.leafCutter.nextOrd();
            while (curOrd != -1) {
                this.leafRecorder.record(doc, curOrd);
                curOrd = this.leafCutter.nextOrd();
            }
        }
    }

    @Override
    public DocIdSetIterator competitiveIterator() throws IOException {
        return LeafCollector.super.competitiveIterator();
    }
}

