/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.grouping;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.LeafFieldComparator;
import org.apache.lucene.search.Pruning;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.SimpleCollector;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.grouping.GroupSelector;
import org.apache.lucene.util.FixedBitSet;

public abstract class AllGroupHeadsCollector<T>
extends SimpleCollector {
    private final GroupSelector<T> groupSelector;
    protected final Sort sort;
    protected final int[] reversed;
    protected final int compIDXEnd;
    protected Map<T, GroupHead<T>> heads = new HashMap<T, GroupHead<T>>();
    protected LeafReaderContext context;
    protected Scorable scorer;

    public static <T> AllGroupHeadsCollector<T> newCollector(GroupSelector<T> selector, Sort sort) {
        if (sort.equals(Sort.RELEVANCE)) {
            return new ScoringGroupHeadsCollector<T>(selector, sort);
        }
        return new SortingGroupHeadsCollector<T>(selector, sort);
    }

    private AllGroupHeadsCollector(GroupSelector<T> selector, Sort sort) {
        this.groupSelector = selector;
        this.sort = sort;
        this.reversed = new int[sort.getSort().length];
        SortField[] sortFields = sort.getSort();
        for (int i = 0; i < sortFields.length; ++i) {
            this.reversed[i] = sortFields[i].getReverse() ? -1 : 1;
        }
        this.compIDXEnd = this.reversed.length - 1;
    }

    public FixedBitSet retrieveGroupHeads(int maxDoc) {
        FixedBitSet bitSet = new FixedBitSet(maxDoc);
        Collection<GroupHead<T>> groupHeads = this.getCollectedGroupHeads();
        for (GroupHead<T> groupHead : groupHeads) {
            bitSet.set(groupHead.doc);
        }
        return bitSet;
    }

    public int[] retrieveGroupHeads() {
        Collection<GroupHead<T>> groupHeads = this.getCollectedGroupHeads();
        int[] docHeads = new int[groupHeads.size()];
        int i = 0;
        for (GroupHead<T> groupHead : groupHeads) {
            docHeads[i++] = groupHead.doc;
        }
        return docHeads;
    }

    public int groupHeadsSize() {
        return this.getCollectedGroupHeads().size();
    }

    protected Collection<? extends GroupHead<T>> getCollectedGroupHeads() {
        return this.heads.values();
    }

    @Override
    public void collect(int doc) throws IOException {
        this.groupSelector.advanceTo(doc);
        T groupValue = this.groupSelector.currentValue();
        if (!this.heads.containsKey(groupValue)) {
            groupValue = this.groupSelector.copyValue();
            this.heads.put(groupValue, this.newGroupHead(doc, groupValue, this.context, this.scorer));
            return;
        }
        GroupHead<T> groupHead = this.heads.get(groupValue);
        int compIDX = 0;
        while (true) {
            int c;
            if ((c = this.reversed[compIDX] * groupHead.compare(compIDX, doc)) < 0) {
                return;
            }
            if (c > 0) break;
            if (compIDX == this.compIDXEnd) {
                return;
            }
            ++compIDX;
        }
        groupHead.updateDocHead(doc);
    }

    @Override
    public ScoreMode scoreMode() {
        return this.sort.needsScores() ? ScoreMode.COMPLETE : ScoreMode.COMPLETE_NO_SCORES;
    }

    @Override
    protected void doSetNextReader(LeafReaderContext context) throws IOException {
        this.groupSelector.setNextReader(context);
        this.context = context;
        for (GroupHead<T> head : this.heads.values()) {
            head.setNextReader(context);
        }
    }

    @Override
    public void setScorer(Scorable scorer) throws IOException {
        this.scorer = scorer;
        for (GroupHead<T> head : this.heads.values()) {
            head.setScorer(scorer);
        }
    }

    protected abstract GroupHead<T> newGroupHead(int var1, T var2, LeafReaderContext var3, Scorable var4) throws IOException;

    private static class ScoringGroupHeadsCollector<T>
    extends AllGroupHeadsCollector<T> {
        protected ScoringGroupHeadsCollector(GroupSelector<T> selector, Sort sort) {
            super(selector, sort);
        }

        @Override
        protected GroupHead<T> newGroupHead(int doc, T value, LeafReaderContext context, Scorable scorer) throws IOException {
            return new ScoringGroupHead<T>(scorer, value, doc, context.docBase);
        }
    }

    private static class SortingGroupHeadsCollector<T>
    extends AllGroupHeadsCollector<T> {
        protected SortingGroupHeadsCollector(GroupSelector<T> selector, Sort sort) {
            super(selector, sort);
        }

        @Override
        protected GroupHead<T> newGroupHead(int doc, T value, LeafReaderContext ctx, Scorable scorer) throws IOException {
            return new SortingGroupHead<T>(this.sort, value, doc, ctx, scorer);
        }
    }

    public static abstract class GroupHead<T> {
        public final T groupValue;
        public int doc;
        protected int docBase;

        protected GroupHead(T groupValue, int doc, int docBase) {
            this.groupValue = groupValue;
            this.doc = doc + docBase;
            this.docBase = docBase;
        }

        protected void setNextReader(LeafReaderContext ctx) throws IOException {
            this.docBase = ctx.docBase;
        }

        protected abstract void setScorer(Scorable var1) throws IOException;

        protected abstract int compare(int var1, int var2) throws IOException;

        protected abstract void updateDocHead(int var1) throws IOException;
    }

    private static class ScoringGroupHead<T>
    extends GroupHead<T> {
        private Scorable scorer;
        private float topScore;

        protected ScoringGroupHead(Scorable scorer, T groupValue, int doc, int docBase) throws IOException {
            super(groupValue, doc, docBase);
            this.scorer = scorer;
            this.topScore = scorer.score();
        }

        @Override
        protected void setScorer(Scorable scorer) {
            this.scorer = scorer;
        }

        @Override
        protected int compare(int compIDX, int doc) throws IOException {
            assert (compIDX == 0);
            float score = this.scorer.score();
            int c = Float.compare(score, this.topScore);
            if (c > 0) {
                this.topScore = score;
            }
            return c;
        }

        @Override
        protected void updateDocHead(int doc) throws IOException {
            this.doc = doc + this.docBase;
        }
    }

    private static class SortingGroupHead<T>
    extends GroupHead<T> {
        final FieldComparator[] comparators;
        final LeafFieldComparator[] leafComparators;

        protected SortingGroupHead(Sort sort, T groupValue, int doc, LeafReaderContext context, Scorable scorer) throws IOException {
            super(groupValue, doc, context.docBase);
            SortField[] sortFields = sort.getSort();
            this.comparators = new FieldComparator[sortFields.length];
            this.leafComparators = new LeafFieldComparator[sortFields.length];
            for (int i = 0; i < sortFields.length; ++i) {
                this.comparators[i] = sortFields[i].getComparator(1, Pruning.NONE);
                this.leafComparators[i] = this.comparators[i].getLeafComparator(context);
                this.leafComparators[i].setScorer(scorer);
                this.leafComparators[i].copy(0, doc);
                this.leafComparators[i].setBottom(0);
            }
        }

        @Override
        public void setNextReader(LeafReaderContext ctx) throws IOException {
            super.setNextReader(ctx);
            for (int i = 0; i < this.comparators.length; ++i) {
                this.leafComparators[i] = this.comparators[i].getLeafComparator(ctx);
            }
        }

        @Override
        protected void setScorer(Scorable scorer) throws IOException {
            for (LeafFieldComparator c : this.leafComparators) {
                c.setScorer(scorer);
            }
        }

        @Override
        public int compare(int compIDX, int doc) throws IOException {
            return this.leafComparators[compIDX].compareBottom(doc);
        }

        @Override
        public void updateDocHead(int doc) throws IOException {
            for (LeafFieldComparator comparator : this.leafComparators) {
                comparator.copy(0, doc);
                comparator.setBottom(0);
            }
            this.doc = doc + this.docBase;
        }
    }
}

