/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.cluster.node.tasks.list;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.tasks.TaskInfo;

@PublicApi(since="1.0.0")
public class TaskGroup
implements ToXContentObject {
    private final TaskInfo task;
    private final List<TaskGroup> childTasks;

    public TaskGroup(TaskInfo task, List<TaskGroup> childTasks) {
        this.task = task;
        this.childTasks = Collections.unmodifiableList(new ArrayList<TaskGroup>(childTasks));
    }

    public static Builder builder(TaskInfo taskInfo) {
        return new Builder(taskInfo);
    }

    public TaskInfo getTaskInfo() {
        return this.task;
    }

    public List<TaskGroup> getChildTasks() {
        return this.childTasks;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.task.toXContent(builder, params);
        if (!this.childTasks.isEmpty()) {
            builder.startArray("children");
            for (TaskGroup taskGroup : this.childTasks) {
                taskGroup.toXContent(builder, params);
            }
            builder.endArray();
        }
        return builder.endObject();
    }

    @PublicApi(since="1.0.0")
    public static class Builder {
        private TaskInfo taskInfo;
        private List<Builder> childTasks;

        private Builder(TaskInfo taskInfo) {
            this.taskInfo = taskInfo;
            this.childTasks = new ArrayList<Builder>();
        }

        public void addGroup(Builder builder) {
            this.childTasks.add(builder);
        }

        public TaskInfo getTaskInfo() {
            return this.taskInfo;
        }

        public TaskGroup build() {
            return new TaskGroup(this.taskInfo, this.childTasks.stream().map(Builder::build).collect(Collectors.toList()));
        }
    }
}

