/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.cluster.remotestore.metadata;

import java.io.IOException;
import java.util.Map;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;

@ExperimentalApi
public class RemoteStoreShardMetadata
implements Writeable,
ToXContentFragment {
    private final String indexName;
    private final int shardId;
    private final Map<String, Map<String, Object>> segmentMetadataFiles;
    private final Map<String, Map<String, Object>> translogMetadataFiles;
    private final String latestSegmentMetadataFileName;
    private final String latestTranslogMetadataFileName;

    public RemoteStoreShardMetadata(String indexName, int shardId, Map<String, Map<String, Object>> segmentMetadataFiles, Map<String, Map<String, Object>> translogMetadataFiles, String latestSegmentMetadataFileName, String latestTranslogMetadataFileName) {
        this.indexName = indexName;
        this.shardId = shardId;
        this.segmentMetadataFiles = segmentMetadataFiles;
        this.translogMetadataFiles = translogMetadataFiles;
        this.latestSegmentMetadataFileName = latestSegmentMetadataFileName;
        this.latestTranslogMetadataFileName = latestTranslogMetadataFileName;
    }

    public RemoteStoreShardMetadata(StreamInput in) throws IOException {
        this.indexName = in.readString();
        this.shardId = in.readInt();
        this.segmentMetadataFiles = (Map)in.readGenericValue();
        this.translogMetadataFiles = (Map)in.readGenericValue();
        this.latestSegmentMetadataFileName = in.readOptionalString();
        this.latestTranslogMetadataFileName = in.readOptionalString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.indexName);
        out.writeInt(this.shardId);
        out.writeGenericValue(this.segmentMetadataFiles);
        out.writeGenericValue(this.translogMetadataFiles);
        out.writeOptionalString(this.latestSegmentMetadataFileName);
        out.writeOptionalString(this.latestTranslogMetadataFileName);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("index", this.indexName);
        builder.field("shard", this.shardId);
        if (this.latestSegmentMetadataFileName != null) {
            builder.field("latest_segment_metadata_filename", this.latestSegmentMetadataFileName);
        }
        if (this.latestTranslogMetadataFileName != null) {
            builder.field("latest_translog_metadata_filename", this.latestTranslogMetadataFileName);
        }
        builder.startObject("available_segment_metadata_files");
        for (Map.Entry<String, Map<String, Object>> entry : this.segmentMetadataFiles.entrySet()) {
            builder.startObject(entry.getKey());
            for (Map.Entry<String, Object> inner : entry.getValue().entrySet()) {
                builder.field(inner.getKey(), inner.getValue());
            }
            builder.endObject();
        }
        builder.endObject();
        builder.startObject("available_translog_metadata_files");
        for (Map.Entry<String, Map<String, Object>> entry : this.translogMetadataFiles.entrySet()) {
            builder.startObject(entry.getKey());
            for (Map.Entry<String, Object> inner : entry.getValue().entrySet()) {
                builder.field(inner.getKey(), inner.getValue());
            }
            builder.endObject();
        }
        builder.endObject();
        return builder.endObject();
    }

    public String getIndexName() {
        return this.indexName;
    }

    public int getShardId() {
        return this.shardId;
    }

    public Map<String, Map<String, Object>> getSegmentMetadataFiles() {
        return this.segmentMetadataFiles;
    }

    public Map<String, Map<String, Object>> getTranslogMetadataFiles() {
        return this.translogMetadataFiles;
    }

    public String getLatestSegmentMetadataFileName() {
        return this.latestSegmentMetadataFileName;
    }

    public String getLatestTranslogMetadataFileName() {
        return this.latestTranslogMetadataFileName;
    }
}

