/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.indices.alias;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.RequestValidators;
import org.opensearch.action.admin.indices.alias.IndicesAliasesClusterStateUpdateRequest;
import org.opensearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.clustermanager.AcknowledgedResponse;
import org.opensearch.action.support.clustermanager.TransportClusterManagerNodeAction;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.ack.ClusterStateUpdateResponse;
import org.opensearch.cluster.block.ClusterBlockException;
import org.opensearch.cluster.block.ClusterBlocks;
import org.opensearch.cluster.metadata.AliasAction;
import org.opensearch.cluster.metadata.AliasMetadata;
import org.opensearch.cluster.metadata.IndexAbstraction;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.metadata.Metadata;
import org.opensearch.cluster.metadata.MetadataIndexAliasesService;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.regex.Regex;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.index.Index;
import org.opensearch.rest.action.admin.indices.AliasesNotFoundException;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

public class TransportIndicesAliasesAction
extends TransportClusterManagerNodeAction<IndicesAliasesRequest, AcknowledgedResponse> {
    private static final Logger logger = LogManager.getLogger(TransportIndicesAliasesAction.class);
    private final MetadataIndexAliasesService indexAliasesService;
    private final RequestValidators<IndicesAliasesRequest> requestValidators;

    @Inject
    public TransportIndicesAliasesAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, MetadataIndexAliasesService indexAliasesService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, RequestValidators<IndicesAliasesRequest> requestValidators) {
        super("indices:admin/aliases", transportService, clusterService, threadPool, actionFilters, IndicesAliasesRequest::new, indexNameExpressionResolver);
        this.indexAliasesService = indexAliasesService;
        this.requestValidators = Objects.requireNonNull(requestValidators);
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected AcknowledgedResponse read(StreamInput in) throws IOException {
        return new AcknowledgedResponse(in);
    }

    @Override
    protected ClusterBlockException checkBlock(IndicesAliasesRequest request, ClusterState state) {
        HashSet<String> indices = new HashSet<String>();
        for (IndicesAliasesRequest.AliasActions aliasAction : request.aliasActions()) {
            Collections.addAll(indices, aliasAction.indices());
        }
        return ClusterBlocks.indicesWithRemoteSnapshotBlockedException(indices, state);
    }

    @Override
    protected void clusterManagerOperation(IndicesAliasesRequest request, ClusterState state, final ActionListener<AcknowledgedResponse> listener) {
        List<IndicesAliasesRequest.AliasActions> actions = request.aliasActions();
        ArrayList<AliasAction> finalActions = new ArrayList<AliasAction>();
        HashSet aliases = new HashSet();
        for (IndicesAliasesRequest.AliasActions action : actions) {
            Index[] concreteIndices;
            for (Index concreteIndex : concreteIndices = this.indexNameExpressionResolver.concreteIndices(state, request.indicesOptions(), false, action.indices())) {
                IndexAbstraction indexAbstraction = (IndexAbstraction)state.metadata().getIndicesLookup().get(concreteIndex.getName());
                assert (indexAbstraction != null) : "invalid cluster metadata. index [" + concreteIndex.getName() + "] was not found";
                if (indexAbstraction.getParentDataStream() == null) continue;
                throw new IllegalArgumentException("The provided expressions [" + String.join((CharSequence)",", action.indices()) + "] match a backing index belonging to data stream [" + indexAbstraction.getParentDataStream().getName() + "]. Data streams and their backing indices don't support aliases.");
            }
            Optional<Exception> maybeException = this.requestValidators.validateRequest(request, state, concreteIndices);
            if (maybeException.isPresent()) {
                listener.onFailure(maybeException.get());
                return;
            }
            Collections.addAll(aliases, action.getOriginalAliases());
            block7: for (Index index : concreteIndices) {
                switch (action.actionType()) {
                    case ADD: {
                        for (String alias : TransportIndicesAliasesAction.concreteAliases(action, state.metadata(), index.getName())) {
                            finalActions.add(new AliasAction.Add(index.getName(), alias, action.filter(), action.indexRouting(), action.searchRouting(), action.writeIndex(), action.isHidden()));
                        }
                        continue block7;
                    }
                    case REMOVE: {
                        for (String alias : TransportIndicesAliasesAction.concreteAliases(action, state.metadata(), index.getName())) {
                            finalActions.add(new AliasAction.Remove(index.getName(), alias, action.mustExist()));
                        }
                        continue block7;
                    }
                    case REMOVE_INDEX: {
                        finalActions.add(new AliasAction.RemoveIndex(index.getName()));
                        continue block7;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported action [" + String.valueOf((Object)action.actionType()) + "]");
                    }
                }
            }
        }
        if (finalActions.isEmpty() && !actions.isEmpty()) {
            throw new AliasesNotFoundException(aliases.toArray(new String[0]));
        }
        request.aliasActions().clear();
        IndicesAliasesClusterStateUpdateRequest updateRequest = (IndicesAliasesClusterStateUpdateRequest)((IndicesAliasesClusterStateUpdateRequest)new IndicesAliasesClusterStateUpdateRequest(Collections.unmodifiableList(finalActions)).ackTimeout(request.timeout())).clusterManagerNodeTimeout(request.clusterManagerNodeTimeout());
        this.indexAliasesService.indicesAliases(updateRequest, new ActionListener<ClusterStateUpdateResponse>(){

            @Override
            public void onResponse(ClusterStateUpdateResponse response) {
                listener.onResponse(new AcknowledgedResponse(response.isAcknowledged()));
            }

            @Override
            public void onFailure(Exception t) {
                logger.debug("failed to perform aliases", (Throwable)t);
                listener.onFailure(t);
            }
        });
    }

    private static String[] concreteAliases(IndicesAliasesRequest.AliasActions action, Metadata metadata, String concreteIndex) {
        if (action.expandAliasesWildcards()) {
            String[] indexAsArray = new String[]{concreteIndex};
            Map<String, List<AliasMetadata>> aliasMetadata = metadata.findAliases(action, indexAsArray);
            HashSet<String> finalAliases = new HashSet<String>();
            for (List<AliasMetadata> curAliases : aliasMetadata.values()) {
                for (AliasMetadata aliasMeta : curAliases) {
                    finalAliases.add(aliasMeta.alias());
                }
            }
            if (action.mustExist() != null) {
                if (!action.mustExist().booleanValue()) {
                    return action.aliases();
                }
                if (finalAliases.isEmpty()) {
                    throw new AliasesNotFoundException(action.aliases());
                }
                String[] nonExistingAliases = (String[])Arrays.stream(action.aliases()).filter(originalAlias -> finalAliases.stream().noneMatch(finalAlias -> Regex.simpleMatch(originalAlias, finalAlias))).toArray(String[]::new);
                if (nonExistingAliases.length != 0) {
                    throw new AliasesNotFoundException(nonExistingAliases);
                }
            }
            return finalAliases.toArray(new String[0]);
        }
        return action.aliases();
    }
}

