/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.indices.scale.searchonly;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.opensearch.action.admin.indices.scale.searchonly.ScaleIndexNodeRequest;
import org.opensearch.action.admin.indices.scale.searchonly.ScaleIndexNodeResponse;
import org.opensearch.action.admin.indices.scale.searchonly.ScaleIndexResponse;
import org.opensearch.action.admin.indices.scale.searchonly.ScaleIndexShardResponse;
import org.opensearch.action.support.GroupedActionListener;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.routing.ShardRouting;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.transport.TransportException;
import org.opensearch.transport.TransportResponseHandler;
import org.opensearch.transport.TransportService;

class ScaleIndexShardSyncManager {
    private final ClusterService clusterService;
    private final TransportService transportService;
    private final String transportActionName;

    ScaleIndexShardSyncManager(ClusterService clusterService, TransportService transportService, String transportActionName) {
        this.clusterService = clusterService;
        this.transportService = transportService;
        this.transportActionName = transportActionName;
    }

    void sendShardSyncRequests(String index, Map<ShardId, String> primaryShardsNodes, ActionListener<Collection<ScaleIndexNodeResponse>> listener) {
        if (primaryShardsNodes.isEmpty()) {
            listener.onFailure(new IllegalStateException("No primary shards found for index " + index));
            return;
        }
        Map nodeShardGroups = primaryShardsNodes.entrySet().stream().collect(Collectors.groupingBy(Map.Entry::getValue, Collectors.mapping(Map.Entry::getKey, Collectors.toList())));
        GroupedActionListener<ScaleIndexNodeResponse> groupedListener = new GroupedActionListener<ScaleIndexNodeResponse>(listener, nodeShardGroups.size());
        for (Map.Entry entry : nodeShardGroups.entrySet()) {
            String nodeId = entry.getKey();
            List<ShardId> shards = entry.getValue();
            DiscoveryNode targetNode = this.clusterService.state().nodes().get(nodeId);
            if (targetNode == null) {
                groupedListener.onFailure(new IllegalStateException("Node [" + nodeId + "] not found"));
                continue;
            }
            this.sendNodeRequest(targetNode, index, shards, groupedListener);
        }
    }

    void sendNodeRequest(DiscoveryNode targetNode, String index, List<ShardId> shards, final ActionListener<ScaleIndexNodeResponse> listener) {
        this.transportService.sendRequest(targetNode, this.transportActionName, new ScaleIndexNodeRequest(index, shards), new TransportResponseHandler<ScaleIndexNodeResponse>(){

            @Override
            public ScaleIndexNodeResponse read(StreamInput in) throws IOException {
                return new ScaleIndexNodeResponse(in);
            }

            @Override
            public void handleResponse(ScaleIndexNodeResponse response) {
                listener.onResponse(response);
            }

            @Override
            public void handleException(TransportException exp) {
                listener.onFailure(exp);
            }

            @Override
            public String executor() {
                return "same";
            }
        });
    }

    void validateNodeResponses(Collection<ScaleIndexNodeResponse> responses, ActionListener<ScaleIndexResponse> listener) {
        boolean hasUncommittedOps = false;
        boolean needsSync = false;
        ArrayList<String> failedShards = new ArrayList<String>();
        for (ScaleIndexNodeResponse nodeResponse : responses) {
            for (ScaleIndexShardResponse shardResponse : nodeResponse.getShardResponses()) {
                if (shardResponse.hasUncommittedOperations()) {
                    hasUncommittedOps = true;
                    failedShards.add(shardResponse.getShardId().toString());
                }
                if (!shardResponse.needsSync()) continue;
                needsSync = true;
                failedShards.add(shardResponse.getShardId().toString());
            }
        }
        if (hasUncommittedOps || needsSync) {
            String errorDetails = "Pre-scale sync failed for shards: " + String.join((CharSequence)", ", failedShards) + (hasUncommittedOps ? " - uncommitted operations remain" : "") + (needsSync ? " - sync needed" : "");
            listener.onFailure(new IllegalStateException(errorDetails));
        } else {
            listener.onResponse(new ScaleIndexResponse(responses));
        }
    }

    Map<ShardId, String> getPrimaryShardAssignments(IndexMetadata indexMetadata, ClusterState state) {
        HashMap<ShardId, String> assignments = new HashMap<ShardId, String>();
        for (int i = 0; i < indexMetadata.getNumberOfShards(); ++i) {
            ShardId shardId = new ShardId(indexMetadata.getIndex(), i);
            ShardRouting primaryShard = state.routingTable().index(indexMetadata.getIndex().getName()).shard(i).primaryShard();
            if (primaryShard == null || !primaryShard.assignedToNode()) continue;
            assignments.put(shardId, primaryShard.currentNodeId());
        }
        return assignments;
    }
}

