/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.indices.streamingingestion.state;

import java.io.IOException;
import java.util.List;
import org.opensearch.action.admin.indices.streamingingestion.IngestionStateShardFailure;
import org.opensearch.action.support.broadcast.BroadcastResponse;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.core.action.support.DefaultShardOperationFailedException;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;

@ExperimentalApi
public class UpdateIngestionStateResponse
extends BroadcastResponse {
    private boolean acknowledged;
    private String errorMessage = "";
    private final IngestionStateShardFailure[] shardFailureList;

    public UpdateIngestionStateResponse(StreamInput in) throws IOException {
        super(in);
        this.acknowledged = in.readBoolean();
        this.errorMessage = in.readString();
        this.shardFailureList = in.readArray(IngestionStateShardFailure::new, IngestionStateShardFailure[]::new);
    }

    public UpdateIngestionStateResponse(boolean acknowledged, int totalShards, int successfulShards, int failedShards, List<DefaultShardOperationFailedException> shardFailures) {
        super(totalShards, successfulShards, failedShards, shardFailures);
        this.acknowledged = acknowledged;
        this.shardFailureList = (IngestionStateShardFailure[])shardFailures.stream().map(shardFailure -> new IngestionStateShardFailure(shardFailure.index(), shardFailure.shardId(), shardFailure.reason())).toArray(IngestionStateShardFailure[]::new);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeBoolean(this.acknowledged);
        out.writeString(this.errorMessage);
        out.writeArray(this.shardFailureList);
    }

    public IngestionStateShardFailure[] getShardFailureList() {
        return this.shardFailureList;
    }

    public boolean isAcknowledged() {
        return this.acknowledged;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }
}

