/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.fieldcaps;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.action.ActionRunnable;
import org.opensearch.action.ActionType;
import org.opensearch.action.NoShardAvailableActionException;
import org.opensearch.action.fieldcaps.FieldCapabilitiesIndexRequest;
import org.opensearch.action.fieldcaps.FieldCapabilitiesIndexResponse;
import org.opensearch.action.fieldcaps.IndexFieldCapabilities;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.ChannelActionListener;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.action.support.TransportActions;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.block.ClusterBlockException;
import org.opensearch.cluster.block.ClusterBlockLevel;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.node.DiscoveryNodes;
import org.opensearch.cluster.routing.FailAwareWeightedRouting;
import org.opensearch.cluster.routing.GroupShardsIterator;
import org.opensearch.cluster.routing.ShardIterator;
import org.opensearch.cluster.routing.ShardRouting;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.Nullable;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.logging.LoggerMessageFormat;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.mapper.MapperService;
import org.opensearch.index.mapper.ObjectMapper;
import org.opensearch.index.query.MatchAllQueryBuilder;
import org.opensearch.indices.IndicesService;
import org.opensearch.search.SearchService;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.search.internal.AliasFilter;
import org.opensearch.search.internal.ShardSearchRequest;
import org.opensearch.tasks.Task;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportChannel;
import org.opensearch.transport.TransportException;
import org.opensearch.transport.TransportRequestHandler;
import org.opensearch.transport.TransportResponseHandler;
import org.opensearch.transport.TransportService;

public class TransportFieldCapabilitiesIndexAction
extends HandledTransportAction<FieldCapabilitiesIndexRequest, FieldCapabilitiesIndexResponse> {
    private static final Logger logger = LogManager.getLogger(TransportFieldCapabilitiesIndexAction.class);
    private static final String ACTION_NAME = "indices:data/read/field_caps[index]";
    private static final String ACTION_SHARD_NAME = "indices:data/read/field_caps[index][s]";
    public static final ActionType<FieldCapabilitiesIndexResponse> TYPE = new ActionType<FieldCapabilitiesIndexResponse>("indices:data/read/field_caps[index]", FieldCapabilitiesIndexResponse::new);
    private final ClusterService clusterService;
    private final TransportService transportService;
    private final SearchService searchService;
    private final IndicesService indicesService;
    private final Executor executor;

    @Inject
    public TransportFieldCapabilitiesIndexAction(ClusterService clusterService, TransportService transportService, IndicesService indicesService, SearchService searchService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(ACTION_NAME, transportService, actionFilters, FieldCapabilitiesIndexRequest::new);
        this.clusterService = clusterService;
        this.transportService = transportService;
        this.searchService = searchService;
        this.indicesService = indicesService;
        this.executor = threadPool.executor("management");
        transportService.registerRequestHandler(ACTION_SHARD_NAME, "same", FieldCapabilitiesIndexRequest::new, new ShardTransportHandler());
    }

    @Override
    protected void doExecute(Task task, FieldCapabilitiesIndexRequest request, ActionListener<FieldCapabilitiesIndexResponse> listener) {
        new AsyncShardsAction(request, listener).start();
    }

    private FieldCapabilitiesIndexResponse shardOperation(FieldCapabilitiesIndexRequest request) throws IOException {
        if (!this.canMatchShard(request)) {
            return new FieldCapabilitiesIndexResponse(request.index(), Collections.emptyMap(), false);
        }
        ShardId shardId = request.shardId();
        MapperService mapperService = this.indicesService.indexServiceSafe(shardId.getIndex()).mapperService();
        HashSet<String> fieldNames = new HashSet<String>();
        for (String field : request.fields()) {
            fieldNames.addAll(mapperService.simpleMatchToFullName(field));
        }
        Predicate<String> fieldPredicate = this.indicesService.getFieldFilter().apply(shardId.getIndexName());
        HashMap<String, IndexFieldCapabilities> responseMap = new HashMap<String, IndexFieldCapabilities>();
        for (String field : fieldNames) {
            String parentField;
            MappedFieldType ft = mapperService.fieldType(field);
            if (ft == null || !this.indicesService.isMetadataField(field) && !fieldPredicate.test(ft.name())) continue;
            IndexFieldCapabilities fieldCap = new IndexFieldCapabilities(field, ft.familyTypeName(), ft.isSearchable(), ft.isAggregatable(), ft.meta());
            responseMap.put(field, fieldCap);
            int dotIndex = ft.name().lastIndexOf(46);
            while (dotIndex > -1 && !responseMap.containsKey(parentField = ft.name().substring(0, dotIndex))) {
                if (mapperService.fieldType(parentField) == null) {
                    ObjectMapper mapper = mapperService.getObjectMapper(parentField);
                    String type = mapper.nested().isNested() ? "nested" : "object";
                    IndexFieldCapabilities fieldCap2 = new IndexFieldCapabilities(parentField, type, false, false, Collections.emptyMap());
                    responseMap.put(parentField, fieldCap2);
                }
                dotIndex = parentField.lastIndexOf(46);
            }
        }
        return new FieldCapabilitiesIndexResponse(request.index(), responseMap, true);
    }

    private boolean canMatchShard(FieldCapabilitiesIndexRequest req) throws IOException {
        if (req.indexFilter() == null || req.indexFilter() instanceof MatchAllQueryBuilder) {
            return true;
        }
        assert (req.nowInMillis() != 0L);
        ShardSearchRequest searchRequest = new ShardSearchRequest(req.shardId(), req.nowInMillis(), AliasFilter.EMPTY);
        searchRequest.source(new SearchSourceBuilder().query(req.indexFilter()));
        return this.searchService.canMatch(searchRequest).canMatch();
    }

    private ClusterBlockException checkGlobalBlock(ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.READ);
    }

    private ClusterBlockException checkRequestBlock(ClusterState state, String concreteIndex) {
        return state.blocks().indexBlockedException(ClusterBlockLevel.READ, concreteIndex);
    }

    private class ShardTransportHandler
    implements TransportRequestHandler<FieldCapabilitiesIndexRequest> {
        private ShardTransportHandler() {
        }

        @Override
        public void messageReceived(FieldCapabilitiesIndexRequest request, TransportChannel channel, Task task) throws Exception {
            if (logger.isTraceEnabled()) {
                logger.trace("executing [{}]", (Object)request);
            }
            ChannelActionListener listener = new ChannelActionListener(channel, TransportFieldCapabilitiesIndexAction.ACTION_SHARD_NAME, request);
            TransportFieldCapabilitiesIndexAction.this.executor.execute(ActionRunnable.supply(listener, () -> TransportFieldCapabilitiesIndexAction.this.shardOperation(request)));
        }
    }

    class AsyncShardsAction {
        private final FieldCapabilitiesIndexRequest request;
        private final DiscoveryNodes nodes;
        private final ActionListener<FieldCapabilitiesIndexResponse> listener;
        private final GroupShardsIterator<ShardIterator> shardsIt;
        private volatile int shardIndex = 0;

        private AsyncShardsAction(FieldCapabilitiesIndexRequest request, ActionListener<FieldCapabilitiesIndexResponse> listener) {
            this.listener = listener;
            ClusterState clusterState = TransportFieldCapabilitiesIndexAction.this.clusterService.state();
            if (logger.isTraceEnabled()) {
                logger.trace("executing [{}] based on cluster state version [{}]", (Object)request, (Object)clusterState.version());
            }
            this.nodes = clusterState.nodes();
            ClusterBlockException blockException = TransportFieldCapabilitiesIndexAction.this.checkGlobalBlock(clusterState);
            if (blockException != null) {
                throw blockException;
            }
            this.request = request;
            blockException = TransportFieldCapabilitiesIndexAction.this.checkRequestBlock(clusterState, request.index());
            if (blockException != null) {
                throw blockException;
            }
            this.shardsIt = TransportFieldCapabilitiesIndexAction.this.clusterService.operationRouting().searchShards(TransportFieldCapabilitiesIndexAction.this.clusterService.state(), new String[]{request.index()}, null, null);
        }

        public void start() {
            this.tryNext(null, true);
        }

        private void onFailure(ShardRouting shardRouting, Exception e) {
            if (e != null) {
                logger.trace(() -> new ParameterizedMessage("{}: failed to execute [{}]", (Object)shardRouting, (Object)this.request), (Throwable)e);
            }
            this.tryNext(e, false);
        }

        private ShardRouting nextRoutingOrNull(Exception failure) {
            if (this.shardsIt.size() == 0 || this.shardIndex >= this.shardsIt.size()) {
                return null;
            }
            ShardRouting next = FailAwareWeightedRouting.getInstance().findNext(this.shardsIt.get(this.shardIndex), TransportFieldCapabilitiesIndexAction.this.clusterService.state(), failure, this::moveToNextShard);
            if (next != null) {
                return next;
            }
            this.moveToNextShard();
            return this.nextRoutingOrNull(failure);
        }

        private void moveToNextShard() {
            ++this.shardIndex;
        }

        private void tryNext(@Nullable Exception lastFailure, boolean canMatchShard) {
            final ShardRouting shardRouting = this.nextRoutingOrNull(lastFailure);
            if (shardRouting == null) {
                if (!canMatchShard) {
                    this.listener.onResponse(new FieldCapabilitiesIndexResponse(this.request.index(), Collections.emptyMap(), false));
                } else if (lastFailure == null || TransportActions.isShardNotAvailableException(lastFailure)) {
                    this.listener.onFailure(new NoShardAvailableActionException(null, LoggerMessageFormat.format("No shard available for [{}]", this.request), lastFailure));
                } else {
                    logger.debug(() -> new ParameterizedMessage("{}: failed to execute [{}]", null, (Object)this.request), (Throwable)lastFailure);
                    this.listener.onFailure(lastFailure);
                }
                return;
            }
            DiscoveryNode node = this.nodes.get(shardRouting.currentNodeId());
            if (node == null) {
                this.onFailure(shardRouting, new NoShardAvailableActionException(shardRouting.shardId()));
            } else {
                this.request.shardId(shardRouting.shardId());
                if (logger.isTraceEnabled()) {
                    logger.trace("sending request [{}] on node [{}]", (Object)this.request, (Object)node);
                }
                TransportFieldCapabilitiesIndexAction.this.transportService.sendRequest(node, TransportFieldCapabilitiesIndexAction.ACTION_SHARD_NAME, this.request, new TransportResponseHandler<FieldCapabilitiesIndexResponse>(){
                    final /* synthetic */ AsyncShardsAction this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public FieldCapabilitiesIndexResponse read(StreamInput in) throws IOException {
                        return new FieldCapabilitiesIndexResponse(in);
                    }

                    @Override
                    public String executor() {
                        return "same";
                    }

                    @Override
                    public void handleResponse(FieldCapabilitiesIndexResponse response) {
                        if (response.canMatch()) {
                            this.this$1.listener.onResponse(response);
                        } else {
                            this.this$1.moveToNextShard();
                            this.this$1.tryNext(null, false);
                        }
                    }

                    @Override
                    public void handleException(TransportException exp) {
                        this.this$1.onFailure(shardRouting, exp);
                    }
                });
            }
        }
    }
}

