/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.search;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.search.AbstractSearchAsyncAction;
import org.opensearch.action.search.QueryPhaseResultConsumer;
import org.opensearch.action.search.SearchActionListener;
import org.opensearch.action.search.SearchPhase;
import org.opensearch.action.search.SearchPhaseController;
import org.opensearch.action.search.SearchPhaseExecutionException;
import org.opensearch.action.search.SearchQueryThenFetchAsyncAction;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchRequestContext;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.search.SearchShardIterator;
import org.opensearch.action.search.SearchTask;
import org.opensearch.action.search.SearchTransportService;
import org.opensearch.action.search.StreamQueryPhaseResultConsumer;
import org.opensearch.action.search.StreamSearchActionListener;
import org.opensearch.action.search.TransportSearchAction;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.routing.GroupShardsIterator;
import org.opensearch.core.action.ActionListener;
import org.opensearch.search.SearchPhaseResult;
import org.opensearch.search.SearchShardTarget;
import org.opensearch.search.internal.AliasFilter;
import org.opensearch.telemetry.tracing.Tracer;
import org.opensearch.transport.Transport;

public class StreamSearchQueryThenFetchAsyncAction
extends SearchQueryThenFetchAsyncAction {
    private final AtomicInteger streamResultsReceived = new AtomicInteger(0);
    private final AtomicInteger streamResultsConsumeCallback = new AtomicInteger(0);
    private final AtomicBoolean shardResultsConsumed = new AtomicBoolean(false);

    StreamSearchQueryThenFetchAsyncAction(Logger logger, SearchTransportService searchTransportService, BiFunction<String, String, Transport.Connection> nodeIdToConnection, Map<String, AliasFilter> aliasFilter, Map<String, Float> concreteIndexBoosts, Map<String, Set<String>> indexRoutings, SearchPhaseController searchPhaseController, Executor executor, QueryPhaseResultConsumer resultConsumer, SearchRequest request, ActionListener<SearchResponse> listener, GroupShardsIterator<SearchShardIterator> shardsIts, TransportSearchAction.SearchTimeProvider timeProvider, ClusterState clusterState, SearchTask task, SearchResponse.Clusters clusters, SearchRequestContext searchRequestContext, Tracer tracer) {
        super(logger, searchTransportService, nodeIdToConnection, aliasFilter, concreteIndexBoosts, indexRoutings, searchPhaseController, executor, resultConsumer, request, listener, shardsIts, timeProvider, clusterState, task, clusters, searchRequestContext, tracer);
    }

    @Override
    SearchActionListener<SearchPhaseResult> createShardActionListener(final SearchShardTarget shard, final int shardIndex, final SearchShardIterator shardIt, final SearchPhase phase, final AbstractSearchAsyncAction.PendingExecutions pendingExecutions, final Thread thread) {
        return new StreamSearchActionListener<SearchPhaseResult>(this, shard, shardIndex){
            final /* synthetic */ StreamSearchQueryThenFetchAsyncAction this$0;
            {
                this.this$0 = this$0;
                super(searchShardTarget, shardIndex2);
            }

            @Override
            protected void innerOnStreamResponse(SearchPhaseResult result) {
                try {
                    this.this$0.streamResultsReceived.incrementAndGet();
                    this.this$0.onStreamResult(result, shardIt, () -> this.this$0.successfulStreamExecution());
                }
                finally {
                    this.this$0.executeNext(pendingExecutions, thread);
                }
            }

            @Override
            protected void innerOnCompleteResponse(SearchPhaseResult result) {
                try {
                    this.this$0.onShardResult(result, shardIt);
                }
                finally {
                    this.this$0.executeNext(pendingExecutions, thread);
                }
            }

            @Override
            public void onFailure(Exception t) {
                try {
                    if (this.this$0.totalOps.get() == this.this$0.expectedTotalOps) {
                        this.this$0.onPhaseFailure(phase, "The phase has failed", t);
                    } else {
                        this.this$0.onShardFailure(shardIndex, shard, shardIt, t);
                    }
                }
                finally {
                    this.this$0.executeNext(pendingExecutions, thread);
                }
            }
        };
    }

    protected void onStreamResult(SearchPhaseResult result, SearchShardIterator shardIt, Runnable next) {
        assert (result.getShardIndex() != -1) : "shard index is not set";
        assert (result.getSearchShardTarget() != null) : "search shard target must not be null";
        if (this.getLogger().isTraceEnabled()) {
            this.getLogger().trace("got streaming result from {}", (Object)(result != null ? result.getSearchShardTarget() : null));
        }
        this.setPhaseResourceUsages();
        ((StreamQueryPhaseResultConsumer)this.results).consumeStreamResult(result, next);
    }

    @Override
    void successfulShardExecution(SearchShardIterator shardsIt) {
        block7: {
            int remainingOpsOnIterator = shardsIt.skip() ? shardsIt.remaining() : shardsIt.remaining() + 1;
            int xTotalOps = this.totalOps.addAndGet(remainingOpsOnIterator);
            if (xTotalOps == this.expectedTotalOps) {
                try {
                    this.shardResultsConsumed.set(true);
                    if (this.streamResultsReceived.get() == this.streamResultsConsumeCallback.get()) {
                        this.getLogger().debug("Stream results consumption has called back, let shard consumption callback trigger onPhaseDone");
                        this.onPhaseDone();
                        break block7;
                    }
                    assert (this.streamResultsReceived.get() > this.streamResultsConsumeCallback.get());
                    this.getLogger().debug("Shard results consumption finishes before stream results, let stream consumption callback trigger onPhaseDone");
                }
                catch (Exception ex) {
                    this.onPhaseFailure(this, "The phase has failed", ex);
                }
            } else if (xTotalOps > this.expectedTotalOps) {
                throw new AssertionError("unexpected higher total ops [" + xTotalOps + "] compared to expected [" + this.expectedTotalOps + "]", new SearchPhaseExecutionException(this.getName(), "Shard failures", null, this.buildShardFailures()));
            }
        }
    }

    private void successfulStreamExecution() {
        try {
            if (this.streamResultsReceived.get() == this.streamResultsConsumeCallback.incrementAndGet() && this.shardResultsConsumed.get()) {
                this.getLogger().debug("Stream consumption trigger onPhaseDone");
                this.onPhaseDone();
            }
        }
        catch (Exception ex) {
            this.onPhaseFailure(this, "The phase has failed", ex);
        }
    }
}

