/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.support;

import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.action.ActionRunnable;
import org.opensearch.common.util.concurrent.AbstractRunnable;
import org.opensearch.core.action.ActionListener;
import org.opensearch.threadpool.ThreadPool;

public final class ThreadedActionListener<Response>
implements ActionListener<Response> {
    private final Logger logger;
    private final ThreadPool threadPool;
    private final String executor;
    private final ActionListener<Response> listener;
    private final boolean forceExecution;

    public ThreadedActionListener(Logger logger, ThreadPool threadPool, String executor, ActionListener<Response> listener, boolean forceExecution) {
        this.logger = logger;
        this.threadPool = threadPool;
        this.executor = executor;
        this.listener = listener;
        this.forceExecution = forceExecution;
    }

    @Override
    public void onResponse(final Response response) {
        this.threadPool.executor(this.executor).execute(new ActionRunnable<Response>(this, this.listener){
            final /* synthetic */ ThreadedActionListener this$0;
            {
                this.this$0 = this$0;
                super(listener);
            }

            @Override
            public boolean isForceExecution() {
                return this.this$0.forceExecution;
            }

            @Override
            protected void doRun() {
                this.listener.onResponse(response);
            }
        });
    }

    @Override
    public void onFailure(final Exception e) {
        this.threadPool.executor(this.executor).execute(new AbstractRunnable(this){
            final /* synthetic */ ThreadedActionListener this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean isForceExecution() {
                return this.this$0.forceExecution;
            }

            @Override
            protected void doRun() throws Exception {
                this.this$0.listener.onFailure(e);
            }

            @Override
            public void onFailure(Exception e2) {
                this.this$0.logger.warn(() -> new ParameterizedMessage("failed to execute failure callback on [{}]", this.this$0.listener), (Throwable)e2);
            }
        });
    }
}

