/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.cluster;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.opensearch.client.cluster.RemoteConnectionInfo;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;

public final class RemoteInfoResponse {
    private List<RemoteConnectionInfo> infos;

    RemoteInfoResponse(List<RemoteConnectionInfo> infos) {
        this.infos = Collections.unmodifiableList(infos);
    }

    public List<RemoteConnectionInfo> getInfos() {
        return this.infos;
    }

    public static RemoteInfoResponse fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.nextToken(), parser);
        ArrayList<RemoteConnectionInfo> infos = new ArrayList<RemoteConnectionInfo>();
        while ((token = parser.nextToken()) == XContentParser.Token.FIELD_NAME) {
            String clusterAlias = parser.currentName();
            RemoteConnectionInfo info = RemoteConnectionInfo.fromXContent(parser, clusterAlias);
            infos.add(info);
        }
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.END_OBJECT, token, parser);
        return new RemoteInfoResponse(infos);
    }
}

