/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.http;

import java.nio.ByteBuffer;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.nio.AsyncEntityProducer;
import org.apache.hc.core5.http.nio.support.BasicRequestProducer;
import org.apache.hc.core5.net.NamedEndpoint;
import org.apache.hc.core5.net.URIAuthority;
import org.apache.hc.core5.reactive.ReactiveEntityProducer;
import org.apache.hc.core5.util.Args;
import org.reactivestreams.Publisher;

public class ReactiveHttpUriRequestProducer
extends BasicRequestProducer {
    private final HttpUriRequestBase request;

    ReactiveHttpUriRequestProducer(HttpUriRequestBase request, AsyncEntityProducer entityProducer) {
        super((HttpRequest)request, entityProducer);
        this.request = request;
    }

    public HttpUriRequestBase getRequest() {
        return this.request;
    }

    public static ReactiveHttpUriRequestProducer create(HttpUriRequestBase request, HttpHost host, Publisher<ByteBuffer> publisher) {
        Args.notNull((Object)request, (String)"Request");
        Args.notNull((Object)host, (String)"HttpHost");
        request.setAuthority(new URIAuthority((NamedEndpoint)host));
        request.setScheme(host.getSchemeName());
        Header contentTypeHeader = request.getFirstHeader("Content-Type");
        ContentType contentType = contentTypeHeader == null ? ContentType.APPLICATION_JSON : ContentType.parse(contentTypeHeader.getValue());
        Header contentEncodingHeader = request.getFirstHeader("Content-Encoding");
        String contentEncoding = contentEncodingHeader == null ? null : contentEncodingHeader.getValue();
        ReactiveEntityProducer entityProducer = new ReactiveEntityProducer(publisher, -1L, contentType, contentEncoding);
        return new ReactiveHttpUriRequestProducer(request, (AsyncEntityProducer)entityProducer);
    }
}

