/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.metadata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.metadata.Metadata;
import org.opensearch.cluster.metadata.MetadataIndexStateService;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.routing.allocation.RoutingAllocation;
import org.opensearch.cluster.routing.allocation.decider.Decision;
import org.opensearch.common.Booleans;
import org.opensearch.common.settings.Setting;

public final class AutoExpandSearchReplicas {
    private static final String ALL_NODES_VALUE = "all";
    private static final AutoExpandSearchReplicas FALSE_INSTANCE = new AutoExpandSearchReplicas(0, 0, false);
    public static final Setting<AutoExpandSearchReplicas> SETTING = new Setting<AutoExpandSearchReplicas>("index.auto_expand_search_replicas", "false", AutoExpandSearchReplicas::parse, Setting.Property.Dynamic, Setting.Property.IndexScope);
    private final int minSearchReplicas;
    private final int maxSearchReplicas;
    private final boolean enabled;

    private static AutoExpandSearchReplicas parse(String value) {
        int max;
        int min;
        if (Booleans.isFalse(value)) {
            return FALSE_INSTANCE;
        }
        int dash = value.indexOf(45);
        if (-1 == dash) {
            throw new IllegalArgumentException("failed to parse [index.auto_expand_search_replicas] from value: [" + value + "] at index " + dash);
        }
        String sMin = value.substring(0, dash);
        try {
            min = Integer.parseInt(sMin);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("failed to parse [index.auto_expand_search_replicas] from value: [" + value + "] at index " + dash, e);
        }
        String sMax = value.substring(dash + 1);
        if (sMax.equals(ALL_NODES_VALUE)) {
            max = Integer.MAX_VALUE;
        } else {
            try {
                max = Integer.parseInt(sMax);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("failed to parse [index.auto_expand_search_replicas] from value: [" + value + "] at index " + dash, e);
            }
        }
        return new AutoExpandSearchReplicas(min, max, true);
    }

    private AutoExpandSearchReplicas(int minReplicas, int maxReplicas, boolean enabled) {
        if (minReplicas > maxReplicas) {
            throw new IllegalArgumentException("[index.auto_expand_search_replicas] minSearchReplicas must be =< maxSearchReplicas but wasn't " + minReplicas + " > " + maxReplicas);
        }
        this.minSearchReplicas = minReplicas;
        this.maxSearchReplicas = maxReplicas;
        this.enabled = enabled;
    }

    int getMinSearchReplicas() {
        return this.minSearchReplicas;
    }

    public int getMaxSearchReplicas() {
        return this.maxSearchReplicas;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    private OptionalInt getDesiredNumberOfSearchReplicas(IndexMetadata indexMetadata, RoutingAllocation allocation) {
        int numMatchingSearchNodes = (int)allocation.nodes().getDataNodes().values().stream().filter(DiscoveryNode::isSearchNode).map(node -> allocation.deciders().shouldAutoExpandToNode(indexMetadata, (DiscoveryNode)node, allocation)).filter(decision -> decision.type() != Decision.Type.NO).count();
        return this.calculateNumberOfSearchReplicas(numMatchingSearchNodes);
    }

    OptionalInt calculateNumberOfSearchReplicas(int numMatchingSearchNodes) {
        int maxPossibleReplicas = Math.min(numMatchingSearchNodes, this.maxSearchReplicas);
        int numberOfSearchReplicas = Math.max(this.minSearchReplicas, maxPossibleReplicas);
        if (numberOfSearchReplicas <= maxPossibleReplicas) {
            return OptionalInt.of(numberOfSearchReplicas);
        }
        return OptionalInt.empty();
    }

    public String toString() {
        return this.enabled ? this.minSearchReplicas + "-" + this.maxSearchReplicas : "false";
    }

    public static Map<Integer, List<String>> getAutoExpandSearchReplicaChanges(Metadata metadata, RoutingAllocation allocation) {
        HashMap<Integer, List<String>> updatedSearchReplicas = new HashMap<Integer, List<String>>();
        for (IndexMetadata indexMetadata : metadata) {
            AutoExpandSearchReplicas autoExpandSearchReplicas;
            if (indexMetadata.getState() != IndexMetadata.State.OPEN && !MetadataIndexStateService.isIndexVerifiedBeforeClosed(indexMetadata) || !(autoExpandSearchReplicas = SETTING.get(indexMetadata.getSettings())).isEnabled()) continue;
            autoExpandSearchReplicas.getDesiredNumberOfSearchReplicas(indexMetadata, allocation).ifPresent(numberOfSearchReplicas -> {
                if (numberOfSearchReplicas != indexMetadata.getNumberOfSearchOnlyReplicas()) {
                    updatedSearchReplicas.computeIfAbsent(numberOfSearchReplicas, ArrayList::new).add(indexMetadata.getIndex().getName());
                }
            });
        }
        return updatedSearchReplicas;
    }
}

