/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common;

import java.io.IOException;
import org.opensearch.common.CheckedTriFunction;
import org.opensearch.common.io.InputStreamContainer;

public class StreamContext {
    private final CheckedTriFunction<Integer, Long, Long, InputStreamContainer, IOException> streamSupplier;
    private final long partSize;
    private final long lastPartSize;
    private final int numberOfParts;

    public StreamContext(CheckedTriFunction<Integer, Long, Long, InputStreamContainer, IOException> streamSupplier, long partSize, long lastPartSize, int numberOfParts) {
        this.streamSupplier = streamSupplier;
        this.partSize = partSize;
        this.lastPartSize = lastPartSize;
        this.numberOfParts = numberOfParts;
    }

    protected StreamContext(StreamContext streamContext) {
        this.streamSupplier = streamContext.streamSupplier;
        this.partSize = streamContext.partSize;
        this.numberOfParts = streamContext.numberOfParts;
        this.lastPartSize = streamContext.lastPartSize;
    }

    public InputStreamContainer provideStream(int partNumber) throws IOException {
        long position = this.partSize * (long)partNumber;
        long size = partNumber == this.numberOfParts - 1 ? this.lastPartSize : this.partSize;
        return this.streamSupplier.apply(partNumber, size, position);
    }

    public int getNumberOfParts() {
        return this.numberOfParts;
    }
}

