/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.cache.serializer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.common.cache.ICacheKey;
import org.opensearch.common.cache.serializer.Serializer;
import org.opensearch.common.io.stream.BytesStreamOutput;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.common.io.stream.BytesStreamInput;

public class ICacheKeySerializer<K>
implements Serializer<ICacheKey<K>, byte[]> {
    public final Serializer<K, byte[]> keySerializer;
    private final Logger logger = LogManager.getLogger(ICacheKeySerializer.class);

    public ICacheKeySerializer(Serializer<K, byte[]> serializer) {
        this.keySerializer = serializer;
    }

    @Override
    public byte[] serialize(ICacheKey<K> object) {
        if (object == null || object.key == null || object.dimensions == null) {
            return null;
        }
        byte[] serializedKey = this.keySerializer.serialize(object.key);
        try {
            BytesStreamOutput os = new BytesStreamOutput();
            os.writeVInt(object.dimensions.size());
            for (String dimValue : object.dimensions) {
                os.writeString(dimValue);
            }
            os.writeVInt(serializedKey.length);
            os.writeBytes(serializedKey);
            byte[] finalBytes = BytesReference.toBytes(os.bytes());
            return finalBytes;
        }
        catch (IOException e) {
            this.logger.debug("Could not write ICacheKey to byte[]");
            throw new OpenSearchException(e);
        }
    }

    @Override
    public ICacheKey<K> deserialize(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        ArrayList<String> dimensionList = new ArrayList<String>();
        try {
            BytesStreamInput is = new BytesStreamInput(bytes, 0, bytes.length);
            int numDimensions = is.readVInt();
            for (int i = 0; i < numDimensions; ++i) {
                dimensionList.add(is.readString());
            }
            int length = is.readVInt();
            byte[] serializedKey = new byte[length];
            is.readBytes(serializedKey, 0, length);
            return new ICacheKey<K>(this.keySerializer.deserialize(serializedKey), dimensionList);
        }
        catch (IOException e) {
            this.logger.debug("Could not write byte[] to ICacheKey");
            throw new OpenSearchException(e);
        }
    }

    @Override
    public boolean equals(ICacheKey<K> object, byte[] bytes) {
        return Arrays.equals(this.serialize(object), bytes);
    }
}

