/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.lucene.index;

import java.io.IOException;
import java.util.Collections;
import org.apache.lucene.codecs.StoredFieldsReader;
import org.apache.lucene.index.DocValuesSkipIndexType;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.StoredFields;
import org.apache.lucene.index.VectorEncoding;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.opensearch.common.CheckedFunction;
import org.opensearch.core.common.bytes.BytesReference;

public class DerivedSourceStoredFieldsReader
extends StoredFieldsReader {
    private final StoredFieldsReader delegate;
    private final CheckedFunction<Integer, BytesReference, IOException> sourceProvider;
    private final DerivedSourceStoredFields storedFields;

    DerivedSourceStoredFieldsReader(StoredFieldsReader in, CheckedFunction<Integer, BytesReference, IOException> sourceProvider) {
        this.delegate = in;
        this.sourceProvider = sourceProvider;
        this.storedFields = new DerivedSourceStoredFields(in, sourceProvider);
    }

    @Override
    public StoredFieldsReader clone() {
        return new DerivedSourceStoredFieldsReader(this.delegate.clone(), this.sourceProvider);
    }

    @Override
    public void checkIntegrity() throws IOException {
        this.delegate.checkIntegrity();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    @Override
    public StoredFieldsReader getMergeInstance() {
        return this.delegate.getMergeInstance();
    }

    @Override
    public void document(int docId, StoredFieldVisitor visitor) throws IOException {
        this.storedFields.document(docId, visitor);
    }

    public static class DerivedSourceStoredFields
    extends StoredFields {
        private static final FieldInfo FAKE_SOURCE_FIELD = new FieldInfo("_source", 1, false, false, false, IndexOptions.NONE, DocValuesType.NONE, DocValuesSkipIndexType.NONE, -1L, Collections.emptyMap(), 0, 0, 0, 0, VectorEncoding.FLOAT32, VectorSimilarityFunction.EUCLIDEAN, false, false);
        private final CheckedFunction<Integer, BytesReference, IOException> sourceProvider;
        private final StoredFields delegate;

        public DerivedSourceStoredFields(StoredFields in, CheckedFunction<Integer, BytesReference, IOException> sourceProvider) {
            this.delegate = in;
            this.sourceProvider = sourceProvider;
        }

        @Override
        public void document(int docId, StoredFieldVisitor visitor) throws IOException {
            if (visitor.needsField(FAKE_SOURCE_FIELD) == StoredFieldVisitor.Status.YES) {
                visitor.binaryField(FAKE_SOURCE_FIELD, this.sourceProvider.apply((Integer)Integer.valueOf((int)docId)).toBytesRef().bytes);
            }
            this.delegate.document(docId, visitor);
        }
    }
}

