/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.lucene.search.function;

import org.apache.lucene.search.Explanation;
import org.opensearch.core.common.Strings;
import org.opensearch.index.query.AbstractQueryBuilder;
import org.opensearch.index.query.functionscore.FunctionScoreQueryBuilder;

public final class Functions {
    private Functions() {
    }

    public static String nameOrEmptyFunc(String functionName) {
        if (!Strings.isNullOrEmpty(functionName)) {
            return "(" + AbstractQueryBuilder.NAME_FIELD.getPreferredName() + ": " + functionName + ")";
        }
        return "";
    }

    public static String nameOrEmptyArg(String functionName) {
        if (!Strings.isNullOrEmpty(functionName)) {
            return ", " + FunctionScoreQueryBuilder.NAME_FIELD.getPreferredName() + ": " + functionName;
        }
        return "";
    }

    public static Explanation explainWithName(Explanation explanation, String queryName) {
        if (Strings.isNullOrEmpty(queryName)) {
            return explanation;
        }
        String description = explanation.getDescription() + " " + Functions.nameOrEmptyFunc(queryName);
        if (explanation.isMatch()) {
            return Explanation.match(explanation.getValue(), description, explanation.getDetails());
        }
        return Explanation.noMatch(description, explanation.getDetails());
    }
}

