/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.lucene.search.function;

import java.io.IOException;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;

final class MinScoreScorer
extends Scorer {
    private final Scorer in;
    private final float minScore;
    private float curScore;

    MinScoreScorer(Weight weight, Scorer scorer, float minScore) {
        this.in = scorer;
        this.minScore = minScore;
    }

    public Scorer getScorer() {
        return this.in;
    }

    @Override
    public int docID() {
        return this.in.docID();
    }

    @Override
    public float score() {
        return this.curScore;
    }

    @Override
    public int advanceShallow(int target) throws IOException {
        return this.in.advanceShallow(target);
    }

    @Override
    public float getMaxScore(int upTo) throws IOException {
        return this.in.getMaxScore(upTo);
    }

    @Override
    public DocIdSetIterator iterator() {
        return TwoPhaseIterator.asDocIdSetIterator(this.twoPhaseIterator());
    }

    @Override
    public TwoPhaseIterator twoPhaseIterator() {
        final TwoPhaseIterator inTwoPhase = this.in.twoPhaseIterator();
        DocIdSetIterator approximation = inTwoPhase == null ? this.in.iterator() : inTwoPhase.approximation();
        return new TwoPhaseIterator(this, approximation){
            final /* synthetic */ MinScoreScorer this$0;
            {
                this.this$0 = this$0;
                super(approximation);
            }

            @Override
            public boolean matches() throws IOException {
                if (inTwoPhase != null && !inTwoPhase.matches()) {
                    return false;
                }
                this.this$0.curScore = this.this$0.in.score();
                return this.this$0.curScore >= this.this$0.minScore;
            }

            @Override
            public float matchCost() {
                return 1000.0f + (inTwoPhase == null ? 0.0f : inTwoPhase.matchCost());
            }
        };
    }
}

