/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.lucene.search.function;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.FilterLeafCollector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;
import org.opensearch.Version;
import org.opensearch.common.Nullable;
import org.opensearch.common.lucene.search.function.Functions;
import org.opensearch.common.lucene.search.function.MinScoreScorer;
import org.opensearch.script.ScoreScript;
import org.opensearch.script.Script;

public class ScriptScoreQuery
extends Query {
    private final Query subQuery;
    private final Script script;
    private final ScoreScript.LeafFactory scriptBuilder;
    private final Float minScore;
    private final String indexName;
    private final int shardId;
    private final Version indexVersion;
    private final String queryName;

    public ScriptScoreQuery(Query subQuery, Script script, ScoreScript.LeafFactory scriptBuilder, Float minScore, String indexName, int shardId, Version indexVersion) {
        this(subQuery, null, script, scriptBuilder, minScore, indexName, shardId, indexVersion);
    }

    public ScriptScoreQuery(Query subQuery, @Nullable String queryName, Script script, ScoreScript.LeafFactory scriptBuilder, Float minScore, String indexName, int shardId, Version indexVersion) {
        this.subQuery = subQuery;
        this.queryName = queryName;
        this.script = script;
        this.scriptBuilder = scriptBuilder;
        this.minScore = minScore;
        this.indexName = indexName;
        this.shardId = shardId;
        this.indexVersion = indexVersion;
    }

    @Override
    public Query rewrite(IndexSearcher searcher) throws IOException {
        Query newQ = this.subQuery.rewrite(searcher);
        if (newQ != this.subQuery) {
            return new ScriptScoreQuery(newQ, this.queryName, this.script, this.scriptBuilder, this.minScore, this.indexName, this.shardId, this.indexVersion);
        }
        return super.rewrite(searcher);
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, final float boost) throws IOException {
        if (scoreMode == ScoreMode.COMPLETE_NO_SCORES && this.minScore == null) {
            return this.subQuery.createWeight(searcher, scoreMode, boost);
        }
        final boolean needsScore = this.scriptBuilder.needs_score();
        final ScoreMode subQueryScoreMode = needsScore ? ScoreMode.COMPLETE : ScoreMode.COMPLETE_NO_SCORES;
        final Weight subQueryWeight = this.subQuery.createWeight(searcher, subQueryScoreMode, 1.0f);
        return new Weight(this, this){
            final /* synthetic */ ScriptScoreQuery this$0;
            {
                this.this$0 = this$0;
                super(query);
            }

            @Override
            public ScorerSupplier scorerSupplier(final LeafReaderContext context) throws IOException {
                final 1 weight = this;
                return new ScorerSupplier(this){
                    private Scorer scorer;
                    private BulkScorer bulkScorer;
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public BulkScorer bulkScorer() throws IOException {
                        if (this.this$1.this$0.minScore == null) {
                            BulkScorer subQueryBulkScorer = subQueryWeight.bulkScorer(context);
                            this.bulkScorer = subQueryBulkScorer == null ? null : new ScriptScoreBulkScorer(subQueryBulkScorer, subQueryScoreMode, this.this$1.makeScoreScript(context), boost);
                        } else {
                            Scorer scorer = this.get(Long.MAX_VALUE);
                            if (scorer != null) {
                                this.bulkScorer = new Weight.DefaultBulkScorer(scorer);
                            }
                        }
                        return this.bulkScorer;
                    }

                    @Override
                    public Scorer get(long leadCost) throws IOException {
                        Scorer subQueryScorer = subQueryWeight.scorer(context);
                        if (subQueryScorer == null) {
                            this.scorer = null;
                        } else {
                            Scorer scriptScorer = new ScriptScorer(weight, this.this$1.makeScoreScript(context), subQueryScorer, subQueryScoreMode, boost, null);
                            if (this.this$1.this$0.minScore != null) {
                                scriptScorer = new MinScoreScorer(weight, scriptScorer, this.this$1.this$0.minScore.floatValue());
                            }
                            this.scorer = scriptScorer;
                        }
                        return this.scorer;
                    }

                    @Override
                    public long cost() {
                        if (this.scorer != null) {
                            return this.scorer.iterator().cost();
                        }
                        if (this.bulkScorer != null) {
                            return this.bulkScorer.cost();
                        }
                        return Integer.MAX_VALUE;
                    }
                };
            }

            @Override
            public Explanation explain(LeafReaderContext context, int doc) throws IOException {
                Explanation subQueryExplanation = Functions.explainWithName(subQueryWeight.explain(context, doc), this.this$0.queryName);
                if (!subQueryExplanation.isMatch()) {
                    return subQueryExplanation;
                }
                ScoreScript.ExplanationHolder explanationHolder = new ScoreScript.ExplanationHolder();
                ScriptScorer scorer = new ScriptScorer(this, this.makeScoreScript(context), subQueryWeight.scorer(context), subQueryScoreMode, 1.0f, explanationHolder);
                int newDoc = ((Scorer)scorer).iterator().advance(doc);
                assert (doc == newDoc);
                float score = ((Scorable)scorer).score();
                Explanation explanation = explanationHolder.get(score, needsScore ? subQueryExplanation : null);
                if (explanation == null) {
                    String desc = "script score function, computed with script:\"" + String.valueOf(this.this$0.script) + "\"";
                    if (needsScore) {
                        Explanation scoreExp = Explanation.match(subQueryExplanation.getValue(), "_score: ", subQueryExplanation);
                        explanation = Explanation.match((Number)Float.valueOf(score), desc, scoreExp);
                    } else {
                        explanation = Explanation.match((Number)Float.valueOf(score), desc, new Explanation[0]);
                    }
                }
                if (boost != 1.0f) {
                    explanation = Explanation.match((Number)Float.valueOf(boost * explanation.getValue().floatValue()), "Boosted score, product of:", Explanation.match((Number)Float.valueOf(boost), "boost", new Explanation[0]), explanation);
                }
                if (this.this$0.minScore != null && this.this$0.minScore.floatValue() > explanation.getValue().floatValue()) {
                    explanation = Explanation.noMatch("Score value is too low, expected at least " + this.this$0.minScore + " but got " + String.valueOf(explanation.getValue()), explanation);
                }
                return explanation;
            }

            private ScoreScript makeScoreScript(LeafReaderContext context) throws IOException {
                ScoreScript scoreScript = this.this$0.scriptBuilder.newInstance(context);
                scoreScript._setIndexName(this.this$0.indexName);
                scoreScript._setShard(this.this$0.shardId);
                scoreScript._setIndexVersion(this.this$0.indexVersion);
                return scoreScript;
            }

            @Override
            public boolean isCacheable(LeafReaderContext ctx) {
                return this.this$0.minScore == null;
            }
        };
    }

    @Override
    public void visit(QueryVisitor visitor) {
        this.subQuery.visit(visitor.getSubVisitor(BooleanClause.Occur.MUST, this));
    }

    @Override
    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append("script_score (").append(this.subQuery.toString(field));
        sb.append(Functions.nameOrEmptyArg(this.queryName)).append(", script: ");
        sb.append("{" + this.script.toString() + "}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScriptScoreQuery that = (ScriptScoreQuery)o;
        return this.shardId == that.shardId && this.subQuery.equals(that.subQuery) && this.script.equals(that.script) && Objects.equals(this.minScore, that.minScore) && this.indexName.equals(that.indexName) && this.indexVersion.equals(that.indexVersion) && Objects.equals(this.queryName, that.queryName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.subQuery, this.script, this.minScore, this.indexName, this.shardId, this.indexVersion, this.queryName);
    }

    private static class ScriptScoreBulkScorer
    extends BulkScorer {
        private final BulkScorer subQueryBulkScorer;
        private final ScoreMode subQueryScoreMode;
        private final ScoreScript scoreScript;
        private final float boost;

        ScriptScoreBulkScorer(BulkScorer subQueryBulkScorer, ScoreMode subQueryScoreMode, ScoreScript scoreScript, float boost) {
            this.subQueryBulkScorer = subQueryBulkScorer;
            this.subQueryScoreMode = subQueryScoreMode;
            this.scoreScript = scoreScript;
            this.boost = boost;
        }

        @Override
        public int score(LeafCollector collector, Bits acceptDocs, int min, int max) throws IOException {
            return this.subQueryBulkScorer.score(this.wrapCollector(collector), acceptDocs, min, max);
        }

        private LeafCollector wrapCollector(LeafCollector collector) {
            return new FilterLeafCollector(collector){
                private ScriptScorable scriptScorable;

                @Override
                public void setScorer(Scorable scorer) throws IOException {
                    this.scriptScorable = new ScriptScorable(scoreScript, scorer, subQueryScoreMode, boost, null);
                    this.in.setScorer(this.scriptScorable);
                }

                @Override
                public void collect(int doc) throws IOException {
                    this.scriptScorable.setDocument(doc);
                    super.collect(doc);
                }
            };
        }

        @Override
        public long cost() {
            return this.subQueryBulkScorer.cost();
        }
    }

    private static class ScriptScorable
    extends Scorable {
        private final ScoreScript scoreScript;
        private final Scorable subQueryScorer;
        private final float boost;
        private final ScoreScript.ExplanationHolder explanation;
        private int docId;

        ScriptScorable(ScoreScript scoreScript, Scorable subQueryScorer, ScoreMode subQueryScoreMode, float boost, ScoreScript.ExplanationHolder explanation) {
            this.scoreScript = scoreScript;
            if (subQueryScoreMode == ScoreMode.COMPLETE) {
                scoreScript.setScorer(subQueryScorer);
            }
            this.subQueryScorer = subQueryScorer;
            this.boost = boost;
            this.explanation = explanation;
        }

        void setDocument(int docId) {
            this.docId = docId;
        }

        @Override
        public float score() throws IOException {
            this.scoreScript.setDocument(this.docId);
            float score = (float)this.scoreScript.execute(this.explanation);
            if (score < 0.0f || Float.isNaN(score)) {
                throw new IllegalArgumentException("script_score script returned an invalid score [" + score + "] for doc [" + this.docId + "]. Must be a non-negative score!");
            }
            return score * this.boost;
        }
    }

    private static class ScriptScorer
    extends Scorer {
        private final ScoreScript scoreScript;
        private final Scorer subQueryScorer;
        private final float boost;
        private final ScoreScript.ExplanationHolder explanation;

        ScriptScorer(Weight weight, ScoreScript scoreScript, Scorer subQueryScorer, ScoreMode subQueryScoreMode, float boost, ScoreScript.ExplanationHolder explanation) {
            this.scoreScript = scoreScript;
            if (subQueryScoreMode == ScoreMode.COMPLETE) {
                scoreScript.setScorer(subQueryScorer);
            }
            this.subQueryScorer = subQueryScorer;
            this.boost = boost;
            this.explanation = explanation;
        }

        @Override
        public float score() throws IOException {
            int docId = this.docID();
            this.scoreScript.setDocument(docId);
            float score = (float)this.scoreScript.execute(this.explanation);
            if (score < 0.0f || Float.isNaN(score)) {
                throw new IllegalArgumentException("script_score script returned an invalid score [" + score + "] for doc [" + docId + "]. Must be a non-negative score!");
            }
            return score * this.boost;
        }

        @Override
        public int docID() {
            return this.subQueryScorer.docID();
        }

        @Override
        public DocIdSetIterator iterator() {
            return this.subQueryScorer.iterator();
        }

        @Override
        public TwoPhaseIterator twoPhaseIterator() {
            return this.subQueryScorer.twoPhaseIterator();
        }

        @Override
        public float getMaxScore(int upTo) {
            return Float.MAX_VALUE;
        }
    }
}

