/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.env;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import org.opensearch.Version;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.ParseField;
import org.opensearch.core.xcontent.ObjectParser;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.gateway.MetadataStateFormat;

public final class NodeMetadata {
    static final String NODE_ID_KEY = "node_id";
    static final String NODE_VERSION_KEY = "node_version";
    private final String nodeId;
    private final Version nodeVersion;
    public static final MetadataStateFormat<NodeMetadata> FORMAT = new NodeMetadataStateFormat(false);

    public NodeMetadata(String nodeId, Version nodeVersion) {
        this.nodeId = Objects.requireNonNull(nodeId);
        this.nodeVersion = Objects.requireNonNull(nodeVersion);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeMetadata that = (NodeMetadata)o;
        return this.nodeId.equals(that.nodeId) && this.nodeVersion.equals(that.nodeVersion);
    }

    public int hashCode() {
        return Objects.hash(this.nodeId, this.nodeVersion);
    }

    public String toString() {
        return "NodeMetadata{nodeId='" + this.nodeId + "', nodeVersion=" + String.valueOf(this.nodeVersion) + "}";
    }

    public String nodeId() {
        return this.nodeId;
    }

    public Version nodeVersion() {
        return this.nodeVersion;
    }

    public NodeMetadata upgradeToCurrentVersion() {
        if (this.nodeVersion.equals(Version.V_EMPTY)) {
            assert (Version.CURRENT.major <= Version.V_3_0_0.major + 1) : "version is required in the node metadata from v4 onwards";
            return new NodeMetadata(this.nodeId, Version.CURRENT);
        }
        if (this.nodeVersion.before(Version.CURRENT.minimumIndexCompatibilityVersion())) {
            throw new IllegalStateException("cannot upgrade a node from version [" + String.valueOf(this.nodeVersion) + "] directly to version [" + String.valueOf(Version.CURRENT) + "]");
        }
        if (this.nodeVersion.after(Version.CURRENT)) {
            throw new IllegalStateException("cannot downgrade a node from version [" + String.valueOf(this.nodeVersion) + "] to version [" + String.valueOf(Version.CURRENT) + "]");
        }
        return this.nodeVersion.equals(Version.CURRENT) ? this : new NodeMetadata(this.nodeId, Version.CURRENT);
    }

    static class NodeMetadataStateFormat
    extends MetadataStateFormat<NodeMetadata> {
        private ObjectParser<Builder, Void> objectParser;

        NodeMetadataStateFormat(boolean ignoreUnknownFields) {
            super("node-");
            this.objectParser = new ObjectParser("node_meta_data", ignoreUnknownFields, Builder::new);
            this.objectParser.declareString(Builder::setNodeId, new ParseField(NodeMetadata.NODE_ID_KEY, new String[0]));
            this.objectParser.declareInt(Builder::setNodeVersionId, new ParseField(NodeMetadata.NODE_VERSION_KEY, new String[0]));
        }

        @Override
        protected XContentBuilder newXContentBuilder(XContentType type, OutputStream stream) throws IOException {
            XContentBuilder xContentBuilder = super.newXContentBuilder(type, stream);
            xContentBuilder.prettyPrint();
            return xContentBuilder;
        }

        @Override
        public void toXContent(XContentBuilder builder, NodeMetadata nodeMetadata) throws IOException {
            builder.field(NodeMetadata.NODE_ID_KEY, nodeMetadata.nodeId);
            builder.field(NodeMetadata.NODE_VERSION_KEY, nodeMetadata.nodeVersion.id);
        }

        @Override
        public NodeMetadata fromXContent(XContentParser parser) throws IOException {
            return this.objectParser.apply(parser, null).build();
        }
    }

    private static class Builder {
        String nodeId;
        Version nodeVersion;

        private Builder() {
        }

        public void setNodeId(String nodeId) {
            this.nodeId = nodeId;
        }

        public void setNodeVersionId(int nodeVersionId) {
            this.nodeVersion = Version.fromId(nodeVersionId);
        }

        public NodeMetadata build() {
            Version nodeVersion;
            if (this.nodeVersion == null) {
                assert (Version.CURRENT.major <= Version.V_3_0_0.major + 1) : "version is required in the node metadata from v4 onwards";
                nodeVersion = Version.V_EMPTY;
            } else {
                nodeVersion = this.nodeVersion;
            }
            return new NodeMetadata(this.nodeId, nodeVersion);
        }
    }
}

