/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.extensions;

import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.SettingsException;
import org.opensearch.common.settings.SettingsModule;
import org.opensearch.common.settings.WriteableSetting;
import org.opensearch.core.transport.TransportResponse;
import org.opensearch.extensions.AcknowledgedResponse;
import org.opensearch.extensions.AddSettingsUpdateConsumerRequest;
import org.opensearch.extensions.DiscoveryExtensionNode;
import org.opensearch.extensions.UpdateSettingsRequest;
import org.opensearch.extensions.UpdateSettingsResponseHandler;
import org.opensearch.transport.TransportService;

public class AddSettingsUpdateConsumerRequestHandler {
    private static final Logger logger = LogManager.getLogger(AddSettingsUpdateConsumerRequestHandler.class);
    private final ClusterService clusterService;
    private final TransportService transportService;
    private final String updateSettingsRequestType;
    private final SettingsModule settingsModule;

    public AddSettingsUpdateConsumerRequestHandler(ClusterService clusterService, TransportService transportService, String updateSettingsRequestType, SettingsModule settingsModule) {
        this.clusterService = clusterService;
        this.transportService = transportService;
        this.updateSettingsRequestType = updateSettingsRequestType;
        this.settingsModule = settingsModule;
    }

    TransportResponse handleAddSettingsUpdateConsumerRequest(AddSettingsUpdateConsumerRequest addSettingsUpdateConsumerRequest) throws Exception {
        boolean status = true;
        List<WriteableSetting> extensionComponentSettings = addSettingsUpdateConsumerRequest.getComponentSettings();
        DiscoveryExtensionNode extensionNode = addSettingsUpdateConsumerRequest.getExtensionNode();
        try {
            for (WriteableSetting extensionComponentSetting : extensionComponentSettings) {
                Setting<?> setting = extensionComponentSetting.getSetting();
                Setting<?> settingForUpdateConsumer = null;
                if (setting.hasIndexScope()) {
                    settingForUpdateConsumer = this.settingsModule.getIndexScopedSettings().get(setting.getKey());
                } else if (setting.hasNodeScope()) {
                    settingForUpdateConsumer = this.settingsModule.getClusterSettings().get(setting.getKey());
                }
                if (settingForUpdateConsumer == null) {
                    throw new IllegalArgumentException("Not index or node scope");
                }
                WriteableSetting.SettingType settingType = extensionComponentSetting.getType();
                if (setting.hasIndexScope()) {
                    this.clusterService.getClusterSettings().addSettingsUpdateConsumer(settingForUpdateConsumer, data -> {
                        logger.debug("Sending extension request type: " + this.updateSettingsRequestType);
                        UpdateSettingsResponseHandler updateSettingsResponseHandler = new UpdateSettingsResponseHandler();
                        this.transportService.sendRequest(extensionNode, this.updateSettingsRequestType, new UpdateSettingsRequest(settingType, setting, data), updateSettingsResponseHandler);
                    });
                }
                if (!setting.hasNodeScope()) continue;
                this.clusterService.getClusterSettings().addSettingsUpdateConsumer(settingForUpdateConsumer, data -> {
                    logger.debug("Sending extension request type: " + this.updateSettingsRequestType);
                    UpdateSettingsResponseHandler updateSettingsResponseHandler = new UpdateSettingsResponseHandler();
                    this.transportService.sendRequest(extensionNode, this.updateSettingsRequestType, new UpdateSettingsRequest(settingType, setting, data), updateSettingsResponseHandler);
                });
            }
        }
        catch (IllegalArgumentException | SettingsException e) {
            logger.error(e.toString());
            status = false;
        }
        return new AcknowledgedResponse(status);
    }
}

