/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.codec.composite;

import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.lucene101.Lucene101Codec;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.index.codec.composite.composite101.Composite101Codec;
import org.opensearch.index.mapper.MapperService;

@ExperimentalApi
public class CompositeCodecFactory {
    public static final String COMPOSITE_CODEC = "Composite101Codec";

    public Map<String, Codec> getCompositeIndexCodecs(MapperService mapperService, Logger logger) {
        HashMap<String, Codec> codecs = new HashMap<String, Codec>();
        codecs.put("default", new Composite101Codec(Lucene101Codec.Mode.BEST_SPEED, mapperService, logger));
        codecs.put("lz4", new Composite101Codec(Lucene101Codec.Mode.BEST_SPEED, mapperService, logger));
        codecs.put("best_compression", new Composite101Codec(Lucene101Codec.Mode.BEST_COMPRESSION, mapperService, logger));
        codecs.put("zlib", new Composite101Codec(Lucene101Codec.Mode.BEST_COMPRESSION, mapperService, logger));
        return codecs;
    }
}

