/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.compositeindex.datacube.startree.builder;

import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.lucene.index.OrdinalMap;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.LongValues;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.common.util.io.IOUtils;
import org.opensearch.index.compositeindex.datacube.startree.StarTreeDocument;
import org.opensearch.index.compositeindex.datacube.startree.StarTreeField;
import org.opensearch.index.compositeindex.datacube.startree.builder.BaseStarTreeBuilder;
import org.opensearch.index.compositeindex.datacube.startree.builder.SegmentDocsFileManager;
import org.opensearch.index.compositeindex.datacube.startree.builder.StarTreeDocsFileManager;
import org.opensearch.index.compositeindex.datacube.startree.index.StarTreeValues;
import org.opensearch.index.compositeindex.datacube.startree.utils.SequentialDocValuesIterator;
import org.opensearch.index.compositeindex.datacube.startree.utils.StarTreeDocumentsSorter;
import org.opensearch.index.mapper.MapperService;

@ExperimentalApi
public class OffHeapStarTreeBuilder
extends BaseStarTreeBuilder {
    private static final Logger logger = LogManager.getLogger(OffHeapStarTreeBuilder.class);
    private final StarTreeDocsFileManager starTreeDocumentFileManager;
    private final SegmentDocsFileManager segmentDocumentFileManager;

    protected OffHeapStarTreeBuilder(IndexOutput metaOut, IndexOutput dataOut, StarTreeField starTreeField, SegmentWriteState state, MapperService mapperService) throws IOException {
        super(metaOut, dataOut, starTreeField, state, mapperService);
        this.segmentDocumentFileManager = new SegmentDocsFileManager(state, starTreeField, this.metricAggregatorInfos, this.numDimensions);
        try {
            this.starTreeDocumentFileManager = new StarTreeDocsFileManager(state, starTreeField, this.metricAggregatorInfos, this.numDimensions);
        }
        catch (IOException e) {
            IOUtils.closeWhileHandlingException((Closeable)this.segmentDocumentFileManager);
            throw e;
        }
    }

    @Override
    public void appendStarTreeDocument(StarTreeDocument starTreeDocument) throws IOException {
        this.starTreeDocumentFileManager.writeStarTreeDocument(starTreeDocument, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void build(List<StarTreeValues> starTreeValuesSubs, AtomicInteger fieldNumberAcrossStarTrees, DocValuesConsumer starTreeDocValuesConsumer) throws IOException {
        boolean success = false;
        try {
            this.build(this.mergeStarTrees(starTreeValuesSubs), fieldNumberAcrossStarTrees, starTreeDocValuesConsumer);
            success = true;
        }
        finally {
            this.starTreeDocumentFileManager.deleteFiles(success);
            this.segmentDocumentFileManager.deleteFiles(success);
        }
    }

    @Override
    public Iterator<StarTreeDocument> sortAndAggregateSegmentDocuments(SequentialDocValuesIterator[] dimensionReaders, List<SequentialDocValuesIterator> metricReaders) throws IOException {
        int i;
        int[] sortedDocIds = new int[this.totalSegmentDocs];
        for (i = 0; i < this.totalSegmentDocs; ++i) {
            sortedDocIds[i] = i;
        }
        try {
            for (i = 0; i < this.totalSegmentDocs; ++i) {
                StarTreeDocument document = this.getSegmentStarTreeDocumentWithMetricFieldValues(i, dimensionReaders, metricReaders);
                this.segmentDocumentFileManager.writeStarTreeDocument(document, false);
            }
        }
        catch (IOException ex) {
            this.segmentDocumentFileManager.close();
            throw ex;
        }
        return this.sortAndReduceDocuments(sortedDocIds, this.totalSegmentDocs, false);
    }

    StarTreeDocument getSegmentStarTreeDocumentWithMetricFieldValues(int currentDocId, SequentialDocValuesIterator[] dimensionReaders, List<SequentialDocValuesIterator> metricReaders) throws IOException {
        Long[] dimensions = this.getStarTreeDimensionsFromSegment(currentDocId, dimensionReaders);
        Object[] metricValues = this.getStarTreeMetricFieldValuesFromSegment(currentDocId, metricReaders);
        return new StarTreeDocument(dimensions, metricValues);
    }

    private Object[] getStarTreeMetricFieldValuesFromSegment(int currentDocId, List<SequentialDocValuesIterator> metricReaders) {
        Object[] metricValues = new Object[this.starTreeField.getMetrics().size()];
        for (int i = 0; i < this.starTreeField.getMetrics().size(); ++i) {
            if (this.starTreeField.getMetrics().get(i).getBaseMetrics().isEmpty()) continue;
            SequentialDocValuesIterator metricReader = metricReaders.get(i);
            if (metricReader != null) {
                try {
                    metricReader.nextEntry(currentDocId);
                    metricValues[i] = metricReader.value(currentDocId);
                    continue;
                }
                catch (IOException e) {
                    logger.error("unable to iterate to next doc", (Throwable)e);
                    throw new RuntimeException("unable to iterate to next doc", e);
                }
                catch (Exception e) {
                    logger.error("unable to read the metric values from the segment", (Throwable)e);
                    throw new IllegalStateException("unable to read the metric values from the segment", e);
                }
            }
            throw new IllegalStateException("metric reader is empty");
        }
        return metricValues;
    }

    @Override
    Iterator<StarTreeDocument> mergeStarTrees(List<StarTreeValues> starTreeValuesSubs) throws IOException {
        int[] docIds;
        int numDocs = 0;
        this.isMerge = true;
        Map<String, OrdinalMap> ordinalMaps = this.getOrdinalMaps(starTreeValuesSubs);
        try {
            int seg = 0;
            for (StarTreeValues starTreeValues : starTreeValuesSubs) {
                SequentialDocValuesIterator[] dimensionReaders = new SequentialDocValuesIterator[this.numDimensions];
                ArrayList<SequentialDocValuesIterator> metricReaders = new ArrayList<SequentialDocValuesIterator>();
                AtomicInteger numSegmentDocs = new AtomicInteger();
                this.setReadersAndNumSegmentDocsDuringMerge(dimensionReaders, metricReaders, numSegmentDocs, starTreeValues);
                int currentDocId = 0;
                LinkedHashMap<String, LongValues> longValuesMap = new LinkedHashMap<String, LongValues>();
                for (Map.Entry<String, OrdinalMap> entry : ordinalMaps.entrySet()) {
                    longValuesMap.put(entry.getKey(), entry.getValue().getGlobalOrds(seg));
                }
                while (currentDocId < numSegmentDocs.get()) {
                    StarTreeDocument starTreeDocument = this.getStarTreeDocument(currentDocId, dimensionReaders, metricReaders, longValuesMap);
                    this.segmentDocumentFileManager.writeStarTreeDocument(starTreeDocument, true);
                    ++numDocs;
                    ++currentDocId;
                }
                ++seg;
            }
            docIds = new int[numDocs];
            for (int i = 0; i < numDocs; ++i) {
                docIds[i] = i;
            }
        }
        catch (IOException ex) {
            this.segmentDocumentFileManager.close();
            throw ex;
        }
        if (numDocs == 0) {
            return Collections.emptyIterator();
        }
        return this.sortAndReduceDocuments(docIds, numDocs, true);
    }

    private Iterator<StarTreeDocument> sortAndReduceDocuments(final int[] sortedDocIds, final int numDocs, final boolean isMerge) throws IOException {
        try {
            if (sortedDocIds == null || sortedDocIds.length == 0) {
                logger.debug("Sorted doc ids array is null");
                return Collections.emptyIterator();
            }
            try {
                StarTreeDocumentsSorter.sort(sortedDocIds, -1, numDocs, index -> {
                    try {
                        return this.segmentDocumentFileManager.readDimensions(sortedDocIds[index]);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }, this.dimensionComparators);
            }
            catch (UncheckedIOException ex) {
                if (ex.getCause() != null) {
                    throw ex.getCause();
                }
                throw ex;
            }
            final StarTreeDocument currentDocument = this.segmentDocumentFileManager.readStarTreeDocument(sortedDocIds[0], isMerge);
            return new Iterator<StarTreeDocument>(){
                StarTreeDocument tempCurrentDocument;
                boolean hasNext;
                int docId;
                final /* synthetic */ OffHeapStarTreeBuilder this$0;
                {
                    this.this$0 = this$0;
                    this.tempCurrentDocument = currentDocument;
                    this.hasNext = true;
                    this.docId = 1;
                }

                @Override
                public boolean hasNext() {
                    return this.hasNext;
                }

                @Override
                public StarTreeDocument next() {
                    StarTreeDocument next = this.this$0.reduceSegmentStarTreeDocuments(null, this.tempCurrentDocument, isMerge);
                    while (this.docId < numDocs) {
                        StarTreeDocument doc;
                        try {
                            doc = this.this$0.segmentDocumentFileManager.readStarTreeDocument(sortedDocIds[this.docId++], isMerge);
                        }
                        catch (IOException e) {
                            throw new RuntimeException("Reducing documents failed ", e);
                        }
                        if (!Arrays.equals((Object[])doc.dimensions, (Object[])next.dimensions)) {
                            this.tempCurrentDocument = doc;
                            return next;
                        }
                        next = this.this$0.reduceSegmentStarTreeDocuments(next, doc, isMerge);
                    }
                    this.hasNext = false;
                    try {
                        this.this$0.segmentDocumentFileManager.close();
                    }
                    catch (IOException ex) {
                        logger.error("Closing segment documents file failed", (Throwable)ex);
                    }
                    return next;
                }
            };
        }
        catch (IOException ex) {
            IOUtils.closeWhileHandlingException((Closeable)this.segmentDocumentFileManager);
            throw ex;
        }
    }

    @Override
    public StarTreeDocument getStarTreeDocument(int docId) throws IOException {
        return this.starTreeDocumentFileManager.readStarTreeDocument(docId, true);
    }

    @Override
    public List<StarTreeDocument> getStarTreeDocuments() throws IOException {
        ArrayList<StarTreeDocument> starTreeDocuments = new ArrayList<StarTreeDocument>();
        for (int i = 0; i < this.numStarTreeDocs; ++i) {
            starTreeDocuments.add(this.getStarTreeDocument(i));
        }
        return starTreeDocuments;
    }

    @Override
    public Long getDimensionValue(int docId, int dimensionId) throws IOException {
        return this.starTreeDocumentFileManager.getDimensionValue(docId, dimensionId);
    }

    @Override
    public Iterator<StarTreeDocument> generateStarTreeDocumentsForStarNode(int startDocId, int endDocId, final int dimensionId) throws IOException {
        final int numDocs = endDocId - startDocId;
        final int[] sortedDocIds = new int[numDocs];
        for (int i = 0; i < numDocs; ++i) {
            sortedDocIds[i] = startDocId + i;
        }
        StarTreeDocumentsSorter.sort(sortedDocIds, dimensionId, numDocs, index -> {
            try {
                return this.starTreeDocumentFileManager.readDimensions(sortedDocIds[index]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }, this.dimensionComparators);
        return new Iterator<StarTreeDocument>(){
            boolean hasNext = true;
            StarTreeDocument currentDocument = this.this$0.getStarTreeDocument(sortedDocIds[0]);
            int docId = 1;
            final /* synthetic */ OffHeapStarTreeBuilder this$0;
            {
                this.this$0 = this$0;
            }

            private boolean hasSameDimensions(StarTreeDocument document1, StarTreeDocument document2) {
                for (int i = dimensionId + 1; i < this.this$0.numDimensions; ++i) {
                    if (Objects.equals(document1.dimensions[i], document2.dimensions[i])) continue;
                    return false;
                }
                return true;
            }

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public StarTreeDocument next() {
                StarTreeDocument next = this.this$0.reduceStarTreeDocuments(null, this.currentDocument);
                next.dimensions[dimensionId] = BaseStarTreeBuilder.STAR_IN_DOC_VALUES_INDEX;
                while (this.docId < numDocs) {
                    StarTreeDocument document;
                    try {
                        document = this.this$0.getStarTreeDocument(sortedDocIds[this.docId++]);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    if (!this.hasSameDimensions(document, this.currentDocument)) {
                        this.currentDocument = document;
                        return next;
                    }
                    next = this.this$0.reduceStarTreeDocuments(next, document);
                }
                this.hasNext = false;
                return next;
            }
        };
    }

    @Override
    public void close() throws IOException {
        IOUtils.closeWhileHandlingException(this.starTreeDocumentFileManager, this.segmentDocumentFileManager);
        super.close();
    }
}

