/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.engine;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.CodecReader;
import org.apache.lucene.index.FilterMergePolicy;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SegmentReader;
import org.opensearch.common.lucene.Lucene;

public class ShuffleForcedMergePolicy
extends FilterMergePolicy {
    private static final String SHUFFLE_MERGE_KEY = "opensearch.shuffle_merge";

    public ShuffleForcedMergePolicy(MergePolicy in) {
        super(in);
    }

    public static boolean isInterleavedSegment(LeafReader reader) {
        SegmentReader segReader = Lucene.segmentReader(reader);
        return segReader.getSegmentInfo().info.getDiagnostics().containsKey(SHUFFLE_MERGE_KEY);
    }

    @Override
    public MergePolicy.MergeSpecification findForcedDeletesMerges(SegmentInfos segmentInfos, MergePolicy.MergeContext mergeContext) throws IOException {
        return this.wrap(this.in.findForcedDeletesMerges(segmentInfos, mergeContext));
    }

    @Override
    public MergePolicy.MergeSpecification findForcedMerges(SegmentInfos segmentInfos, int maxSegmentCount, Map<SegmentCommitInfo, Boolean> segmentsToMerge, MergePolicy.MergeContext mergeContext) throws IOException {
        return this.wrap(this.in.findForcedMerges(segmentInfos, maxSegmentCount, segmentsToMerge, mergeContext));
    }

    private MergePolicy.MergeSpecification wrap(MergePolicy.MergeSpecification mergeSpec) throws IOException {
        if (mergeSpec == null) {
            return null;
        }
        MergePolicy.MergeSpecification newMergeSpec = new MergePolicy.MergeSpecification();
        for (final MergePolicy.OneMerge toWrap : mergeSpec.merges) {
            List<SegmentCommitInfo> newInfos = this.interleaveList(new ArrayList<SegmentCommitInfo>(toWrap.segments));
            newMergeSpec.add(new MergePolicy.OneMerge(this, newInfos){

                @Override
                public CodecReader wrapForMerge(CodecReader reader) throws IOException {
                    return toWrap.wrapForMerge(reader);
                }

                @Override
                public void setMergeInfo(SegmentCommitInfo info) {
                    info.info.addDiagnostics(Map.of(ShuffleForcedMergePolicy.SHUFFLE_MERGE_KEY, ""));
                    super.setMergeInfo(info);
                }
            });
        }
        return newMergeSpec;
    }

    private List<SegmentCommitInfo> interleaveList(List<SegmentCommitInfo> infos) throws IOException {
        ArrayList<SegmentCommitInfo> newInfos = new ArrayList<SegmentCommitInfo>(infos.size());
        Collections.sort(infos, Comparator.comparing(a -> a.info.name));
        int left = 0;
        for (int right = infos.size() - 1; left <= right; ++left, --right) {
            SegmentCommitInfo leftInfo = infos.get(left);
            if (left == right) {
                newInfos.add(infos.get(left));
                continue;
            }
            SegmentCommitInfo rightInfo = infos.get(right);
            if (leftInfo.sizeInBytes() < rightInfo.sizeInBytes()) {
                newInfos.add(leftInfo);
                newInfos.add(rightInfo);
                continue;
            }
            newInfos.add(rightInfo);
            newInfos.add(leftInfo);
        }
        return newInfos;
    }
}

