/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.fielddata.fieldcomparator;

import java.io.IOException;
import java.util.function.Function;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.LeafFieldComparator;
import org.apache.lucene.search.Pruning;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.comparators.LongComparator;
import org.apache.lucene.util.BitSet;
import org.opensearch.common.Nullable;
import org.opensearch.common.util.BigArrays;
import org.opensearch.index.fielddata.FieldData;
import org.opensearch.index.fielddata.IndexFieldData;
import org.opensearch.index.fielddata.IndexNumericFieldData;
import org.opensearch.index.fielddata.LeafNumericFieldData;
import org.opensearch.index.fielddata.plain.SortedNumericIndexFieldData;
import org.opensearch.search.DocValueFormat;
import org.opensearch.search.MultiValueMode;
import org.opensearch.search.sort.BucketedSort;
import org.opensearch.search.sort.SortOrder;

public class LongValuesComparatorSource
extends IndexFieldData.XFieldComparatorSource {
    private final IndexNumericFieldData indexFieldData;
    private final Function<SortedNumericDocValues, SortedNumericDocValues> converter;

    public LongValuesComparatorSource(IndexNumericFieldData indexFieldData, @Nullable Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested) {
        this(indexFieldData, missingValue, sortMode, nested, null);
    }

    public LongValuesComparatorSource(IndexNumericFieldData indexFieldData, @Nullable Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, Function<SortedNumericDocValues, SortedNumericDocValues> converter) {
        super(missingValue, sortMode, nested);
        this.indexFieldData = indexFieldData;
        this.converter = converter;
    }

    @Override
    public SortField.Type reducedType() {
        return SortField.Type.LONG;
    }

    private SortedNumericDocValues loadDocValues(LeafReaderContext context) {
        LeafNumericFieldData data = (LeafNumericFieldData)this.indexFieldData.load(context);
        SortedNumericDocValues values = data instanceof SortedNumericIndexFieldData.NanoSecondFieldData ? ((SortedNumericIndexFieldData.NanoSecondFieldData)data).getLongValuesAsNanos() : data.getLongValues();
        return this.converter != null ? this.converter.apply(values) : values;
    }

    private NumericDocValues getNumericDocValues(LeafReaderContext context, long missingValue) throws IOException {
        SortedNumericDocValues values = this.loadDocValues(context);
        if (this.nested == null) {
            return FieldData.replaceMissing(this.sortMode.select(values), missingValue);
        }
        BitSet rootDocs = this.nested.rootDocs(context);
        DocIdSetIterator innerDocs = this.nested.innerDocs(context);
        int maxChildren = this.nested.getNestedSort() != null ? this.nested.getNestedSort().getMaxChildren() : Integer.MAX_VALUE;
        return this.sortMode.select(values, missingValue, rootDocs, innerDocs, context.reader().maxDoc(), maxChildren);
    }

    @Override
    public FieldComparator<?> newComparator(String fieldname, int numHits, Pruning pruning, boolean reversed) {
        assert (this.indexFieldData == null || fieldname.equals(this.indexFieldData.getFieldName()));
        final long lMissingValue = (Long)this.missingObject(this.missingValue, reversed);
        return new LongComparator(this, numHits, fieldname, lMissingValue, reversed, this.filterPruning(pruning)){
            final /* synthetic */ LongValuesComparatorSource this$0;
            {
                this.this$0 = this$0;
                super(numHits, field, missingValue, reverse, pruning);
            }

            @Override
            public LeafFieldComparator getLeafComparator(LeafReaderContext context) throws IOException {
                return new LongComparator.LongLeafComparator(this, context){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                        super(context);
                    }

                    @Override
                    protected NumericDocValues getNumericDocValues(LeafReaderContext context, String field) throws IOException {
                        return this.this$1.this$0.getNumericDocValues(context, lMissingValue);
                    }
                };
            }
        };
    }

    @Override
    public BucketedSort newBucketedSort(BigArrays bigArrays, final SortOrder sortOrder, DocValueFormat format, int bucketSize, BucketedSort.ExtraData extra) {
        return new BucketedSort.ForLongs(this, bigArrays, sortOrder, format, bucketSize, extra){
            private final long lMissingValue;
            final /* synthetic */ LongValuesComparatorSource this$0;
            {
                this.this$0 = this$0;
                super(bigArrays, sortOrder3, format, bucketSize, extra);
                this.lMissingValue = (Long)this.this$0.missingObject(this.this$0.missingValue, sortOrder == SortOrder.DESC);
            }

            @Override
            public BucketedSort.ForLongs.Leaf forLeaf(final LeafReaderContext ctx) throws IOException {
                return new BucketedSort.ForLongs.Leaf(this, ctx){
                    private final NumericDocValues docValues;
                    private long docValue;
                    final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = this$1;
                        super(this$1, ctx2);
                        this.docValues = this.this$1.this$0.getNumericDocValues(ctx, this.this$1.lMissingValue);
                    }

                    @Override
                    protected boolean advanceExact(int doc) throws IOException {
                        if (this.docValues.advanceExact(doc)) {
                            this.docValue = this.docValues.longValue();
                            return true;
                        }
                        return false;
                    }

                    @Override
                    protected long docValue() {
                        return this.docValue;
                    }
                };
            }
        };
    }
}

