/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.mapper;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.search.FieldExistsQuery;
import org.apache.lucene.search.Query;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.mapper.Mapper;
import org.opensearch.index.mapper.MetadataFieldMapper;
import org.opensearch.index.mapper.NumberFieldMapper;
import org.opensearch.index.mapper.ParametrizedFieldMapper;
import org.opensearch.index.mapper.ParseContext;
import org.opensearch.index.mapper.SourceValueFetcher;
import org.opensearch.index.mapper.TextSearchInfo;
import org.opensearch.index.mapper.ValueFetcher;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.index.query.QueryShardException;
import org.opensearch.search.lookup.SearchLookup;

public class DocCountFieldMapper
extends MetadataFieldMapper {
    public static final String NAME = "_doc_count";
    public static final String CONTENT_TYPE = "_doc_count";
    public static final MetadataFieldMapper.TypeParser PARSER = new MetadataFieldMapper.ConfigurableTypeParser(c -> new DocCountFieldMapper(), c -> new Builder());

    private DocCountFieldMapper() {
        super(DocCountFieldType.INSTANCE);
    }

    @Override
    protected void parseCreateField(ParseContext context) throws IOException {
        XContentParser parser = context.parser();
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.VALUE_NUMBER, parser.currentToken(), parser);
        long value = parser.longValue(false);
        if (value <= 0L) {
            throw new IllegalArgumentException("Field [" + this.fieldType().name() + "] must be a positive integer.");
        }
        NumericDocValuesField docCount = new NumericDocValuesField("_doc_count", value);
        context.doc().add(docCount);
    }

    @Override
    public void preParse(ParseContext context) {
    }

    @Override
    public DocCountFieldType fieldType() {
        return (DocCountFieldType)super.fieldType();
    }

    @Override
    protected String contentType() {
        return "_doc_count";
    }

    public static final class DocCountFieldType
    extends MappedFieldType {
        public static final DocCountFieldType INSTANCE = new DocCountFieldType();
        private static final Long defaultValue = 1L;

        public DocCountFieldType() {
            super("_doc_count", false, false, true, TextSearchInfo.NONE, Collections.emptyMap());
        }

        @Override
        public String typeName() {
            return "_doc_count";
        }

        @Override
        public String familyTypeName() {
            return NumberFieldMapper.NumberType.LONG.typeName();
        }

        @Override
        public Query existsQuery(QueryShardContext context) {
            return new FieldExistsQuery("_doc_count");
        }

        @Override
        public Query termQuery(Object value, QueryShardContext context) {
            throw new QueryShardException(context, "Field [" + this.name() + "] of type [" + this.typeName() + "] is not searchable", new Object[0]);
        }

        @Override
        public ValueFetcher valueFetcher(QueryShardContext context, SearchLookup searchLookup, String format) {
            if (format != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support formats.");
            }
            return new SourceValueFetcher(this, this.name(), context, defaultValue){

                @Override
                protected Object parseSourceValue(Object value) {
                    if ("".equals(value)) {
                        return defaultValue;
                    }
                    return NumberFieldMapper.NumberType.objectToLong(value, false);
                }
            };
        }
    }

    static class Builder
    extends MetadataFieldMapper.Builder {
        Builder() {
            super("_doc_count");
        }

        @Override
        protected List<ParametrizedFieldMapper.Parameter<?>> getParameters() {
            return Collections.emptyList();
        }

        @Override
        public DocCountFieldMapper build(Mapper.BuilderContext context) {
            return new DocCountFieldMapper();
        }

        @Override
        public boolean isDataCubeMetricSupported() {
            return true;
        }
    }
}

