/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.mapper;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermInSetQuery;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.BytesRef;
import org.opensearch.common.lucene.BytesRefs;
import org.opensearch.common.lucene.search.AutomatonQueries;
import org.opensearch.index.mapper.BytesRefsCollectionBuilder;
import org.opensearch.index.mapper.SimpleMappedFieldType;
import org.opensearch.index.mapper.TextSearchInfo;
import org.opensearch.index.query.QueryShardContext;

public abstract class TermBasedFieldType
extends SimpleMappedFieldType {
    public TermBasedFieldType(String name, boolean isSearchable, boolean isStored, boolean hasDocValues, TextSearchInfo textSearchInfo, Map<String, String> meta) {
        super(name, isSearchable, isStored, hasDocValues, textSearchInfo, meta);
    }

    protected BytesRef indexedValueForSearch(Object value) {
        return BytesRefs.toBytesRef(value);
    }

    @Override
    public Query termQueryCaseInsensitive(Object value, QueryShardContext context) {
        this.failIfNotIndexed();
        Query query = AutomatonQueries.caseInsensitiveTermQuery(new Term(this.name(), this.indexedValueForSearch(value)));
        if (this.boost() != 1.0f) {
            query = new BoostQuery(query, this.boost());
        }
        return query;
    }

    @Override
    public Query termQuery(Object value, QueryShardContext context) {
        this.failIfNotIndexed();
        Query query = new TermQuery(new Term(this.name(), this.indexedValueForSearch(value)));
        if (this.boost() != 1.0f) {
            query = new BoostQuery(query, this.boost());
        }
        return query;
    }

    @Override
    public Query termsQuery(List<?> values, QueryShardContext context) {
        this.failIfNotIndexed();
        BytesRefsCollectionBuilder bytesCollector = new BytesRefsCollectionBuilder(values.size());
        for (int i = 0; i < values.size(); ++i) {
            BytesRef elem = this.indexedValueForSearch(values.get(i));
            bytesCollector.accept(elem);
        }
        return new TermInSetQuery(MultiTermQuery.CONSTANT_SCORE_BLENDED_REWRITE, this.name(), (Collection<BytesRef>)bytesCollector.get());
    }
}

