/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.query;

import java.io.IOException;
import java.time.DateTimeException;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.opensearch.common.geo.ShapeRelation;
import org.opensearch.common.time.DateFormatter;
import org.opensearch.common.time.DateMathParser;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.ParsingException;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.mapper.FieldNamesFieldMapper;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.query.AbstractQueryBuilder;
import org.opensearch.index.query.ComplementAwareQueryBuilder;
import org.opensearch.index.query.ExistsQueryBuilder;
import org.opensearch.index.query.MatchNoneQueryBuilder;
import org.opensearch.index.query.MultiTermQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryRewriteContext;
import org.opensearch.index.query.QueryShardContext;

public class RangeQueryBuilder
extends AbstractQueryBuilder<RangeQueryBuilder>
implements MultiTermQueryBuilder,
ComplementAwareQueryBuilder {
    public static final String NAME = "range";
    public static final boolean DEFAULT_INCLUDE_UPPER = true;
    public static final boolean DEFAULT_INCLUDE_LOWER = true;
    public static final ParseField LTE_FIELD = new ParseField("lte", new String[0]);
    public static final ParseField GTE_FIELD = new ParseField("gte", new String[0]);
    public static final ParseField FROM_FIELD = new ParseField("from", new String[0]);
    public static final ParseField TO_FIELD = new ParseField("to", new String[0]);
    private static final ParseField INCLUDE_LOWER_FIELD = new ParseField("include_lower", new String[0]);
    private static final ParseField INCLUDE_UPPER_FIELD = new ParseField("include_upper", new String[0]);
    public static final ParseField GT_FIELD = new ParseField("gt", new String[0]);
    public static final ParseField LT_FIELD = new ParseField("lt", new String[0]);
    private static final ParseField TIME_ZONE_FIELD = new ParseField("time_zone", new String[0]);
    private static final ParseField FORMAT_FIELD = new ParseField("format", new String[0]);
    private static final ParseField RELATION_FIELD = new ParseField("relation", new String[0]);
    private final String fieldName;
    private Object from;
    private Object to;
    private ZoneId timeZone;
    private boolean includeLower = true;
    private boolean includeUpper = true;
    private String format;
    private ShapeRelation relation;

    public RangeQueryBuilder(String fieldName) {
        if (Strings.isEmpty(fieldName)) {
            throw new IllegalArgumentException("field name is null or empty");
        }
        this.fieldName = fieldName;
    }

    public RangeQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.fieldName = in.readString();
        this.from = in.readGenericValue();
        this.to = in.readGenericValue();
        this.includeLower = in.readBoolean();
        this.includeUpper = in.readBoolean();
        this.timeZone = in.readOptionalZoneId();
        this.format = in.readOptionalString();
        String relationString = in.readOptionalString();
        if (relationString != null) {
            this.relation = ShapeRelation.getRelationByName(relationString);
            if (this.relation != null && !this.isRelationAllowed(this.relation)) {
                throw new IllegalArgumentException("[range] query does not support relation [" + relationString + "]");
            }
        }
    }

    private boolean isRelationAllowed(ShapeRelation relation) {
        return relation == ShapeRelation.INTERSECTS || relation == ShapeRelation.CONTAINS || relation == ShapeRelation.WITHIN;
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeString(this.fieldName);
        out.writeGenericValue(this.from);
        out.writeGenericValue(this.to);
        out.writeBoolean(this.includeLower);
        out.writeBoolean(this.includeUpper);
        out.writeOptionalZoneId(this.timeZone);
        out.writeOptionalString(this.format);
        String relationString = null;
        if (this.relation != null) {
            relationString = this.relation.getRelationName();
        }
        out.writeOptionalString(relationString);
    }

    @Override
    public String fieldName() {
        return this.fieldName;
    }

    public RangeQueryBuilder from(Object from, boolean includeLower) {
        this.from = RangeQueryBuilder.maybeConvertToBytesRef(from);
        this.includeLower = includeLower;
        return this;
    }

    public RangeQueryBuilder from(Object from) {
        return this.from(from, this.includeLower);
    }

    public Object from() {
        return RangeQueryBuilder.maybeConvertToString(this.from);
    }

    public RangeQueryBuilder gt(Object from) {
        return this.from(from, false);
    }

    public RangeQueryBuilder gte(Object from) {
        return this.from(from, true);
    }

    public RangeQueryBuilder to(Object to, boolean includeUpper) {
        this.to = RangeQueryBuilder.maybeConvertToBytesRef(to);
        this.includeUpper = includeUpper;
        return this;
    }

    public RangeQueryBuilder to(Object to) {
        return this.to(to, this.includeUpper);
    }

    public Object to() {
        return RangeQueryBuilder.maybeConvertToString(this.to);
    }

    public RangeQueryBuilder lt(Object to) {
        return this.to(to, false);
    }

    public RangeQueryBuilder lte(Object to) {
        return this.to(to, true);
    }

    public RangeQueryBuilder includeLower(boolean includeLower) {
        this.includeLower = includeLower;
        return this;
    }

    public boolean includeLower() {
        return this.includeLower;
    }

    public RangeQueryBuilder includeUpper(boolean includeUpper) {
        this.includeUpper = includeUpper;
        return this;
    }

    public boolean includeUpper() {
        return this.includeUpper;
    }

    public RangeQueryBuilder timeZone(String timeZone) {
        if (timeZone == null) {
            throw new IllegalArgumentException("timezone cannot be null");
        }
        try {
            this.timeZone = ZoneId.of(timeZone);
        }
        catch (DateTimeException e) {
            throw new IllegalArgumentException(e);
        }
        return this;
    }

    public String timeZone() {
        return this.timeZone == null ? null : this.timeZone.getId();
    }

    ZoneId getDateTimeZone() {
        return this.timeZone;
    }

    public RangeQueryBuilder format(String format) {
        if (format == null) {
            throw new IllegalArgumentException("format cannot be null");
        }
        DateFormatter.forPattern(format);
        this.format = format;
        return this;
    }

    public String format() {
        return this.format;
    }

    DateMathParser getForceDateParser() {
        if (Strings.hasText(this.format)) {
            return DateFormatter.forPattern(this.format).toDateMathParser();
        }
        return null;
    }

    public ShapeRelation relation() {
        return this.relation;
    }

    public RangeQueryBuilder relation(String relation) {
        if (relation == null) {
            throw new IllegalArgumentException("relation cannot be null");
        }
        this.relation = ShapeRelation.getRelationByName(relation);
        if (this.relation == null) {
            throw new IllegalArgumentException(relation + " is not a valid relation");
        }
        if (!this.isRelationAllowed(this.relation)) {
            throw new IllegalArgumentException("[range] query does not support relation [" + relation + "]");
        }
        return this;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.startObject(this.fieldName);
        builder.field(FROM_FIELD.getPreferredName(), RangeQueryBuilder.maybeConvertToString(this.from));
        builder.field(TO_FIELD.getPreferredName(), RangeQueryBuilder.maybeConvertToString(this.to));
        builder.field(INCLUDE_LOWER_FIELD.getPreferredName(), this.includeLower);
        builder.field(INCLUDE_UPPER_FIELD.getPreferredName(), this.includeUpper);
        if (this.timeZone != null) {
            builder.field(TIME_ZONE_FIELD.getPreferredName(), this.timeZone.getId());
        }
        if (Strings.hasText(this.format)) {
            builder.field(FORMAT_FIELD.getPreferredName(), this.format);
        }
        if (this.relation != null) {
            builder.field(RELATION_FIELD.getPreferredName(), this.relation.getRelationName());
        }
        this.printBoostAndQueryName(builder);
        builder.endObject();
        builder.endObject();
    }

    public static RangeQueryBuilder fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String fieldName = null;
        Object from = null;
        Object to = null;
        boolean includeLower = true;
        boolean includeUpper = true;
        String timeZone = null;
        float boost = 1.0f;
        String queryName = null;
        String format = null;
        String relation = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                RangeQueryBuilder.throwParsingExceptionOnMultipleFields(NAME, parser.getTokenLocation(), fieldName, currentFieldName);
                fieldName = currentFieldName;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        currentFieldName = parser.currentName();
                        continue;
                    }
                    if (FROM_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                        from = RangeQueryBuilder.maybeConvertToBytesRef(parser.objectBytes());
                        continue;
                    }
                    if (TO_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                        to = RangeQueryBuilder.maybeConvertToBytesRef(parser.objectBytes());
                        continue;
                    }
                    if (INCLUDE_LOWER_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                        includeLower = parser.booleanValue();
                        continue;
                    }
                    if (INCLUDE_UPPER_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                        includeUpper = parser.booleanValue();
                        continue;
                    }
                    if (AbstractQueryBuilder.BOOST_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                        boost = parser.floatValue();
                        continue;
                    }
                    if (GT_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                        from = RangeQueryBuilder.maybeConvertToBytesRef(parser.objectBytes());
                        includeLower = false;
                        continue;
                    }
                    if (GTE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                        from = RangeQueryBuilder.maybeConvertToBytesRef(parser.objectBytes());
                        includeLower = true;
                        continue;
                    }
                    if (LT_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                        to = RangeQueryBuilder.maybeConvertToBytesRef(parser.objectBytes());
                        includeUpper = false;
                        continue;
                    }
                    if (LTE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                        to = RangeQueryBuilder.maybeConvertToBytesRef(parser.objectBytes());
                        includeUpper = true;
                        continue;
                    }
                    if (TIME_ZONE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                        timeZone = parser.text();
                        continue;
                    }
                    if (FORMAT_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                        format = parser.text();
                        continue;
                    }
                    if (RELATION_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                        relation = parser.text();
                        continue;
                    }
                    if (AbstractQueryBuilder.NAME_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                        queryName = parser.text();
                        continue;
                    }
                    throw new ParsingException(parser.getTokenLocation(), "[range] query does not support [" + currentFieldName + "]", new Object[0]);
                }
                continue;
            }
            if (!token.isValue()) continue;
            throw new ParsingException(parser.getTokenLocation(), "[range] query does not support [" + currentFieldName + "]", new Object[0]);
        }
        RangeQueryBuilder rangeQuery = new RangeQueryBuilder(fieldName);
        rangeQuery.from(from);
        rangeQuery.to(to);
        rangeQuery.includeLower(includeLower);
        rangeQuery.includeUpper(includeUpper);
        if (timeZone != null) {
            rangeQuery.timeZone(timeZone);
        }
        rangeQuery.boost(boost);
        rangeQuery.queryName(queryName);
        if (format != null) {
            rangeQuery.format(format);
        }
        if (relation != null) {
            rangeQuery.relation(relation);
        }
        return rangeQuery;
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    protected MappedFieldType.Relation getRelation(QueryRewriteContext queryRewriteContext) throws IOException {
        QueryShardContext shardContext = queryRewriteContext.convertToShardContext();
        if (shardContext != null) {
            MappedFieldType fieldType = shardContext.fieldMapper(this.fieldName);
            if (fieldType == null) {
                return MappedFieldType.Relation.DISJOINT;
            }
            if (shardContext.getIndexReader() == null) {
                return MappedFieldType.Relation.INTERSECTS;
            }
            DateMathParser dateMathParser = this.getForceDateParser();
            MappedFieldType.Relation relation = fieldType.isFieldWithinQuery(shardContext.getIndexReader(), this.from, this.to, this.includeLower, this.includeUpper, this.timeZone, dateMathParser, queryRewriteContext);
            if (relation == MappedFieldType.Relation.DISJOINT && shardContext.validate()) {
                return MappedFieldType.Relation.INTERSECTS;
            }
            return relation;
        }
        return MappedFieldType.Relation.INTERSECTS;
    }

    @Override
    protected QueryBuilder doRewrite(QueryRewriteContext queryRewriteContext) throws IOException {
        MappedFieldType.Relation relation = this.getRelation(queryRewriteContext);
        switch (relation) {
            case DISJOINT: {
                return new MatchNoneQueryBuilder();
            }
            case WITHIN: {
                if (this.from != null || this.to != null || this.format != null || this.timeZone != null) {
                    RangeQueryBuilder newRangeQuery = new RangeQueryBuilder(this.fieldName);
                    newRangeQuery.from(null);
                    newRangeQuery.to(null);
                    newRangeQuery.format = null;
                    newRangeQuery.timeZone = null;
                    return newRangeQuery;
                }
                return this;
            }
            case INTERSECTS: {
                return this;
            }
        }
        throw new AssertionError();
    }

    @Override
    protected Query doToQuery(QueryShardContext context) throws IOException {
        MappedFieldType mapper;
        if (this.from == null && this.to == null) {
            FieldNamesFieldMapper.FieldNamesFieldType fieldNamesFieldType = (FieldNamesFieldMapper.FieldNamesFieldType)context.getMapperService().fieldType("_field_names");
            if (fieldNamesFieldType == null) {
                return new MatchNoDocsQuery("No mappings yet");
            }
            if (fieldNamesFieldType.isEnabled()) {
                return ExistsQueryBuilder.newFilter(context, this.fieldName, false);
            }
        }
        if ((mapper = context.fieldMapper(this.fieldName)) == null) {
            throw new IllegalStateException("Rewrite first");
        }
        DateMathParser forcedDateParser = this.getForceDateParser();
        return mapper.rangeQuery(this.from, this.to, this.includeLower, this.includeUpper, this.relation, this.timeZone, forcedDateParser, context);
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.fieldName, this.from, this.to, this.timeZone, this.includeLower, this.includeUpper, this.format);
    }

    @Override
    protected boolean doEquals(RangeQueryBuilder other) {
        return Objects.equals(this.fieldName, other.fieldName) && Objects.equals(this.from, other.from) && Objects.equals(this.to, other.to) && Objects.equals(this.timeZone, other.timeZone) && Objects.equals(this.includeLower, other.includeLower) && Objects.equals(this.includeUpper, other.includeUpper) && Objects.equals(this.format, other.format);
    }

    @Override
    public List<? extends QueryBuilder> getComplement(QueryShardContext context) {
        if (this.relation != null && this.relation != ShapeRelation.INTERSECTS) {
            return null;
        }
        ArrayList<RangeQueryBuilder> complement = new ArrayList<RangeQueryBuilder>();
        if (this.from != null) {
            RangeQueryBuilder belowRange = new RangeQueryBuilder(this.fieldName);
            belowRange.to(this.from);
            belowRange.includeUpper(!this.includeLower);
            complement.add(belowRange);
        }
        if (this.to != null) {
            RangeQueryBuilder aboveRange = new RangeQueryBuilder(this.fieldName);
            aboveRange.from(this.to);
            aboveRange.includeLower(!this.includeUpper);
            complement.add(aboveRange);
        }
        if (this.format != null) {
            for (RangeQueryBuilder rq : complement) {
                rq.format(this.format);
            }
        }
        if (this.timeZone != null) {
            for (RangeQueryBuilder rq : complement) {
                rq.timeZone = this.timeZone;
            }
        }
        return complement;
    }
}

