/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.rankeval;

import java.io.IOException;
import java.util.Objects;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ConstructingObjectParser;
import org.opensearch.core.xcontent.MediaTypeRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;

public class RatedDocument
implements Writeable,
ToXContentObject {
    static final ParseField RATING_FIELD = new ParseField("rating", new String[0]);
    static final ParseField DOC_ID_FIELD = new ParseField("_id", new String[0]);
    static final ParseField INDEX_FIELD = new ParseField("_index", new String[0]);
    private static final ConstructingObjectParser<RatedDocument, Void> PARSER = new ConstructingObjectParser("rated_document", a -> new RatedDocument((String)a[0], (String)a[1], (Integer)a[2]));
    private final int rating;
    private final DocumentKey key;

    public RatedDocument(String index, String id, int rating) {
        this.key = new DocumentKey(index, id);
        this.rating = rating;
    }

    RatedDocument(StreamInput in) throws IOException {
        this.key = new DocumentKey(in.readString(), in.readString());
        this.rating = in.readVInt();
    }

    public DocumentKey getKey() {
        return this.key;
    }

    public String getIndex() {
        return this.key.getIndex();
    }

    public String getDocID() {
        return this.key.getDocId();
    }

    public int getRating() {
        return this.rating;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.key.getIndex());
        out.writeString(this.key.getDocId());
        out.writeVInt(this.rating);
    }

    static RatedDocument fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(INDEX_FIELD.getPreferredName(), this.key.getIndex());
        builder.field(DOC_ID_FIELD.getPreferredName(), this.key.getDocId());
        builder.field(RATING_FIELD.getPreferredName(), this.rating);
        builder.endObject();
        return builder;
    }

    public String toString() {
        return Strings.toString(MediaTypeRegistry.JSON, this);
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RatedDocument other = (RatedDocument)obj;
        return Objects.equals(this.key, other.key) && Objects.equals(this.rating, other.rating);
    }

    public final int hashCode() {
        return Objects.hash(this.key, this.rating);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), INDEX_FIELD);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), DOC_ID_FIELD);
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), RATING_FIELD);
    }

    static class DocumentKey {
        private final String docId;
        private final String index;

        DocumentKey(String index, String docId) {
            if (Strings.isNullOrEmpty(index)) {
                throw new IllegalArgumentException("Index must be set for each rated document");
            }
            if (Strings.isNullOrEmpty(docId)) {
                throw new IllegalArgumentException("DocId must be set for each rated document");
            }
            this.index = index;
            this.docId = docId;
        }

        String getIndex() {
            return this.index;
        }

        String getDocId() {
            return this.docId;
        }

        public final boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            DocumentKey other = (DocumentKey)obj;
            return Objects.equals(this.index, other.index) && Objects.equals(this.docId, other.docId);
        }

        public final int hashCode() {
            return Objects.hash(this.index, this.docId);
        }

        public String toString() {
            return "{\"_index\":\"" + this.index + "\",\"_id\":\"" + this.docId + "\"}";
        }
    }
}

