/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices;

import java.io.IOException;
import java.util.Objects;
import org.opensearch.Version;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ConstructingObjectParser;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.query.AbstractQueryBuilder;
import org.opensearch.index.query.QueryBuilder;

public class TermsLookup
implements Writeable,
ToXContentFragment {
    private final String index;
    private String id;
    private final String path;
    private String routing;
    private QueryBuilder query;
    private boolean store;
    private static final ConstructingObjectParser<TermsLookup, Void> PARSER = new ConstructingObjectParser("terms_lookup", args -> {
        String index = (String)args[0];
        String id = (String)args[1];
        String path = (String)args[2];
        QueryBuilder query = (QueryBuilder)args[3];
        if (id == null && query == null) {
            throw new IllegalArgumentException("[terms] query lookup element requires specifying either the id or the query.");
        }
        if (id != null && query != null) {
            throw new IllegalArgumentException("[terms] query lookup element cannot specify both id and query.");
        }
        return new TermsLookup(index, id, path, query);
    });

    public TermsLookup(String index, String id, String path) {
        this(index, id, path, null);
    }

    public TermsLookup(String index, String id, String path, QueryBuilder query) {
        if (index == null) {
            throw new IllegalArgumentException("[terms] index cannot be null or empty for TermsLookup");
        }
        if (path == null) {
            throw new IllegalArgumentException("[terms] path cannot be null or empty for TermsLookup");
        }
        if (id == null && query == null) {
            throw new IllegalArgumentException("[terms] query lookup element requires specifying either the id or the query.");
        }
        if (id != null && query != null) {
            throw new IllegalArgumentException("[terms] query lookup element cannot specify both id and query.");
        }
        this.index = index;
        this.id = id;
        this.path = path;
        this.query = query;
    }

    public String index() {
        return this.index;
    }

    public String id() {
        return this.id;
    }

    public TermsLookup(StreamInput in) throws IOException {
        if (in.getVersion().before(Version.V_2_0_0)) {
            in.readOptionalString();
        }
        this.id = in.readString();
        this.path = in.readString();
        this.index = in.readString();
        this.routing = in.readOptionalString();
        if (in.getVersion().onOrAfter(Version.V_2_17_0)) {
            this.store = in.readBoolean();
        }
        if (in.getVersion().onOrAfter(Version.V_3_2_0)) {
            this.query = in.readOptionalWriteable(inStream -> inStream.readNamedWriteable(QueryBuilder.class));
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (out.getVersion().before(Version.V_2_0_0)) {
            out.writeOptionalString("_doc");
        }
        out.writeString(this.id);
        out.writeString(this.path);
        out.writeString(this.index);
        out.writeOptionalString(this.routing);
        if (out.getVersion().onOrAfter(Version.V_2_17_0)) {
            out.writeBoolean(this.store);
        }
        if (out.getVersion().onOrAfter(Version.V_3_2_0)) {
            out.writeOptionalWriteable(this.query);
        }
    }

    public String path() {
        return this.path;
    }

    public String routing() {
        return this.routing;
    }

    public TermsLookup routing(String routing) {
        this.routing = routing;
        return this;
    }

    public boolean store() {
        return this.store;
    }

    public TermsLookup store(boolean store) {
        this.store = store;
        return this;
    }

    public QueryBuilder query() {
        return this.query;
    }

    public TermsLookup query(QueryBuilder query) {
        this.query = query;
        return this;
    }

    public void setQuery(QueryBuilder query) {
        if (this.id != null && query != null) {
            throw new IllegalArgumentException("[terms] query lookup element cannot specify both id and query.");
        }
        this.query = query;
    }

    public TermsLookup id(String id) {
        if (this.query != null && id != null) {
            throw new IllegalArgumentException("[terms] query lookup element cannot specify both id and query.");
        }
        this.id = id;
        return this;
    }

    public static TermsLookup parseTermsLookup(XContentParser parser) throws IOException {
        return PARSER.parse(parser, null);
    }

    public String toString() {
        return this.index + "/" + this.id + "/" + this.path;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("index", this.index);
        if (this.id != null) {
            builder.field("id", this.id);
        }
        builder.field("path", this.path);
        if (this.routing != null) {
            builder.field("routing", this.routing);
        }
        if (this.query != null) {
            builder.field("query");
            this.query.toXContent(builder, params);
        }
        if (this.store) {
            builder.field("store", true);
        }
        return builder;
    }

    public int hashCode() {
        return Objects.hash(this.index, this.id, this.path, this.routing, this.store, this.query);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TermsLookup other = (TermsLookup)obj;
        return Objects.equals(this.index, other.index) && Objects.equals(this.id, other.id) && Objects.equals(this.path, other.path) && Objects.equals(this.routing, other.routing) && Objects.equals(this.store, other.store) && Objects.equals(this.query, other.query);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("index", new String[0]));
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("id", new String[0]));
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("path", new String[0]));
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (parser, context) -> {
            try {
                return AbstractQueryBuilder.parseInnerQueryBuilder(parser);
            }
            catch (IOException e) {
                throw new RuntimeException("Error parsing inner query builder", e);
            }
        }, new ParseField("query", new String[0]));
        PARSER.declareString(TermsLookup::routing, new ParseField("routing", new String[0]));
        PARSER.declareBoolean(TermsLookup::store, new ParseField("store", new String[0]));
    }
}

