/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices.replication.checkpoint;

import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.store.AlreadyClosedException;
import org.opensearch.ExceptionsHelper;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.replication.ReplicationMode;
import org.opensearch.action.support.replication.ReplicationRequest;
import org.opensearch.action.support.replication.ReplicationResponse;
import org.opensearch.action.support.replication.ReplicationTask;
import org.opensearch.action.support.replication.TransportReplicationAction;
import org.opensearch.cluster.action.shard.ShardStateAction;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.util.concurrent.ThreadContextAccess;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.index.shard.IndexShardClosedException;
import org.opensearch.index.shard.ShardNotInPrimaryModeException;
import org.opensearch.indices.IndicesService;
import org.opensearch.indices.replication.checkpoint.ReplicationCheckpoint;
import org.opensearch.indices.replication.common.ReplicationTimer;
import org.opensearch.node.NodeClosedException;
import org.opensearch.tasks.Task;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportException;
import org.opensearch.transport.TransportRequest;
import org.opensearch.transport.TransportResponseHandler;
import org.opensearch.transport.TransportService;

public abstract class AbstractPublishCheckpointAction<Request extends ReplicationRequest<Request>, ReplicaRequest extends ReplicationRequest<ReplicaRequest>>
extends TransportReplicationAction<Request, ReplicaRequest, ReplicationResponse> {
    private final Logger logger;

    public AbstractPublishCheckpointAction(Settings settings, String actionName, TransportService transportService, ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ShardStateAction shardStateAction, ActionFilters actionFilters, Writeable.Reader<Request> requestReader, Writeable.Reader<ReplicaRequest> replicaRequestReader, String threadPoolName, Logger logger) {
        super(settings, actionName, transportService, clusterService, indicesService, threadPool, shardStateAction, actionFilters, requestReader, replicaRequestReader, threadPoolName);
        this.logger = logger;
    }

    @Override
    protected ReplicationResponse newResponseInstance(StreamInput in) throws IOException {
        return new ReplicationResponse(in);
    }

    @Override
    public ReplicationMode getReplicationMode(IndexShard indexShard) {
        if (indexShard.indexSettings().isAssignedOnRemoteNode()) {
            return ReplicationMode.FULL_REPLICATION;
        }
        return super.getReplicationMode(indexShard);
    }

    final void doPublish(final IndexShard indexShard, final ReplicationCheckpoint checkpoint, TransportRequest request, String action, boolean waitForCompletion, TimeValue waitTimeout) {
        String primaryAllocationId = indexShard.routingEntry().allocationId().getId();
        long primaryTerm = indexShard.getPendingPrimaryTerm();
        ThreadContext threadContext = this.threadPool.getThreadContext();
        try (ThreadContext.StoredContext ignore = threadContext.stashContext();){
            ThreadContextAccess.doPrivilegedVoid(threadContext::markAsSystemContext);
            final ReplicationTask task = (ReplicationTask)this.taskManager.register("transport", action, request);
            final ReplicationTimer timer = new ReplicationTimer();
            timer.start();
            final CountDownLatch latch = new CountDownLatch(1);
            this.transportService.sendChildRequest(indexShard.recoveryState().getTargetNode(), this.transportPrimaryAction, new TransportReplicationAction.ConcreteShardRequest<TransportRequest>(request, primaryAllocationId, primaryTerm), (Task)task, this.transportOptions, new TransportResponseHandler<ReplicationResponse>(){
                final /* synthetic */ AbstractPublishCheckpointAction this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public ReplicationResponse read(StreamInput in) throws IOException {
                    return this.this$0.newResponseInstance(in);
                }

                @Override
                public String executor() {
                    return "same";
                }

                @Override
                public void handleResponse(ReplicationResponse response) {
                    try {
                        timer.stop();
                        this.this$0.logger.debug(() -> new ParameterizedMessage("[shardId {}] Completed publishing checkpoint [{}], timing: {}", new Object[]{indexShard.shardId().getId(), checkpoint, timer.time()}));
                        task.setPhase("finished");
                        this.this$0.taskManager.unregister(task);
                    }
                    finally {
                        latch.countDown();
                    }
                }

                @Override
                public void handleException(TransportException e) {
                    try {
                        timer.stop();
                        this.this$0.logger.debug("[shardId {}] Failed to publish checkpoint [{}], timing: {}", (Object)indexShard.shardId().getId(), (Object)checkpoint, (Object)timer.time());
                        task.setPhase("finished");
                        this.this$0.taskManager.unregister(task);
                        if (ExceptionsHelper.unwrap(e, NodeClosedException.class, IndexNotFoundException.class, AlreadyClosedException.class, IndexShardClosedException.class, ShardNotInPrimaryModeException.class) != null) {
                            return;
                        }
                        this.this$0.logger.warn((Message)new ParameterizedMessage("{} segment replication checkpoint [{}] publishing failed", (Object)indexShard.shardId(), (Object)checkpoint), (Throwable)e);
                    }
                    finally {
                        latch.countDown();
                    }
                }
            });
            this.logger.trace(() -> new ParameterizedMessage("[shardId {}] Publishing replication checkpoint [{}]", (Object)checkpoint.getShardId().getId(), (Object)checkpoint));
            if (waitForCompletion) {
                try {
                    latch.await(waitTimeout.seconds(), TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    this.logger.warn(() -> new ParameterizedMessage("Interrupted while waiting for publish checkpoint complete [{}]", (Object)checkpoint), (Throwable)e);
                }
            }
        }
    }

    @Override
    protected final void shardOperationOnReplica(ReplicaRequest shardRequest, IndexShard replica, ActionListener<TransportReplicationAction.ReplicaResult> listener) {
        Objects.requireNonNull(shardRequest);
        Objects.requireNonNull(replica);
        ActionListener.completeWith(listener, () -> {
            this.logger.trace(() -> new ParameterizedMessage("Checkpoint {} received on replica {}", shardRequest, (Object)replica.shardId()));
            if (!replica.indexSettings().isAssignedOnRemoteNode() && !replica.indexSettings().isSegRepLocalEnabled()) {
                this.logger.trace("Received segrep checkpoint on a docrep shard copy during an ongoing remote migration. NoOp.");
                return new TransportReplicationAction.ReplicaResult();
            }
            this.doReplicaOperation(shardRequest, replica);
            return new TransportReplicationAction.ReplicaResult();
        });
    }

    protected abstract void doReplicaOperation(ReplicaRequest var1, IndexShard var2);
}

