/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.repositories;

import java.io.IOException;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.blobstore.DeleteResult;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.MediaTypeRegistry;
import org.opensearch.core.xcontent.ObjectParser;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;

@PublicApi(since="1.0.0")
public final class RepositoryCleanupResult
implements Writeable,
ToXContentObject {
    public static final ObjectParser<RepositoryCleanupResult, Void> PARSER = new ObjectParser(RepositoryCleanupResult.class.getName(), true, RepositoryCleanupResult::new);
    private static final String DELETED_BLOBS = "deleted_blobs";
    private static final String DELETED_BYTES = "deleted_bytes";
    private long bytes;
    private long blobs;

    private RepositoryCleanupResult() {
        this(DeleteResult.ZERO);
    }

    public RepositoryCleanupResult(DeleteResult result) {
        this.blobs = result.blobsDeleted();
        this.bytes = result.bytesDeleted();
    }

    public RepositoryCleanupResult(StreamInput in) throws IOException {
        this.bytes = in.readLong();
        this.blobs = in.readLong();
    }

    public long bytes() {
        return this.bytes;
    }

    public long blobs() {
        return this.blobs;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeLong(this.bytes);
        out.writeLong(this.blobs);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.startObject().field(DELETED_BYTES, this.bytes).field(DELETED_BLOBS, this.blobs).endObject();
    }

    public String toString() {
        return Strings.toString(MediaTypeRegistry.JSON, this);
    }

    static {
        PARSER.declareLong((result, bytes) -> {
            result.bytes = bytes;
        }, new ParseField(DELETED_BYTES, new String[0]));
        PARSER.declareLong((result, blobs) -> {
            result.blobs = blobs;
        }, new ParseField(DELETED_BLOBS, new String[0]));
    }
}

