/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.admin.indices;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.opensearch.action.admin.indices.streamingingestion.state.GetIngestionStateRequest;
import org.opensearch.action.admin.indices.streamingingestion.state.GetIngestionStateResponse;
import org.opensearch.action.pagination.PageParams;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.core.common.Strings;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.transport.client.node.NodeClient;

@ExperimentalApi
public class RestGetIngestionStateAction
extends BaseRestHandler {
    @Override
    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "/{index}/ingestion/_state")));
    }

    @Override
    public String getName() {
        return "get_ingestion_state_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        GetIngestionStateRequest getIngestionStateRequest = new GetIngestionStateRequest(Strings.splitStringByCommaToArray(request.param("index")));
        if (request.hasParam("shards")) {
            int[] shards = Arrays.stream(request.paramAsStringArrayOrEmptyIfAll("shards")).mapToInt(Integer::parseInt).toArray();
            getIngestionStateRequest.setShards(shards);
        }
        getIngestionStateRequest.timeout(request.paramAsTime("timeout", getIngestionStateRequest.timeout()));
        getIngestionStateRequest.indicesOptions(IndicesOptions.fromRequest(request, getIngestionStateRequest.indicesOptions()));
        PageParams pageParams = this.validateAndGetPageParams(request, "asc", 1000);
        getIngestionStateRequest.setPageParams(pageParams);
        return channel -> client.admin().indices().getIngestionState(getIngestionStateRequest, new RestToXContentListener<GetIngestionStateResponse>((RestChannel)channel));
    }

    @Override
    public boolean isActionPaginated() {
        return true;
    }
}

