/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.admin.indices;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.opensearch.action.admin.indices.streamingingestion.resume.ResumeIngestionRequest;
import org.opensearch.action.admin.indices.streamingingestion.resume.ResumeIngestionResponse;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.core.common.Strings;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.transport.client.node.NodeClient;

@ExperimentalApi
public class RestResumeIngestionAction
extends BaseRestHandler {
    @Override
    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.POST, "/{index}/ingestion/_resume")));
    }

    @Override
    public String getName() {
        return "resume_ingestion_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String[] indices = Strings.splitStringByCommaToArray(request.param("index"));
        ResumeIngestionRequest resumeIngestionRequest = request.hasContent() ? ResumeIngestionRequest.fromXContent(indices, request.contentParser()) : new ResumeIngestionRequest(indices, new ResumeIngestionRequest.ResetSettings[0]);
        resumeIngestionRequest.clusterManagerNodeTimeout(request.paramAsTime("cluster_manager_timeout", resumeIngestionRequest.clusterManagerNodeTimeout()));
        resumeIngestionRequest.timeout(request.paramAsTime("timeout", resumeIngestionRequest.timeout()));
        resumeIngestionRequest.indicesOptions(IndicesOptions.fromRequest(request, resumeIngestionRequest.indicesOptions()));
        return channel -> client.admin().indices().resumeIngestion(resumeIngestionRequest, new RestToXContentListener<ResumeIngestionResponse>((RestChannel)channel));
    }
}

