/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.admin.indices;

import java.io.IOException;
import java.util.List;
import java.util.function.IntConsumer;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.admin.indices.view.CreateViewAction;
import org.opensearch.action.admin.indices.view.DeleteViewAction;
import org.opensearch.action.admin.indices.view.GetViewAction;
import org.opensearch.action.admin.indices.view.ListViewNamesAction;
import org.opensearch.action.admin.indices.view.SearchViewAction;
import org.opensearch.action.admin.indices.view.UpdateViewAction;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.support.clustermanager.AcknowledgedResponse;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.NamedRoute;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestCancellableNodeClient;
import org.opensearch.rest.action.RestStatusToXContentListener;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.rest.action.search.RestSearchAction;
import org.opensearch.transport.client.node.NodeClient;

@ExperimentalApi
public class RestViewAction {
    public static final String VIEW_NAME = "view_name";
    public static final String VIEW_NAME_PARAMETER = "{view_name}";

    @ExperimentalApi
    public static class SearchViewHandler
    extends BaseRestHandler {
        @Override
        public List<RestHandler.Route> routes() {
            return List.of(new NamedRoute.Builder().path("/views/{view_name}/_search").method(RestRequest.Method.GET).uniqueName("views:data/read/search").build(), new NamedRoute.Builder().path("/views/{view_name}/_search").method(RestRequest.Method.POST).uniqueName("views:data/read/search").build());
        }

        @Override
        public String getName() {
            return "views:data/read/search";
        }

        @Override
        public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
            String viewId = request.param(RestViewAction.VIEW_NAME);
            SearchViewAction.Request viewSearchRequest = new SearchViewAction.Request(viewId, new SearchRequest());
            IntConsumer setSize = size -> viewSearchRequest.source().size(size);
            request.withContentOrSourceParamParserOrNull(parser -> RestSearchAction.parseSearchRequest(viewSearchRequest, request, parser, client.getNamedWriteableRegistry(), setSize));
            ActionRequestValidationException validationResult = viewSearchRequest.validate();
            if (validationResult != null) {
                throw validationResult;
            }
            return channel -> {
                RestCancellableNodeClient cancelClient = new RestCancellableNodeClient(client, request.getHttpChannel());
                cancelClient.execute(SearchViewAction.INSTANCE, viewSearchRequest, new RestStatusToXContentListener((RestChannel)channel));
            };
        }
    }

    @ExperimentalApi
    public static class ListViewNamesHandler
    extends BaseRestHandler {
        @Override
        public List<RestHandler.Route> routes() {
            return List.of(new NamedRoute.Builder().path("/views/").method(RestRequest.Method.GET).uniqueName("views:data/read/list").build());
        }

        @Override
        public String getName() {
            return "views:data/read/list";
        }

        @Override
        protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
            return channel -> client.listViewNames(new ListViewNamesAction.Request(), new RestToXContentListener<ListViewNamesAction.Response>((RestChannel)channel));
        }
    }

    @ExperimentalApi
    public static class GetViewHandler
    extends BaseRestHandler {
        @Override
        public List<RestHandler.Route> routes() {
            return List.of(new NamedRoute.Builder().path("/views/{view_name}").method(RestRequest.Method.GET).uniqueName("views:data/read/get").build());
        }

        @Override
        public String getName() {
            return "views:data/read/get";
        }

        @Override
        protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
            String viewId = request.param(RestViewAction.VIEW_NAME);
            GetViewAction.Request getRequest = new GetViewAction.Request(viewId);
            ActionRequestValidationException validationResult = getRequest.validate();
            if (validationResult != null) {
                throw validationResult;
            }
            return channel -> client.admin().indices().getView(getRequest, new RestToXContentListener<GetViewAction.Response>((RestChannel)channel));
        }
    }

    @ExperimentalApi
    public static class UpdateViewHandler
    extends BaseRestHandler {
        @Override
        public List<RestHandler.Route> routes() {
            return List.of(new NamedRoute.Builder().path("/views/{view_name}").method(RestRequest.Method.PUT).uniqueName("cluster:admin/views/update").build());
        }

        @Override
        public String getName() {
            return "cluster:admin/views/update";
        }

        @Override
        protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
            String viewId = request.param(RestViewAction.VIEW_NAME);
            try (XContentParser parser = request.contentParser();){
                CreateViewAction.Request updateRequest = UpdateViewAction.Request.fromXContent(parser, viewId);
                ActionRequestValidationException validationResult = updateRequest.validate();
                if (validationResult != null) {
                    throw validationResult;
                }
                BaseRestHandler.RestChannelConsumer restChannelConsumer = channel -> client.admin().indices().updateView(updateRequest, new RestToXContentListener<GetViewAction.Response>((RestChannel)channel));
                return restChannelConsumer;
            }
        }
    }

    @ExperimentalApi
    public static class DeleteViewHandler
    extends BaseRestHandler {
        @Override
        public List<RestHandler.Route> routes() {
            return List.of(new NamedRoute.Builder().path("/views/{view_name}").method(RestRequest.Method.DELETE).uniqueName("cluster:admin/views/delete").build());
        }

        @Override
        public String getName() {
            return "cluster:admin/views/delete";
        }

        @Override
        protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
            String viewId = request.param(RestViewAction.VIEW_NAME);
            DeleteViewAction.Request deleteRequest = new DeleteViewAction.Request(viewId);
            ActionRequestValidationException validationResult = deleteRequest.validate();
            if (validationResult != null) {
                throw validationResult;
            }
            return channel -> client.admin().indices().deleteView(deleteRequest, new RestToXContentListener<AcknowledgedResponse>((RestChannel)channel));
        }
    }

    @ExperimentalApi
    public static class CreateViewHandler
    extends BaseRestHandler {
        @Override
        public List<RestHandler.Route> routes() {
            return List.of(new NamedRoute.Builder().path("/views").method(RestRequest.Method.POST).uniqueName("cluster:admin/views/create").build());
        }

        @Override
        public String getName() {
            return "cluster:admin/views/create";
        }

        @Override
        protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
            try (XContentParser parser = request.contentParser();){
                CreateViewAction.Request createViewAction = CreateViewAction.Request.fromXContent(parser);
                ActionRequestValidationException validationResult = createViewAction.validate();
                if (validationResult != null) {
                    throw validationResult;
                }
                BaseRestHandler.RestChannelConsumer restChannelConsumer = channel -> client.admin().indices().createView(createViewAction, new RestToXContentListener<GetViewAction.Response>((RestChannel)channel));
                return restChannelConsumer;
            }
        }
    }
}

