/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.opensearch.action.search.DeletePitRequest;
import org.opensearch.action.search.DeletePitResponse;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestStatusToXContentListener;
import org.opensearch.transport.client.node.NodeClient;

public class RestDeletePitAction
extends BaseRestHandler {
    @Override
    public String getName() {
        return "delete_pit_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        DeletePitRequest deletePITRequest;
        String allPitIdsQualifier = "_all";
        if (request.path().contains(allPitIdsQualifier)) {
            deletePITRequest = new DeletePitRequest(Arrays.asList(allPitIdsQualifier));
        } else {
            deletePITRequest = new DeletePitRequest();
            request.withContentOrSourceParamParserOrNull(xContentParser -> {
                if (xContentParser != null) {
                    try {
                        deletePITRequest.fromXContent((XContentParser)xContentParser);
                    }
                    catch (IOException e) {
                        throw new IllegalArgumentException("Failed to parse request body", e);
                    }
                }
            });
        }
        return channel -> client.deletePits(deletePITRequest, new RestStatusToXContentListener<DeletePitResponse>((RestChannel)channel));
    }

    @Override
    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.DELETE, "/_search/point_in_time"), new RestHandler.Route(RestRequest.Method.DELETE, "/_search/point_in_time/_all")));
    }
}

