/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.script.mustache;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestStatusToXContentListener;
import org.opensearch.rest.action.search.RestSearchAction;
import org.opensearch.script.mustache.SearchTemplateAction;
import org.opensearch.script.mustache.SearchTemplateRequest;
import org.opensearch.transport.client.node.NodeClient;

public class RestSearchTemplateAction
extends BaseRestHandler {
    public static final String TYPED_KEYS_PARAM = "typed_keys";
    private static final Set<String> RESPONSE_PARAMS;

    @Override
    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "/_search/template"), new RestHandler.Route(RestRequest.Method.POST, "/_search/template"), new RestHandler.Route(RestRequest.Method.GET, "/{index}/_search/template"), new RestHandler.Route(RestRequest.Method.POST, "/{index}/_search/template")));
    }

    @Override
    public String getName() {
        return "search_template_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        SearchTemplateRequest searchTemplateRequest;
        SearchRequest searchRequest = new SearchRequest();
        RestSearchAction.parseSearchRequest(searchRequest, request, null, client.getNamedWriteableRegistry(), size -> searchRequest.source().size(size));
        try (XContentParser parser = request.contentOrSourceParamParser();){
            searchTemplateRequest = SearchTemplateRequest.fromXContent(parser);
        }
        String pipeline = searchTemplateRequest.getSearchPipeline();
        if (pipeline != null && !pipeline.isEmpty()) {
            searchRequest.pipeline(pipeline);
        }
        searchTemplateRequest.setRequest(searchRequest);
        return channel -> client.execute(SearchTemplateAction.INSTANCE, searchTemplateRequest, new RestStatusToXContentListener((RestChannel)channel));
    }

    @Override
    protected Set<String> responseParams() {
        return RESPONSE_PARAMS;
    }

    static {
        HashSet<String> responseParams = new HashSet<String>(Arrays.asList(TYPED_KEYS_PARAM, "rest_total_hits_as_int"));
        RESPONSE_PARAMS = Collections.unmodifiableSet(responseParams);
    }
}

