/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.composite;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.opensearch.common.Rounding;
import org.opensearch.index.fielddata.SortedBinaryDocValues;
import org.opensearch.index.fielddata.SortedNumericDoubleValues;
import org.opensearch.search.aggregations.support.ValuesSource;

public class RoundingValuesSource
extends ValuesSource.Numeric {
    private final ValuesSource.Numeric vs;
    private final Rounding.Prepared preparedRounding;
    private final Rounding rounding;

    RoundingValuesSource(ValuesSource.Numeric vs, Rounding.Prepared preparedRounding, Rounding rounding) {
        this.vs = vs;
        this.preparedRounding = preparedRounding;
        this.rounding = rounding;
    }

    @Override
    public boolean isFloatingPoint() {
        return false;
    }

    @Override
    public boolean isBigInteger() {
        return false;
    }

    public Rounding.Prepared getPreparedRounding() {
        return this.preparedRounding;
    }

    public Rounding getRounding() {
        return this.rounding;
    }

    public long round(long value) {
        return this.preparedRounding.round(value);
    }

    @Override
    public SortedNumericDocValues longValues(LeafReaderContext context) throws IOException {
        final SortedNumericDocValues values = this.vs.longValues(context);
        return new SortedNumericDocValues(this){
            final /* synthetic */ RoundingValuesSource this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public long nextValue() throws IOException {
                return this.this$0.round(values.nextValue());
            }

            @Override
            public int docValueCount() {
                return values.docValueCount();
            }

            @Override
            public boolean advanceExact(int target) throws IOException {
                return values.advanceExact(target);
            }

            @Override
            public int docID() {
                return values.docID();
            }

            @Override
            public int nextDoc() throws IOException {
                return values.nextDoc();
            }

            @Override
            public int advance(int target) throws IOException {
                return values.advance(target);
            }

            @Override
            public long cost() {
                return values.cost();
            }
        };
    }

    @Override
    public SortedBinaryDocValues bytesValues(LeafReaderContext context) throws IOException {
        throw new UnsupportedOperationException("not applicable");
    }

    @Override
    public SortedNumericDoubleValues doubleValues(LeafReaderContext context) throws IOException {
        throw new UnsupportedOperationException("not applicable");
    }
}

