/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.filterrewrite;

import java.io.IOException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Weight;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.search.aggregations.bucket.filterrewrite.FilterRewriteOptimizationContext;
import org.opensearch.search.aggregations.bucket.filterrewrite.Helper;
import org.opensearch.search.aggregations.bucket.filterrewrite.PointTreeTraversal;
import org.opensearch.search.aggregations.bucket.filterrewrite.Ranges;
import org.opensearch.search.aggregations.bucket.filterrewrite.rangecollector.RangeCollector;
import org.opensearch.search.internal.SearchContext;

public abstract class AggregatorBridge {
    static final Logger logger = LogManager.getLogger((String)Helper.loggerName);
    MappedFieldType fieldType;
    Consumer<Ranges> setRanges;

    void setRangesConsumer(Consumer<Ranges> setRanges) {
        this.setRanges = setRanges;
    }

    protected abstract boolean canOptimize();

    protected abstract void prepare() throws IOException;

    abstract Ranges tryBuildRangesFromSegment(LeafReaderContext var1) throws IOException;

    abstract FilterRewriteOptimizationContext.OptimizeResult tryOptimize(PointValues var1, BiConsumer<Long, Long> var2, Ranges var3, FilterRewriteOptimizationContext.SubAggCollectorParam var4) throws IOException;

    static FilterRewriteOptimizationContext.OptimizeResult getResult(PointValues values, BiConsumer<Long, Long> incrementDocCount, Ranges ranges, Function<Integer, Long> getBucketOrd, int size, FilterRewriteOptimizationContext.SubAggCollectorParam subAggCollectorParam) throws IOException {
        BiConsumer<Integer, Integer> incrementFunc = (activeIndex, docCount) -> {
            long bucketOrd = (Long)getBucketOrd.apply((Integer)activeIndex);
            incrementDocCount.accept(bucketOrd, Long.valueOf(docCount.intValue()));
        };
        PointValues.PointTree tree = values.getPointTree();
        FilterRewriteOptimizationContext.OptimizeResult optimizeResult = new FilterRewriteOptimizationContext.OptimizeResult();
        int activeIndex2 = ranges.firstRangeIndex(tree.getMinPackedValue(), tree.getMaxPackedValue());
        if (activeIndex2 < 0) {
            logger.debug("No ranges match the query, skip the fast filter optimization");
            return optimizeResult;
        }
        RangeCollector collector = PointTreeTraversal.createCollector(ranges, incrementFunc, size, activeIndex2, getBucketOrd, optimizeResult, subAggCollectorParam);
        return PointTreeTraversal.multiRangesTraverse(tree, collector);
    }

    public static boolean segmentMatchAll(SearchContext ctx, LeafReaderContext leafCtx) throws IOException {
        Weight weight = ctx.query().rewrite(ctx.searcher()).createWeight(ctx.searcher(), ScoreMode.COMPLETE_NO_SCORES, 1.0f);
        return weight != null && weight.count(leafCtx) == leafCtx.reader().numDocs();
    }
}

