/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.sampler;

import java.io.IOException;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.misc.search.DiversifiedTopDocsCollector;
import org.apache.lucene.search.TopDocsCollector;
import org.apache.lucene.util.BytesRef;
import org.opensearch.OpenSearchException;
import org.opensearch.index.fielddata.AbstractNumericDocValues;
import org.opensearch.index.fielddata.SortedBinaryDocValues;
import org.opensearch.search.aggregations.Aggregator;
import org.opensearch.search.aggregations.AggregatorFactories;
import org.opensearch.search.aggregations.bucket.DeferringBucketCollector;
import org.opensearch.search.aggregations.bucket.sampler.BestDocsDeferringCollector;
import org.opensearch.search.aggregations.bucket.sampler.SamplerAggregator;
import org.opensearch.search.aggregations.support.ValuesSource;
import org.opensearch.search.aggregations.support.ValuesSourceConfig;
import org.opensearch.search.internal.SearchContext;

public class DiversifiedBytesHashSamplerAggregator
extends SamplerAggregator {
    private ValuesSource valuesSource;
    private int maxDocsPerValue;

    DiversifiedBytesHashSamplerAggregator(String name, int shardSize, AggregatorFactories factories, SearchContext context, Aggregator parent, Map<String, Object> metadata, ValuesSourceConfig valuesSourceConfig, int maxDocsPerValue) throws IOException {
        super(name, shardSize, factories, context, parent, metadata);
        assert (valuesSourceConfig.hasValues());
        this.valuesSource = valuesSourceConfig.getValuesSource();
        this.maxDocsPerValue = maxDocsPerValue;
    }

    @Override
    public DeferringBucketCollector getDeferringCollector() {
        DiversifiedBytesHashSamplerAggregator diversifiedBytesHashSamplerAggregator = this;
        this.bdd = new DiverseDocsDeferringCollector(x$0 -> diversifiedBytesHashSamplerAggregator.addRequestCircuitBreakerBytes((long)x$0));
        return this.bdd;
    }

    class DiverseDocsDeferringCollector
    extends BestDocsDeferringCollector {
        DiverseDocsDeferringCollector(Consumer<Long> circuitBreakerConsumer) {
            super(DiversifiedBytesHashSamplerAggregator.this.shardSize, DiversifiedBytesHashSamplerAggregator.this.context.bigArrays(), circuitBreakerConsumer);
        }

        protected TopDocsCollector<DiversifiedTopDocsCollector.ScoreDocKey> createTopDocsCollector(int size) {
            int minMaxDocsPerValue = Math.min(DiversifiedBytesHashSamplerAggregator.this.maxDocsPerValue, DiversifiedBytesHashSamplerAggregator.this.context.searcher().getIndexReader().maxDoc());
            return new ValuesDiversifiedTopDocsCollector(size, minMaxDocsPerValue);
        }

        @Override
        protected long getPriorityQueueSlotSize() {
            return SamplerAggregator.SCOREDOCKEY_SIZE;
        }

        class ValuesDiversifiedTopDocsCollector
        extends DiversifiedTopDocsCollector {
            private SortedBinaryDocValues values;

            ValuesDiversifiedTopDocsCollector(int numHits, int maxHitsPerValue) {
                super(numHits, maxHitsPerValue);
            }

            @Override
            protected NumericDocValues getKeys(LeafReaderContext context) {
                try {
                    this.values = DiversifiedBytesHashSamplerAggregator.this.valuesSource.bytesValues(context);
                }
                catch (IOException e) {
                    throw new OpenSearchException("Error reading values", (Throwable)e, new Object[0]);
                }
                return new AbstractNumericDocValues(){
                    private int docID = -1;

                    @Override
                    public boolean advanceExact(int target) throws IOException {
                        this.docID = target;
                        if (ValuesDiversifiedTopDocsCollector.this.values.advanceExact(target)) {
                            if (ValuesDiversifiedTopDocsCollector.this.values.docValueCount() > 1) {
                                throw new IllegalArgumentException("Sample diversifying key must be a single valued-field");
                            }
                            return true;
                        }
                        return false;
                    }

                    @Override
                    public int docID() {
                        return this.docID;
                    }

                    @Override
                    public long longValue() throws IOException {
                        BytesRef bytes = ValuesDiversifiedTopDocsCollector.this.values.nextValue();
                        return bytes.hashCode();
                    }
                };
            }
        }
    }
}

