/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.approximate;

import java.io.IOException;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Weight;
import org.opensearch.search.approximate.ApproximateQuery;
import org.opensearch.search.internal.SearchContext;

public final class ApproximateScoreQuery
extends Query {
    private final Query originalQuery;
    private final ApproximateQuery approximationQuery;
    Query resolvedQuery;

    public ApproximateScoreQuery(Query originalQuery, ApproximateQuery approximationQuery) {
        this.originalQuery = originalQuery;
        this.approximationQuery = approximationQuery;
    }

    public Query getOriginalQuery() {
        return this.originalQuery;
    }

    public ApproximateQuery getApproximationQuery() {
        return this.approximationQuery;
    }

    @Override
    public Query rewrite(IndexSearcher indexSearcher) throws IOException {
        if (this.resolvedQuery == null) {
            return this.originalQuery.rewrite(indexSearcher);
        }
        Query rewritten = this.resolvedQuery.rewrite(indexSearcher);
        if (rewritten != this.resolvedQuery) {
            this.resolvedQuery = rewritten;
        }
        return this;
    }

    public void setContext(SearchContext context) {
        this.resolvedQuery = this.approximationQuery.canApproximate(context) ? this.approximationQuery : this.originalQuery;
    }

    @Override
    public String toString(String s) {
        return "ApproximateScoreQuery(originalQuery=" + this.originalQuery.toString() + ", approximationQuery=" + this.approximationQuery.toString() + ")";
    }

    @Override
    public void visit(QueryVisitor queryVisitor) {
        QueryVisitor v = queryVisitor.getSubVisitor(BooleanClause.Occur.MUST, this);
        this.originalQuery.visit(v);
        this.approximationQuery.visit(v);
    }

    @Override
    public boolean equals(Object o) {
        return this.sameClassAs(o);
    }

    @Override
    public Weight createWeight(IndexSearcher indexSearcher, ScoreMode scoreMode, float boost) throws IOException {
        if (this.resolvedQuery == null) {
            return this.originalQuery.createWeight(indexSearcher, scoreMode, boost);
        }
        return this.resolvedQuery.createWeight(indexSearcher, scoreMode, boost);
    }

    @Override
    public int hashCode() {
        int h = this.classHash();
        h = 31 * h + this.originalQuery.hashCode();
        h = 31 * h + this.approximationQuery.hashCode();
        return h;
    }
}

