/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport.stream;

import java.io.IOException;
import java.util.Objects;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.transport.TransportException;
import org.opensearch.transport.stream.StreamErrorCode;

@ExperimentalApi
public class StreamException
extends TransportException {
    private final StreamErrorCode errorCode;

    public StreamException(StreamInput streamInput) throws IOException {
        super(streamInput);
        this.errorCode = StreamErrorCode.fromCode(streamInput.read());
    }

    public StreamException(StreamErrorCode errorCode, String message) {
        this(errorCode, message, null);
    }

    public StreamException(StreamErrorCode errorCode, String message, Throwable cause) {
        super(message, cause);
        this.errorCode = Objects.requireNonNull(errorCode);
    }

    public StreamErrorCode getErrorCode() {
        return this.errorCode;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("StreamException[errorCode=").append((Object)this.errorCode);
        if (this.getMessage() != null) {
            sb.append(", message=").append(this.getMessage());
        }
        if (!this.metadata.isEmpty()) {
            sb.append(", metadata=").append(this.metadata);
        }
        sb.append("]");
        return sb.toString();
    }

    public static StreamException cancelled(String message) {
        return new StreamException(StreamErrorCode.CANCELLED, message);
    }

    public static StreamException cancelled(String message, Throwable cause) {
        return new StreamException(StreamErrorCode.CANCELLED, message, cause);
    }

    public static StreamException unavailable(String message) {
        return new StreamException(StreamErrorCode.UNAVAILABLE, message);
    }

    public static StreamException internal(String message, Throwable cause) {
        return new StreamException(StreamErrorCode.INTERNAL, message, cause);
    }

    public static StreamException resourceExhausted(String message) {
        return new StreamException(StreamErrorCode.RESOURCE_EXHAUSTED, message);
    }

    public static StreamException unauthenticated(String message) {
        return new StreamException(StreamErrorCode.UNAUTHENTICATED, message);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.write(this.errorCode.code());
    }
}

