/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.opensearch.plugin;

import de.virtimo.bpc.opensearch.plugin.Manager;
import de.virtimo.bpc.opensearch.plugin.rest.action.backup.RestDeleteBackupJobOnMasterServerAction;
import de.virtimo.bpc.opensearch.plugin.rest.action.backup.RestGetBackupJobInfosFromBpcMasterServerAction;
import de.virtimo.bpc.opensearch.plugin.rest.action.backup.RestScheduleBackupJobOnMasterServerAction;
import de.virtimo.bpc.opensearch.plugin.rest.action.backup.RestStartBackupJobOnMasterServerAction;
import de.virtimo.bpc.opensearch.plugin.rest.action.config.RestGetConfigAction;
import de.virtimo.bpc.opensearch.plugin.rest.action.filter.RestAddChangesFilterAction;
import de.virtimo.bpc.opensearch.plugin.rest.action.filter.RestGetChangesFiltersAction;
import de.virtimo.bpc.opensearch.plugin.rest.action.filter.RestRemoveAllChangesFilterAction;
import de.virtimo.bpc.opensearch.plugin.rest.action.filter.RestRemoveChangesFilterAction;
import de.virtimo.bpc.opensearch.plugin.rest.action.replication.RestClearLookupJoinCachesOfReplicationJobsAction;
import de.virtimo.bpc.opensearch.plugin.rest.action.replication.RestForcedStartOfReplicationJobAction;
import de.virtimo.bpc.opensearch.plugin.rest.action.replication.RestGetReplicationJobsDetailsAction;
import de.virtimo.bpc.opensearch.plugin.rest.action.replication.RestGetReplicationJobsWithRuntimeStatsFromAllServersAction;
import de.virtimo.bpc.opensearch.plugin.rest.action.replication.RestRefreshLookupJoinsOfAllReplicationJobsAction;
import de.virtimo.bpc.opensearch.plugin.rest.action.replication.RestRefreshLookupJoinsOfReplicationJobAction;
import de.virtimo.bpc.opensearch.plugin.rest.action.replication.RestRestartOfReplicationJobAction;
import de.virtimo.bpc.opensearch.plugin.rest.action.replication.RestSetReplicationJobsAction;
import de.virtimo.bpc.opensearch.plugin.rest.action.servers.RestGetConnectedMasterServerAction;
import de.virtimo.bpc.opensearch.plugin.rest.action.servers.RestGetConnectedServersAction;
import de.virtimo.bpc.opensearch.plugin.rest.action.servers.RestSetMasterServerAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.backupjob.delete.BackupJobDeleteAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.backupjob.delete.TransportBackupJobDeleteAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.backupjob.infos.BackupJobInfosAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.backupjob.infos.TransportBackupJobInfosAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.backupjob.schedule.BackupJobScheduleAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.backupjob.schedule.TransportBackupJobScheduleAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.backupjob.start.BackupJobStartAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.backupjob.start.TransportBackupJobStartAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.bpcconnection.addedorupdated.BpcConnectionAddedOrUpdatedAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.bpcconnection.addedorupdated.TransportBpcConnectionAddedOrUpdatedAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.bpcconnection.removed.BpcConnectionRemovedAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.bpcconnection.removed.TransportBpcConnectionRemovedAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.broadcastwebsocketmessage.to.BroadcastReceivedWebsocketMessageToAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.broadcastwebsocketmessage.to.TransportBroadcastReceivedWebsocketMessageToAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.broadcastwebsocketmessage.toall.BroadcastReceivedWebsocketMessageToAllAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.broadcastwebsocketmessage.toall.TransportBroadcastReceivedWebsocketMessageToAllAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.broadcastwebsocketmessage.toallexceptsender.BroadcastReceivedWebsocketMessageToAllExceptSenderAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.broadcastwebsocketmessage.toallexceptsender.TransportBroadcastReceivedWebsocketMessageToAllExceptSenderAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.changesfilter.add.ChangesFilterAddAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.changesfilter.add.TransportChangesFilterAddAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.changesfilter.remove.ChangesFilterRemoveAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.changesfilter.remove.TransportChangesFilterRemoveAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.changesfilter.removeall.ChangesFilterRemoveAllAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.changesfilter.removeall.TransportChangesFilterRemoveAllAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.indexoperation.IndexOperationAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.indexoperation.TransportIndexOperationAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.initializemodel.InitializeModelAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.initializemodel.TransportInitializeModelAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.masterserver.MasterServerSetAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.masterserver.TransportMasterServerSetAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.replication.job.acknowledged.ReplicationJobActionAcknowledgedAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.replication.job.acknowledged.TransportReplicationJobActionAcknowledgedAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.replication.job.forcedstart.ReplicationJobForcedStartAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.replication.job.forcedstart.TransportReplicationJobForcedStartAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.replication.job.restart.ReplicationJobRestartAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.replication.job.restart.TransportReplicationJobRestartAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.replication.job.start.ReplicationJobStartActionsAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.replication.job.start.TransportReplicationJobStartActionsAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.replication.job.stop.ReplicationJobStopActionsAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.replication.job.stop.TransportReplicationJobStopActionsAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.replication.jobs.set.ReplicationJobsSetAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.replication.jobs.set.TransportReplicationJobsSetAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.replication.jobs.setmodel.ReplicationJobsSetModelAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.replication.jobs.setmodel.TransportReplicationJobsSetModelAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.replication.jobs.stats.ReplicationJobStatsAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.replication.jobs.stats.TransportReplicationJobStatsAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.replication.lookupjoins.clearcaches.ReplicationJobsClearLookupJoinCachesAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.replication.lookupjoins.clearcaches.TransportReplicationJobsClearLookupJoinCachesAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.replication.lookupjoins.refresh.ReplicationJobRefreshLookupJoinsAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.replication.lookupjoins.refresh.TransportReplicationJobRefreshLookupJoinsAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.replication.lookupjoins.refreshalll.ReplicationJobsRefreshAllLookupJoinsAction;
import de.virtimo.bpc.opensearch.plugin.transport.action.replication.lookupjoins.refreshalll.TransportReplicationJobsRefreshAllLookupJoinsAction;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.node.DiscoveryNodes;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.logging.Loggers;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.IndexScopedSettings;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.settings.SettingsFilter;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.common.io.stream.NamedWriteableRegistry;
import org.opensearch.core.index.Index;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.env.Environment;
import org.opensearch.env.NodeEnvironment;
import org.opensearch.index.IndexModule;
import org.opensearch.index.IndexService;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.engine.Engine;
import org.opensearch.index.shard.IndexEventListener;
import org.opensearch.index.shard.IndexingOperationListener;
import org.opensearch.indices.cluster.IndicesClusterStateService;
import org.opensearch.plugins.ActionPlugin;
import org.opensearch.plugins.ClusterPlugin;
import org.opensearch.plugins.Plugin;
import org.opensearch.repositories.RepositoriesService;
import org.opensearch.rest.RestController;
import org.opensearch.rest.RestHandler;
import org.opensearch.script.ScriptService;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.client.Client;
import org.opensearch.watcher.ResourceWatcherService;

public class BpcPlugin
extends Plugin
implements ActionPlugin,
ClusterPlugin {
    private static final org.apache.logging.log4j.Logger LOGGER = Loggers.getLogger(BpcPlugin.class, (String[])new String[]{"os-bpc-plugin"});
    private static BpcPlugin INSTANCE = null;
    public static final String SETTING_WEBSOCKET_PORT = "os-bpc-plugin.websocket.port";
    public static final Integer DEFAULT_WEBSOCKET_PORT = 9201;
    private final Environment environment;
    private Manager manager;

    public BpcPlugin(Settings settings, Path configPath) {
        LOGGER.info("Starting the Virtimo BPC Plugin settings=..., configPath={}", (Object)configPath);
        this.enableWorkaroundForTyrusLoggingToConsole();
        this.environment = new Environment(settings, configPath);
        INSTANCE = this;
    }

    public static BpcPlugin getInstance() {
        return INSTANCE;
    }

    public Manager getManager() {
        return this.manager;
    }

    private void enableWorkaroundForTyrusLoggingToConsole() {
        try {
            Logger rootLogger = Logger.getLogger("");
            for (Handler handler : rootLogger.getHandlers()) {
                if (!(handler instanceof ConsoleHandler)) continue;
                rootLogger.removeHandler(handler);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void close() throws IOException {
        super.close();
        LOGGER.info("The Virtimo BPC Plugin has been stopped.");
    }

    public static int getSettingsValueAsInt(Settings settings, String settingName, int defaultSettingValue) {
        String valueFromSystemProperty;
        String valueFromEnv;
        int settingValue = -1;
        if (settingValue == -1 && (valueFromEnv = System.getenv(settingName)) != null) {
            try {
                settingValue = Integer.parseInt(valueFromEnv);
            }
            catch (NumberFormatException e) {
                LOGGER.error("[System.getenv] : Failed to parse int setting '{}' with value '{}'", (Object)settingName, (Object)valueFromEnv, (Object)e);
            }
        }
        if (settingValue == -1 && (valueFromSystemProperty = System.getProperty(settingName)) != null) {
            try {
                settingValue = Integer.parseInt(valueFromSystemProperty);
            }
            catch (NumberFormatException e) {
                LOGGER.error("[System.getProperty] : Failed to parse int setting '{}' with value '{}'", (Object)settingName, (Object)valueFromSystemProperty, (Object)e);
            }
        }
        if (settingValue == -1) {
            settingValue = settings.getAsInt(settingName, Integer.valueOf(defaultSettingValue));
        }
        return settingValue == -1 ? defaultSettingValue : settingValue;
    }

    public List<Setting<?>> getSettings() {
        return Arrays.asList(Setting.intSetting((String)SETTING_WEBSOCKET_PORT, (int)DEFAULT_WEBSOCKET_PORT, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
    }

    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<RepositoriesService> repositoriesServiceSupplier) {
        LOGGER.debug("createComponents");
        this.manager = new Manager(client, clusterService, environment.settings());
        ArrayList<Object> components = new ArrayList<Object>();
        components.add((Object)this.manager);
        return components;
    }

    public void onIndexModule(IndexModule indexModule) {
        LOGGER.debug("onIndexModule indexModule={} ({})", (Object)indexModule, (Object)indexModule.getIndex().getName());
        indexModule.addIndexEventListener(new IndexEventListener(){

            public void afterIndexRemoved(Index index, IndexSettings indexSettings, IndicesClusterStateService.AllocatedIndices.IndexRemovalReason reason) {
                LOGGER.debug("afterIndexRemoved reason={}, index name='{}'", (Object)reason, (Object)index.getName());
                if (reason == IndicesClusterStateService.AllocatedIndices.IndexRemovalReason.DELETED) {
                    BpcPlugin.this.manager.onIndexDeleted(index.getName());
                }
            }

            public void afterIndexCreated(IndexService indexService) {
                LOGGER.debug("afterIndexCreated index name='{}'", (Object)indexService.index().getName());
                BpcPlugin.this.manager.onIndexCreated(indexService.index().getName());
            }
        });
        indexModule.addIndexOperationListener(new IndexingOperationListener(){
            private Map<Engine.Index, Boolean> identicalSourcesMap;
            private final Object IDENTICAL_SOURCES_MAP_LOCK = new Object();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Engine.Index preIndex(ShardId shardId, Engine.Index index) {
                Boolean identicalSources = BpcPlugin.this.manager.onPreIndexDocumentOperation(shardId.getIndexName(), index);
                if (identicalSources != null) {
                    Object object = this.IDENTICAL_SOURCES_MAP_LOCK;
                    synchronized (object) {
                        if (this.identicalSourcesMap == null) {
                            this.identicalSourcesMap = new HashMap<Engine.Index, Boolean>();
                        }
                        this.identicalSourcesMap.put(index, identicalSources);
                    }
                }
                return index;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void postIndex(ShardId shardId, Engine.Index index, Engine.IndexResult result) {
                Boolean identicalSources = null;
                Object object = this.IDENTICAL_SOURCES_MAP_LOCK;
                synchronized (object) {
                    if (this.identicalSourcesMap != null && this.identicalSourcesMap.containsKey(index)) {
                        identicalSources = this.identicalSourcesMap.get(index);
                        this.identicalSourcesMap.remove(index);
                    }
                }
                BpcPlugin.this.manager.onPostIndexDocumentOperation(shardId.getIndexName(), index, identicalSources);
            }

            public void postDelete(ShardId shardId, Engine.Delete delete, Engine.DeleteResult result) {
                BpcPlugin.this.manager.onDeleteDocumentOperation(shardId.getIndexName(), delete.id(), delete.version());
            }
        });
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        ArrayList<RestHandler> result = new ArrayList<RestHandler>();
        result.add((RestHandler)new RestGetConfigAction(settings));
        result.add((RestHandler)new RestAddChangesFilterAction());
        result.add((RestHandler)new RestGetChangesFiltersAction());
        result.add((RestHandler)new RestRemoveAllChangesFilterAction());
        result.add((RestHandler)new RestRemoveChangesFilterAction());
        result.add((RestHandler)new RestGetConnectedServersAction());
        result.add((RestHandler)new RestGetConnectedMasterServerAction());
        result.add((RestHandler)new RestSetMasterServerAction());
        result.add((RestHandler)new RestClearLookupJoinCachesOfReplicationJobsAction());
        result.add((RestHandler)new RestForcedStartOfReplicationJobAction());
        result.add((RestHandler)new RestGetReplicationJobsDetailsAction());
        result.add((RestHandler)new RestGetReplicationJobsWithRuntimeStatsFromAllServersAction());
        result.add((RestHandler)new RestRefreshLookupJoinsOfAllReplicationJobsAction());
        result.add((RestHandler)new RestRefreshLookupJoinsOfReplicationJobAction());
        result.add((RestHandler)new RestRestartOfReplicationJobAction());
        result.add((RestHandler)new RestSetReplicationJobsAction());
        result.add((RestHandler)new RestGetBackupJobInfosFromBpcMasterServerAction());
        result.add((RestHandler)new RestDeleteBackupJobOnMasterServerAction());
        result.add((RestHandler)new RestStartBackupJobOnMasterServerAction());
        result.add((RestHandler)new RestScheduleBackupJobOnMasterServerAction());
        return result;
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        return Arrays.asList(new ActionPlugin.ActionHandler((ActionType)MasterServerSetAction.INSTANCE, TransportMasterServerSetAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)BpcConnectionRemovedAction.INSTANCE, TransportBpcConnectionRemovedAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)BpcConnectionAddedOrUpdatedAction.INSTANCE, TransportBpcConnectionAddedOrUpdatedAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)InitializeModelAction.INSTANCE, TransportInitializeModelAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)ChangesFilterAddAction.INSTANCE, TransportChangesFilterAddAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)ChangesFilterRemoveAction.INSTANCE, TransportChangesFilterRemoveAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)ChangesFilterRemoveAllAction.INSTANCE, TransportChangesFilterRemoveAllAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)IndexOperationAction.INSTANCE, TransportIndexOperationAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)ReplicationJobStatsAction.INSTANCE, TransportReplicationJobStatsAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)ReplicationJobForcedStartAction.INSTANCE, TransportReplicationJobForcedStartAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)ReplicationJobRefreshLookupJoinsAction.INSTANCE, TransportReplicationJobRefreshLookupJoinsAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)ReplicationJobRestartAction.INSTANCE, TransportReplicationJobRestartAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)ReplicationJobActionAcknowledgedAction.INSTANCE, TransportReplicationJobActionAcknowledgedAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)ReplicationJobsClearLookupJoinCachesAction.INSTANCE, TransportReplicationJobsClearLookupJoinCachesAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)ReplicationJobsRefreshAllLookupJoinsAction.INSTANCE, TransportReplicationJobsRefreshAllLookupJoinsAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)ReplicationJobsSetAction.INSTANCE, TransportReplicationJobsSetAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)ReplicationJobsSetModelAction.INSTANCE, TransportReplicationJobsSetModelAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)ReplicationJobStartActionsAction.INSTANCE, TransportReplicationJobStartActionsAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)ReplicationJobStopActionsAction.INSTANCE, TransportReplicationJobStopActionsAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)BroadcastReceivedWebsocketMessageToAllAction.INSTANCE, TransportBroadcastReceivedWebsocketMessageToAllAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)BroadcastReceivedWebsocketMessageToAllExceptSenderAction.INSTANCE, TransportBroadcastReceivedWebsocketMessageToAllExceptSenderAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)BroadcastReceivedWebsocketMessageToAction.INSTANCE, TransportBroadcastReceivedWebsocketMessageToAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)BackupJobInfosAction.INSTANCE, TransportBackupJobInfosAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)BackupJobDeleteAction.INSTANCE, TransportBackupJobDeleteAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)BackupJobStartAction.INSTANCE, TransportBackupJobStartAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)BackupJobScheduleAction.INSTANCE, TransportBackupJobScheduleAction.class, new Class[0]));
    }
}

